<?php
/**
 * Introduction section
 *
 * This is the template for the content of introduction section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_introduction_section' ) ) :
    /**
    * Add introduction section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_introduction_section() {
    	$options = myself_pro_get_theme_options();
        // Check if introduction is enabled on frontpage
        $introduction_enable = apply_filters( 'myself_pro_section_status', true, 'introduction_section_enable' );

        if ( true !== $introduction_enable ) {
            return false;
        }
        // Get introduction section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_introduction_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render introduction section now.
        myself_pro_render_introduction_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_introduction_section_details' ) ) :
    /**
    * introduction section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input introduction section details.
    */
    function myself_pro_get_introduction_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $introduction_content_type  = $options['introduction_content_type'];
        $introduction_count  = $options['introduction_count'];
        
        $content = array();
        switch ( $introduction_content_type ) {
        	
            case 'custom':
                $custom['title']        = ! empty( $options['introduction_title'] ) ? $options['introduction_title'] : '';
                $custom['excerpt']      = ! empty( $options['introduction_description'] ) ? $options['introduction_description'] : '';
                $custom['image']        = ! empty( $options['introduction_image'] ) ? $options['introduction_image'] : '';
                $custom['url']          = ! empty( $options['introduction_btn_link'] ) ? $options['introduction_btn_link'] : '#';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $introduction_count; $i++ ) {
                    if ( ! empty( $options['introduction_content_page_' . $i] ) )
                        $page_ids[] = $options['introduction_content_page_' . $i];
                }

                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $introduction_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $introduction_count; $i++ ) {
                    if ( ! empty( $options['introduction_content_post_' . $i] ) )
                        $post_ids[] = $options['introduction_content_post_' . $i];
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'orderby'           => 'post__in',
                    'posts_per_page'    => absint( $introduction_count ),
                    'ignore_sticky_posts' => true,
                    );
            break;
            
            case 'category':
                $cat_id = ! empty( $options['introduction_content_category'] ) ? $options['introduction_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $introduction_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }

        if ( 'custom' !== $introduction_content_type ) :
            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = myself_pro_trim_content( 30 );
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : '';
                    $page_post['author']    = myself_pro_author();


                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
        endif;
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// introduction section content details.
add_filter( 'myself_pro_filter_introduction_section_details', 'myself_pro_get_introduction_section_details' );


if ( ! function_exists( 'myself_pro_render_introduction_section' ) ) :
  /**
   * Start introduction section
   *
   * @return string introduction content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_introduction_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $readmore = ! empty( $options['introduction_btn_title'] ) ? $options['introduction_btn_title'] : esc_html__( 'Hire Me', 'myself-pro' );

        if ( empty( $content_details ) ) {
            return;
        } 

        if($options['home_layout'] == 'third-design' || $options['home_layout'] == 'fourth-design' || $options['home_layout'] == 'fifth-design' || $options['home_layout'] == 'seventh-design' || $options['home_layout'] == 'eight-design') : ?>

            <div id="business-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": true, "arrows":false, "autoplay": false, "draggable": true, "fade": false, "adaptiveHeight": true }'>
                <?php foreach ( $content_details as $content ) : ?>

                    <article style="background-image:url('<?php echo esc_url( $content['image'] ); ?>');">
                        <div class="overlay"></div>
                        <div class="wrapper">
                            <div class="business-slider-wrapper">
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </header>

                                <div class="entry-content">
                                    <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                </div><!-- .entry-content-->

                                <?php if ( ! empty( $readmore ) ) : ?>
                                    <div class="business-read-more">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $readmore ); ?></a>
                                    </div><!-- .business-read-more -->
                                <?php endif; ?>

                            </div><!-- .business-slider-wrapper -->
                        </div><!-- .wrapper -->
                    </article>

                <?php  endforeach; ?>
            </div><!-- #featured-slider -->

            <?php elseif($options['home_layout'] == 'sixth-design'):   ?>
                <div id="business-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": true, "arrows":false, "autoplay": false, "draggable": true, "fade": false, "adaptiveHeight": true }'>
                    <?php foreach ( $content_details as $content ) : ?>
                        
                        <article style="background-image:url('<?php echo esc_url( $content['image'] ); ?>');">
                            <div class="overlay"></div>
                            <div class="wrapper">
                                <div class="business-slider-wrapper">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php the_category( '', '', $content['id'] ); ?>
                                        </span><!-- .cat-links -->                            
                                    </div>
                                    
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <div class="entry-meta author-posted-on">

                                        <?php   
                                        echo wp_kses_post( $content['author'] );
                                        myself_pro_posted_on( $content['id'] );  ?>
                                         
                                    </div>
                                </div><!-- .business-slider-wrapper -->
                            </div><!-- .wrapper -->
                        </article>

                    <?php  endforeach; ?>
                </div><!-- #featured-slider -->
            <?php else:   ?>

            <?php foreach ( $content_details as $i => $content ) : ?>

                <?php if ($options['introduction_image_style'] == 'full'){ ?>
                <div id="introduction-section" class="relative" style="background-image:url('<?php echo esc_url( $content['image'] ); ?>');">
                    <?php 
                }else{ ?>
                <div id="introduction-section" class="relative">
                    <?php } ?>

                    <div class="wrapper">

                        <article>
                            <div class="entry-container">
                                <?php if ( ! empty( $content['title'] ) ) : ?>
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_html( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>
                                <?php endif;

                                if ( ! empty( $content['excerpt'] ) ) : ?>
                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->
                                <?php endif; ?>

                                <div class="separator"></div>

                                <div class="buttons">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn btn-1"><?php echo esc_html( $readmore ); ?></a>
                                    <?php if ( ! empty( $options['introduction_alt_btn_title'] ) && ! empty( $options['introduction_alt_btn_link'] ) ) : ?>
                                        <a href="<?php echo esc_url( $options['introduction_alt_btn_link'] ); ?>" class="btn btn-2"><?php echo esc_html( $options['introduction_alt_btn_title'] ); ?></a>
                                    <?php endif; ?>
                                </div><!-- .buttons -->
                            </div><!-- .entry-container -->

                            <?php 
                            if ($options['introduction_image_style'] == 'small' ) {
                                if ( ! empty( $content['image'] ) ) : ?>

                                <div class="featured-image">
                                    <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                                </div><!-- .featured-image -->

                            <?php endif; 
                        }
                        ?>
                                
                        </article>

                    </div><!-- .wrapper -->
                </div><!-- #introduction-section -->

            <?php if($i==0) break; endforeach; ?>

        <?php endif;
    }
endif;