<?php
/**
 * Most Viewed section
 *
 * This is the template for the content of most_viewed section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_most_viewed_section' ) ) :
    /**
    * Add most_viewed section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_most_viewed_section() {
    	$options = myself_pro_get_theme_options();
        // Check if most_viewed is enabled on frontpage
        $most_viewed_enable = apply_filters( 'myself_pro_section_status', true, 'most_viewed_section_enable' );

        if ( true !== $most_viewed_enable ) {
            return false;
        }
        // Get most_viewed section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_most_viewed_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render most_viewed section now.
        myself_pro_render_most_viewed_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_most_viewed_section_details' ) ) :
    /**
    * most_viewed section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input most_viewed section details.
    */
    function myself_pro_get_most_viewed_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $most_viewed_content_type  = $options['most_viewed_content_type'];
        $most_viewed_count = ! empty( $options['most_viewed_count'] ) ? $options['most_viewed_count'] : 4;
        
        $content = array();
        switch ( $most_viewed_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $most_viewed_count; $i++ ) {
                    if ( ! empty( $options['most_viewed_content_page_' . $i] ) )
                        $page_ids[] = $options['most_viewed_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'orderby'           => 'post__in',
                    'posts_per_page'    => absint( $most_viewed_count ),
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $most_viewed_count; $i++ ) {
                    if ( ! empty( $options['most_viewed_content_post_' . $i] ) )
                        $post_ids[] = $options['most_viewed_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $most_viewed_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['most_viewed_content_category'] ) ? $options['most_viewed_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $most_viewed_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'recent':
                $cat_ids = ! empty( $options['most_viewed_category_exclude'] ) ? $options['most_viewed_category_exclude'] : array();
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $most_viewed_count ),
                    'category__not_in'  => ( array ) $cat_ids,
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) :get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg';
                $page_post['author']    = myself_pro_author();
                $page_post['excerpt']   = myself_pro_trim_content( 30 );


                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// most_viewed section content details.
add_filter( 'myself_pro_filter_most_viewed_section_details', 'myself_pro_get_most_viewed_section_details' );


if ( ! function_exists( 'myself_pro_render_most_viewed_section' ) ) :
  /**
   * Start most_viewed section
   *
   * @return string most_viewed content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_most_viewed_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="most-viewed-posts">
            <div class="section-header">
                <h2 class="section-title"><?php echo esc_html($options['most_viewed_title']); ?></h2>
            </div><!-- .section-header -->

            <div class="section-content magazine col-2 clear">
                <?php foreach ( $content_details as $content ) : ?>

                    <article class="has-post-thumbnail">
                        <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                            <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                        </div><!-- .featured-image -->

                        <div class="entry-container">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                            </header>

                            <div class="entry-meta">
                                <?php myself_pro_posted_on( $content['id'] );  ?>

                                <span class="cat-links">
                                    <?php the_category( '', '', $content['id'] ); ?>
                                </span><!-- .cat-links -->
                            </div><!-- .entry-meta -->
                        </div><!-- .entry-container -->
                    </article>
                <?php endforeach; ?>

            </div><!-- .section-content -->
        </div><!-- #most-viewed-posts -->

        <?php 
    }
endif;