<?php
/**
 * My Profile section
 *
 * This is the template for the content of my_profile section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_my_profile_section' ) ) :
    /**
    * Add my_profile section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_my_profile_section() {
    	$options = myself_pro_get_theme_options();
        // Check if my_profile is enabled on frontpage
        $my_profile_enable = apply_filters( 'myself_pro_section_status', true, 'my_profile_section_enable' );

        if ( true !== $my_profile_enable ) {
            return false;
        }
        // Get my_profile section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_my_profile_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render my_profile section now.
        myself_pro_render_my_profile_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_my_profile_section_details' ) ) :
    /**
    * my_profile section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input my_profile section details.
    */
    function myself_pro_get_my_profile_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $my_profile_content_type  = $options['my_profile_content_type'];
        $my_profile_count = ! empty( $options['my_profile_count'] ) ? $options['my_profile_count'] : 4;
        
        $content = array();
        switch ( $my_profile_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $my_profile_count; $i++ ) {
                    if ( ! empty( $options['my_profile_content_page_' . $i] ) )
                        $page_ids[] = $options['my_profile_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $my_profile_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $my_profile_count; $i++ ) {
                    if ( ! empty( $options['my_profile_content_post_' . $i] ) )
                        $post_ids[] = $options['my_profile_content_post_' . $i];
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $my_profile_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['my_profile_content_category'] ) ? $options['my_profile_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $my_profile_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = myself_pro_trim_content( 4 );
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// my_profile section content details.
add_filter( 'myself_pro_filter_my_profile_section_details', 'myself_pro_get_my_profile_section_details' );


if ( ! function_exists( 'myself_pro_render_my_profile_section' ) ) :
  /**
   * Start my_profile section
   *
   * @return string my_profile content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_my_profile_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="my-profile" class="relative page-section">
            <div class="wrapper">
                <div class="profile-slider" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": true, "arrows":false, "autoplay": true, "draggable": true, "fade": false }'>
                    <?php foreach ( $content_details as $content ) : ?>
                        <article class="<?php echo ! empty( $content['image'] ) ? 'has' : 'no'; ?>-post-thumbnail">
                            <header class="entry-header">
                                <a href="<?php echo esc_url( $content['url'] ); ?>">
                                    <h2 class="entry-title"><?php echo esc_html( $content['title'] ); ?></h2>
                                    <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                </a>
                            </header>

                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <div class="overlay"></div>
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="more-link">
                                    <?php echo myself_pro_get_svg( array( 'icon' => 'right-arrow' ) ); ?>
                                </a>
                            </div><!-- .featured-iimage -->
                        </article>
                    <?php endforeach; ?>
                </div><!-- .profile-slider -->
            </div><!-- .wrapper -->
        </div><!-- #my-profile -->

    <?php }
endif;