<?php
/**
 * Photography section
 *
 * This is the template for the content of photography section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_photography_section' ) ) :
    /**
    * Add photography section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_photography_section() {
    	$options = myself_pro_get_theme_options();
        // Check if photography is enabled on frontpage
        $photography_enable = apply_filters( 'myself_pro_section_status', true, 'photography_section_enable' );

        if ( true !== $photography_enable ) {
            return false;
        }
        // Get photography section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_photography_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render photography section now.
        myself_pro_render_photography_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_photography_section_details' ) ) :
    /**
    * photography section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input photography section details.
    */
    function myself_pro_get_photography_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $photography_content_type  = $options['photography_content_type'];
        $photography_count = ! empty( $options['photography_count'] ) ? $options['photography_count'] : 4;
        
        $content = array();
        switch ( $photography_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $photography_count; $i++ ) {
                    if ( ! empty( $options['photography_content_page_' . $i] ) )
                        $page_ids[] = $options['photography_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'orderby'           => 'post__in',
                    'posts_per_page'    => absint( $photography_count ),
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $photography_count; $i++ ) {
                    if ( ! empty( $options['photography_content_post_' . $i] ) )
                        $post_ids[] = $options['photography_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $photography_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['photography_content_category'] ) ? $options['photography_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $photography_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'recent':
                $cat_ids = ! empty( $options['photography_category_exclude'] ) ? $options['photography_category_exclude'] : array();
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $photography_count ),
                    'category__not_in'  => ( array ) $cat_ids,
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']            = get_the_id();
                $page_post['title']         = get_the_title();
                $page_post['url']           = get_the_permalink();
                $page_post['image']  	    = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'thumbnail' ) :get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg';
                $page_post['image_large']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) :get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg';
                $page_post['author']        = myself_pro_author();
                $page_post['excerpt']       = myself_pro_trim_content( 30 );


                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// photography section content details.
add_filter( 'myself_pro_filter_photography_section_details', 'myself_pro_get_photography_section_details' );


if ( ! function_exists( 'myself_pro_render_photography_section' ) ) :
  /**
   * Start photography section
   *
   * @return string photography content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_photography_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }
        if($options['home_layout'] == 'seventh-design') : ?>
            <div id="blog-popular-posts" class="relative page-section">
                <div class="wrapper">
                     <div class="business-section-header">
                        <h2 class="business-section-title"><?php echo esc_html( $options['photography_title'] ); ?></h2>
                    </div><!-- .business-section-header -->

                    <div class="col-2 clear">
                        <?php foreach ( $content_details as $content ) : ?>

                            <article>
                                <div class="popular-post-item">
                                    <div class="blog-featured-image">
                                        <a href="<?php echo esc_url($content['url'] ); ?>"><img src="<?php echo esc_url($content['image_large'] ); ?>"></a>
                                    </div><!-- .blog-featured-image -->

                                    <div class="entry-container">
                                        <span class="cat-links">
                                            <?php the_category( '', '', $content['id'] ); ?>
                                        </span><!-- .cat-links -->

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url($content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>

                                        <?php myself_pro_posted_on( $content['id'] );  ?>
                                        

                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                        </div>

                                        <div class="read-more">
                                            <a href="<?php echo esc_url($content['url'] ); ?>">Read More</a>
                                        </div><!-- .read-more -->
                                    </div><!-- .entry-container -->
                                </div><!-- .popular-post-item -->
                            </article>

                        <?php endforeach; ?>
                    </div><!-- .blog-section-content -->
                </div><!-- .wrapper -->
            </div>

        <?php else:
            $main_post = array_shift($content_details);  ?>

            <div id="magazine-photography" class="relative">
                <div class="section-header">
                    <h2 class="section-title"><?php echo esc_html( $options['photography_title'] ); ?></h2>
                </div><!-- .section-header -->

                <div class="magazine-photography-wrapper">
                    <article class="has-post-thumbnail">
                        <div class="featured-image" style="background-image: url('<?php echo esc_url($main_post['image_large'] ); ?>');">
                            <div class="entry-container">
                                <div class="entry-meta">
                                    <span class="cat-links">
                                        <?php the_category( '', '', $main_post['id'] ); ?>
                                    </span><!-- .cat-links -->      
                                </div><!-- .entry-meta -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url($main_post['url'] ); ?>"><?php echo esc_html($main_post['title'] ); ?></a></h2>
                                </header>

                                <div class="footer-meta">
                                    <?php myself_pro_posted_on( $main_post['id'] );  ?>
                                </div><!-- .footer-meta -->
                            </div><!-- .entry-container -->
                        </div><!-- .featured-image -->
                    </article>
                </div>

                <div class="widget_photography_news clear">
                    <ul>
                        <?php foreach ( $content_details as $content ) : ?>

                            <li>
                                <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                                <div class="entry-container">
                                    <?php myself_pro_posted_on( $content['id'] );  ?>
                                    
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>
                                </div><!-- .entry-container -->
                            </li>

                        <?php endforeach; ?>
                    </ul>
                </div><!-- .widget_recent_news -->
            </div><!-- #reading -->
            
            <?php if( !empty($options['photography_advertisement_image']) && !empty($options['photography_advertisement_url']) ):?>
                <div id="magazine-advertisement-section" class="relative">
                    <a href="<?php echo esc_url($options['photography_advertisement_url']); ?>"><img src="<?php echo esc_url($options['photography_advertisement_image']); ?>" alt="site-advertisement"></a>
                </div>
            <?php endif; ?>
        <?php endif;
    }
endif;