<?php
/**
 * Popular Destination section
 *
 * This is the template for the content of popular destination section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_popular_destination_section' ) ) :
    /**
    * Add popular destination section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_popular_destination_section() {
    	$options = myself_pro_get_theme_options();
        // Check if destination is enabled on frontpage
        $popular_destination_enable = apply_filters( 'myself_pro_section_status', true, 'popular_destination_section_enable' );

        if ( true !== $popular_destination_enable ) {
            return false;
        }
        // Get destination section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_popular_destination_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render destination section now.
        myself_pro_render_popular_destination_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_popular_destination_section_details' ) ) :
    /**
    * popular destination section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input popular destination section details.
    */
    function myself_pro_get_popular_destination_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $popular_destination_content_type  = $options['popular_destination_content_type'];
        $popular_destination_count = ! empty( $options['popular_destination_count'] ) ? $options['popular_destination_count'] : 5;
        
        $content = array();
        switch ( $popular_destination_content_type ) {
        	
            case 'category':
                $cat_id = ! empty( $options['popular_destination_content_category'] ) ? $options['popular_destination_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $popular_destination_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $popular_destination_count; $i++ ) {
                    if ( ! empty( $options['popular_destination_content_page_' . $i] ) )
                        $page_ids[] = $options['popular_destination_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $popular_destination_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $popular_destination_count; $i++ ) {
                    if ( ! empty( $options['popular_destination_content_post_' . $i] ) )
                        $post_ids[] = $options['popular_destination_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $popular_destination_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'trip':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $page_ids = array();

                for ( $i = 1; $i <= $popular_destination_count; $i++ ) {
                    if ( ! empty( $options['popular_destination_content_trip_' . $i] ) )
                        $page_ids[] = $options['popular_destination_content_trip_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'itineraries',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $popular_destination_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'trip-types':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $cat_id = ! empty( $options['popular_destination_content_trip_types'] ) ? $options['popular_destination_content_trip_types'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'itinerary_types',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $popular_destination_count ),
                    );                    
            break;

            case 'destination':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $cat_id = ! empty( $options['popular_destination_content_destination'] ) ? $options['popular_destination_content_destination'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'travel_locations',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $popular_destination_count ),
                    );                    
            break;

            case 'activity':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;
                
                $cat_id = ! empty( $options['popular_destination_content_activity'] ) ? $options['popular_destination_content_activity'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'activity',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $popular_destination_count ),
                    );                    
            break;

            default:
            break;
        }


            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = myself_pro_trim_content( 20 );
                    $page_post['url']       = get_the_permalink();
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// destination section content details.
add_filter( 'myself_pro_filter_popular_destination_section_details', 'myself_pro_get_popular_destination_section_details' );


if ( ! function_exists( 'myself_pro_render_popular_destination_section' ) ) :
  /**
   * Start destination section
   *
   * @return string destination content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_popular_destination_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $popular_destination_content_type  = $options['popular_destination_content_type'];

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="travel-destination-section" class="page-section relative">  
                <div class="wrapper">
                    <div class="business-section-header">
                    <?php if ( ! empty( $options['popular_destination_title'] ) ) : ?>
                        <h2 class="business-section-title"><?php echo esc_html( $options['popular_destination_title'] ); ?></h2>
                    <?php endif;

                    if ( ! empty( $options['popular_destination_title'] ) ) : ?>
                        <p class="business-section-subtitle"><?php echo esc_html( $options['popular_destination_description'] ); ?></p>

                    <?php endif; ?>
                    </div><!-- .business-section-header -->

                    <div class="business-section-content col-3 clear">

                    <?php foreach ( $content_details as $content ) : ?>

                        <article class="has-post-thumbnail">
                            <div class="travel-destination-wrapper">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                </div><!-- .featured-image -->

                                <div class="overlay-one"></div>
                                <div class="overlay-two"></div>

                                <?php if ( ! in_array( $popular_destination_content_type, array( 'category', 'page', 'post' ) ) ) : ?>

                                <span class="popular-destination-trip-duration">
                                <?php wp_travel_get_trip_duration( $content['id'] ); ?>
                                </span>
                                
                                <?php endif;

                                if ( ! in_array( $popular_destination_content_type, array( 'category', 'page', 'post' ) ) ) : 
                                $trip_price = wp_travel_get_price( $content['id'] );
                                ?>

                                <span class="popular-destination-trip-price">
                                <?php echo wp_travel_get_formated_price_currency( $trip_price ); ?>
                                </span>

                            <?php endif; ?>

                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a>
                                    </h2>
                                    </header>

                                    <div class="entry-content">
                                        <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->

                                    <?php if( !empty( $options['popular_destination_read_more'] ) ): ?>
                                    <div class="read-more">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>" class="more-link"><?php echo esc_html( $options['popular_destination_read_more'] ); ?></a>
                                    </div><!-- .read-more -->
                                <?php endif; ?>
                                </div><!-- .entry-container -->
                            </div><!-- .travel-destination-wrapper -->
                        </article>

                        <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div>
        
    <?php }
endif;