<?php
/**
 * Popular Tours section
 *
 * This is the template for the content of popular tours section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_popular_tours_section' ) ) :
    /**
    * Add popular tours section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_popular_tours_section() {
    	$options = myself_pro_get_theme_options();
        // Check if tours is enabled on frontpage
        $popular_tours_enable = apply_filters( 'myself_pro_section_status', true, 'popular_tours_section_enable' );

        if ( true !== $popular_tours_enable ) {
            return false;
        }
        // Get tours section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_popular_tours_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render tours section now.
        myself_pro_render_popular_tours_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_popular_tours_section_details' ) ) :
    /**
    * popular tours section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input popular tours section details.
    */
    function myself_pro_get_popular_tours_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $popular_tours_content_type  = $options['popular_tours_content_type'];
        $popular_tours_count = ! empty( $options['popular_tours_count'] ) ? $options['popular_tours_count'] : 5;
        
        $content = array();
        switch ( $popular_tours_content_type ) {
        	
            case 'category':
                $cat_id = ! empty( $options['popular_tours_content_category'] ) ? $options['popular_tours_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $popular_tours_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $popular_tours_count; $i++ ) {
                    if ( ! empty( $options['popular_tours_content_page_' . $i] ) )
                        $page_ids[] = $options['popular_tours_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $popular_tours_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $popular_tours_count; $i++ ) {
                    if ( ! empty( $options['popular_tours_content_post_' . $i] ) )
                        $post_ids[] = $options['popular_tours_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $popular_tours_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'trip':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $page_ids = array();

                for ( $i = 1; $i <= $popular_tours_count; $i++ ) {
                    if ( ! empty( $options['popular_tours_content_trip_' . $i] ) )
                        $page_ids[] = $options['popular_tours_content_trip_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'itineraries',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $popular_tours_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'trip-types':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $cat_id = ! empty( $options['popular_tours_content_trip_types'] ) ? $options['popular_tours_content_trip_types'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'itinerary_types',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $popular_tours_count ),
                    );                    
            break;

            case 'tours':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $cat_id = ! empty( $options['popular_tours_content_tours'] ) ? $options['popular_tours_content_tours'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'travel_locations',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $popular_tours_count ),
                    );                    
            break;

            case 'activity':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;
                
                $cat_id = ! empty( $options['popular_tours_content_activity'] ) ? $options['popular_tours_content_activity'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'activity',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $popular_tours_count ),
                    );                    
            break;

            default:
            break;
        }


            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = myself_pro_trim_content( 20 );
                    $page_post['url']       = get_the_permalink();
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// tours section content details.
add_filter( 'myself_pro_filter_popular_tours_section_details', 'myself_pro_get_popular_tours_section_details' );


if ( ! function_exists( 'myself_pro_render_popular_tours_section' ) ) :
  /**
   * Start tours section
   *
   * @return string tours content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_popular_tours_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $popular_tours_content_type  = $options['popular_tours_content_type'];

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="travel-tours-section" class="page-section relative">
            <div class="wrapper">
            <?php if( !empty( $options['popular_tours_title'] ) ): ?>
                <div class="business-section-header">
                    <h2 class="business-section-title"><?php echo esc_html( $options['popular_tours_title'] ); ?></h2>
                </div><!-- .business-section-header -->
            <?php endif; ?>

                <div class="business-section-content col-3 clear">

                <?php foreach ( $content_details as $content ) : ?>

                    <article>
                        <div class="travel-tours-wrapper">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                            </div><!-- .featured-image -->

                            <div class="entry-container">
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </header>

                                <?php if ( ! in_array( $popular_tours_content_type, array( 'category', 'page', 'post' ) ) ) :
                                $trip_price = wp_travel_get_price( $content['id'] );
                                ?>

                                <div class="popular-tours-meta">
                                    <span class="popular-tours-trip-duration">
                                        

                                        <?php wp_travel_get_trip_duration( $content['id'] ); ?>

                                        <?php if ( wp_travel_tab_show_in_menu( 'reviews' ) ) :
                                        $average_rating = wp_travel_get_average_rating( $content['id'] ); ?>

                                        <div class="customer-rating wp-travel-average-review"
                                            title="<?php printf( esc_attr__( 'Rated %s out of 5', 'myself-pro' ), $average_rating ); ?>">
                                            <span style="width:<?php echo esc_attr( ( $average_rating / 5 ) * 100 ); ?>%">
                                                <strong itemprop="ratingValue"
                                                    class="rating"><?php echo esc_html( $average_rating ); ?></strong>
                                                <?php printf( esc_html__( 'out of %1$s5%2$s', 'myself-pro' ), '<span itemprop="bestRating">', '</span>' ); ?>
                                            </span>
                                        </div><!-- .customer-rating -->

                                    <?php endif; ?>

                                    </span><!-- .popular-tours-trip-duration -->

                                    <span class="popular-tours-trip-price">
                                    <?php echo wp_travel_get_formated_price_currency( $trip_price ); ?>
                                    </span><!-- .popular-tours-trip-price -->
                                </div><!-- .popular-tours-meta -->
                                <?php endif; ?>
                            </div><!-- .entry-container -->
                        </div><!-- .travel-tours-wrapper -->
                    </article>

                <?php endforeach; ?>

                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div>
        
    <?php }
endif;