<?php
/**
 * Portfolio section
 *
 * This is the template for the content of portfolio section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_portfolio_section' ) ) :
    /**
    * Add portfolio section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_portfolio_section() {
    	$options = myself_pro_get_theme_options();
        // Check if portfolio is enabled on frontpage
        $portfolio_enable = apply_filters( 'myself_pro_section_status', true, 'portfolio_section_enable' );

        if ( true !== $portfolio_enable ) {
            return false;
        }
        // Get portfolio section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_portfolio_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render portfolio section now.
        myself_pro_render_portfolio_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_portfolio_section_details' ) ) :
    /**
    * portfolio section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input portfolio section details.
    */
    function myself_pro_get_portfolio_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $portfolio_content_type  = $options['portfolio_content_type'];
        $portfolio_count = ! empty( $options['portfolio_count'] ) ? $options['portfolio_count'] : 3;
        
        $content = array();
        switch ( $portfolio_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $portfolio_count; $i++ ) {
                    if ( ! empty( $options['portfolio_content_page_' . $i] ) )
                        $page_ids[] = $options['portfolio_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $portfolio_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $portfolio_count; $i++ ) {
                    if ( ! empty( $options['portfolio_content_post_' . $i] ) )
                        $post_ids[] = $options['portfolio_content_post_' . $i];
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $portfolio_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['portfolio_content_category'] ) ? $options['portfolio_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $portfolio_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'trip':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $page_ids = array();

                for ( $i = 1; $i <= $portfolio_count; $i++ ) {
                    if ( ! empty( $options['portfolio_content_trip_' . $i] ) )
                        $page_ids[] = $options['portfolio_content_trip_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'itineraries',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $portfolio_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'trip-types':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $cat_id = ! empty( $options['portfolio_content_trip_types'] ) ? $options['portfolio_content_trip_types'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'itinerary_types',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $portfolio_count ),
                    );                    
            break;

            case 'destination':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;

                $cat_id = ! empty( $options['portfolio_content_destination'] ) ? $options['portfolio_content_destination'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'travel_locations',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $portfolio_count ),
                    );                    
            break;

            case 'activity':
                if ( ! class_exists( 'WP_Travel' ) )
                    return;
                
                $cat_id = ! empty( $options['portfolio_content_activity'] ) ? $options['portfolio_content_activity'] : '';
                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'activity',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $portfolio_count ),
                    );                    
            break;


            default:
            break;
        }


            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = myself_pro_trim_content( 25 );
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// portfolio section content details.
add_filter( 'myself_pro_filter_portfolio_section_details', 'myself_pro_get_portfolio_section_details' );


if ( ! function_exists( 'myself_pro_render_portfolio_section' ) ) :
  /**
   * Start portfolio section
   *
   * @return string portfolio content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_portfolio_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $portfolio_content_type  = $options['portfolio_content_type'];
        $portfolio_description  = $options['portfolio_description'];


        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="my-portfolio" class="relative page-section">
            <div class="wrapper">
                <?php if ( $options['home_layout'] == 'third-design' ) : ?>
                    <div class="business-section-header">
                        <h2 class="business-section-title"><?php echo esc_html( $options['portfolio_title'] ); ?></h2>
                        <?php if($options['home_layout'] == 'third-design' && !empty($portfolio_description) ) : ?>
                            <p class="business-section-subtitle"><?php echo wp_kses_post($portfolio_description); ?></p>
                        <?php endif; ?>
                    </div><!-- .section-header -->
                <?php else: ?>
                    <div class="section-header text-center">
                        <h2 class="business-section-title"><?php echo esc_html( $options['portfolio_title'] ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif; ?>

                <div class="grid">
                    <?php foreach ( $content_details as $content ) : ?>
                        <article class="grid-item">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <div class="overlay"></div>
                                <a href="<?php echo esc_url( $content['url'] ) ?>" class="more-link" tabindex="0">
                                    <?php echo myself_pro_get_svg( array( 'icon' => 'plus' ) ); ?>
                                </a>
                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <?php if ( 'page' !== $portfolio_content_type ) : ?>
                                        <div class="entry-meta">
                                        <?php  
                                            $taxonomy = myself_pro_get_taxonomy($portfolio_content_type); 
                                            $terms =  get_the_terms( $content['id'], $taxonomy);
                                                if( ! empty( $terms ) && ! is_wp_error( $terms ) ) : ?>
                                                    <span class="cat-links">
                                                        <ul class="post-categories">
                                                            <li><a href="<?php echo esc_url(get_term_link($terms[0]->term_id, $taxonomy)); ?>"><?php echo esc_html($terms[0]->name); ?></a></li>
                                                        </ul>
                                                    </span><!-- .cat-links -->
                                            <?php endif; ?>
                                            
                                        </div><!-- .entry-meta -->
                                    <?php endif; ?>
                                </div><!-- .entry-container -->
                            </div><!-- .featured-image -->
                        </article>
                    <?php endforeach; ?>
                </div><!-- .grid -->

                <?php if ( ! empty( $options['portfolio_btn_label'] ) && ! empty( $options['portfolio_btn_url'] ) ) : ?>
                    <div class="read-more">
                        <a href="<?php echo esc_url( $options['portfolio_btn_url'] ); ?>" class="btn"><?php echo esc_html( $options['portfolio_btn_label'] ); ?></a>
                    </div><!-- .read-more -->
                <?php endif; ?>
            </div><!-- .wrapper -->
        </div><!-- #my-portfolio -->
        
    <?php }
endif;