<?php
/**
 * Service section
 *
 * This is the template for the content of service section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_service_section' ) ) :
    /**
    * Add service section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_service_section() {
    	$options = myself_pro_get_theme_options();
        // Check if service is enabled on frontpage
        $service_enable = apply_filters( 'myself_pro_section_status', true, 'service_section_enable' );

        if ( true !== $service_enable ) {
            return false;
        }
        // Get service section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_service_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render service section now.
        myself_pro_render_service_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_service_section_details' ) ) :
    /**
    * service section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input service section details.
    */
    function myself_pro_get_service_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        $service_count = ! empty( $options['service_count'] ) ? $options['service_count'] : 4;
        $content = array();
        $content['cat_ids'] = array();
        $content['details'] = array();
        $cats = array();
        $icon = array();
        
        for ( $i = 1; $i <= $service_count; $i++ ) {
            if ( ! empty( $options['service_content_category_' . $i] ) ) :
                $cat_ids['id'] = $options['service_content_category_' . $i];
                $cats[] = $options['service_content_category_' . $i];
                $icon[] = $i;

                // Push to the main array.
                array_push( $content['cat_ids'], $cat_ids );
            endif;
        }

        $i = 0;
        foreach ( $cats as $cat ) :
            $args = array(
                'post_type'         => 'post',
                'posts_per_page'    => 4,
                'cat'               => absint( $cat ),
                'ignore_sticky_posts'   => true,
                );                    

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                $c = 1;
                $d = 0;
                while ( $query->have_posts() ) : $query->the_post();
                    $content['details'][$i][$d]['title']     = get_the_title();
                    $content['details'][$i][$d]['url']       = get_the_permalink();
                    $content['details'][$i][$d]['icon']      = ! empty( $options['service_content_icon_' . $icon[$i] . '_' . $c] ) ? $options['service_content_icon_' . $icon[$i] . '_' . $c] : 'fa-cogs';
                    $content['details'][$i][$d]['excerpt']   = myself_pro_trim_content( 15 );
                    $c++;
                    $d++;
                endwhile;
            endif;
            $i++;
            wp_reset_postdata();
        endforeach;
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// service section content details.
add_filter( 'myself_pro_filter_service_section_details', 'myself_pro_get_service_section_details' );


if ( ! function_exists( 'myself_pro_render_service_section' ) ) :
  /**
   * Start service section
   *
   * @return string service content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_service_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="my-services" class="relative page-section">
                <div class="wrapper">
                    <?php if ( ! empty( $options['service_title'] ) ) : ?>
                        <div class="section-header">
                            <h2 class="section-title"><?php echo esc_html( $options['service_title'] ) ?></h2>
                        </div><!-- .section-header -->
                    <?php endif; ?>
                </div><!-- .wrapper -->

                <div class="tab-section">
                    <div class="wrapper">
                        <ul class="tabs">
                            <?php $i = 1; 
                            foreach ( $content_details['cat_ids'] as $content ) : 
                                $cat = get_category( $content['id'] ); ?>
                                <li class="tab-link <?php echo ( 1 == $i ) ? 'active': ''; ?>" data-tab="<?php echo esc_attr( $cat->slug ); ?>"><a href="#."><?php echo esc_html( $cat->name ); ?></a></li>
                            <?php $i++; 
                            endforeach; ?>
                        </ul>
                    </div><!-- .wrapper -->
                </div><!-- .tab-section -->

                <div class="tab-section-content col-4">
                    <div class="wrapper">
                        <?php $i = 0; 
                        foreach ( $content_details['cat_ids'] as $content ) : 
                            $cat = get_category( $content['id'] ); ?>
                            <div id="<?php echo esc_attr( $cat->slug ); ?>" class="tab-content <?php echo ( 0 == $i ) ? 'active': ''; ?>">

                                <?php foreach ( $content_details['details'][$i] as $content ) : ?>
                                    <article>
                                        <div class="service-item-wrapper">
                                            <div class="icon">
                                                <a href="<?php echo esc_url( $content['url'] ); ?>"><i class="fa <?php echo esc_attr( $content['icon'] ); ?>"></i></a>
                                            </div><!-- .icon -->

                                            <header class="entry-header">
                                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                            </header>

                                            <div class="entry-content">
                                                <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                            </div><!-- .entry-content -->
                                        </div><!-- .service-item-wrapper -->
                                    </article>
                                <?php endforeach; ?>

                            </div><!-- .tab-content -->
                        <?php $i++; 
                        endforeach; ?>
                    </div><!-- .wrapper -->
                </div><!-- .tab-section-content -->
            </div><!-- #my-services -->
        
    <?php }
endif;