<?php
/**
* Subscription section
*
* This is the template for the content of subscription section
*
* @package Theme Palace
* @subpackage Myself Pro
* @since Myself Pro 1.0.0
*/
if ( ! function_exists( 'myself_pro_add_subscription_section' ) ) :
/**
* Add subscription section
*
*@since Myself Pro 1.0.0
*/
function myself_pro_add_subscription_section() {
  $options = myself_pro_get_theme_options();

// Check if subscription is enabled on frontpage
  $subscription_enable = apply_filters( 'myself_pro_section_status', true, 'subscription_section_enable' );

  if ( true !== $subscription_enable ) {
    return false;
  }

// Render subscription section now.
  myself_pro_render_subscription_section();
}
endif;

if ( ! function_exists( 'myself_pro_render_subscription_section' ) ) :
/**
* Start subscription section
*
* @return string subscription content
* @since Myself Pro 1.0.0
*
*/
function myself_pro_render_subscription_section() {
  if ( ! class_exists( 'Jetpack' ) ) {
    return;
  } elseif ( class_exists( 'Jetpack' ) ) {
    if ( ! Jetpack::is_module_active( 'subscriptions' ) )
      return;
  }
  $options = myself_pro_get_theme_options();

  $subscription_btn_title         = ! empty( $options['subscription_btn_title'] ) ? $options['subscription_btn_title'] : esc_html__( 'Subscribe Now', 'myself-pro' );
  $subscription_title             = ! empty( $options['subscription_title'] ) ? $options['subscription_title'] : '';
  $subscription_description       = ! empty( $options['subscription_description'] ) ? $options['subscription_description'] : '';
  $subscription_sub_title         = ! empty( $options['subscription_sub_title'] ) ? $options['subscription_sub_title'] : esc_html__( 'Subscribe Now', 'myself-pro' );
  $subscription_bg_image          = ! empty( $options['subscription_bg_image'] ) ? $options['subscription_bg_image'] : '#';

  ?>
  
    <div id="business-subscribe-us" class="relative page-section" style="background-image: url('<?php echo esc_url($subscription_bg_image); ?>');">
      <div class="overlay"></div>
      <div class="wrapper">
        <div class="subscribe-form-wrapper">
          <?php if ( ! empty( $subscription_sub_title ) ) : ?>
            <p class="subtitle"><?php echo esc_html($subscription_sub_title); ?></p>
          <?php endif; 

          $subscription_shortcode = '[jetpack_subscription_form title="'.esc_html($subscription_title).'" subscribe_text="'.esc_html($subscription_description).'" subscribe_button="' . esc_html( $subscription_btn_title ) . '" show_subscribers_total="0"]';
          echo do_shortcode( wp_kses_post( $subscription_shortcode ) );

          ?>

        </div><!-- .subscribe-form-wrapper -->
      </div><!-- .wrapper -->
    </div>

  <?php }
  endif;
