<?php
/**
 * Team section
 *
 * This is the template for the content of team section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_team_section' ) ) :
    /**
    * Add team section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_team_section() {
    	$options = myself_pro_get_theme_options();
        // Check if team is enabled on frontpage
        $team_enable = apply_filters( 'myself_pro_section_status', true, 'team_section_enable' );

        if ( true !== $team_enable ) {
            return false;
        }
        // Get team section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_team_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render team section now.
        myself_pro_render_team_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_team_section_details' ) ) :
    /**
    * team section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input team section details.
    */
    function myself_pro_get_team_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $team_content_type  = $options['team_content_type'];
        $team_count = ! empty( $options['team_count'] ) ? $options['team_count'] : 4;
        
        $content = array();
        switch ( $team_content_type ) {

            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $team_count; $i++ ) {
                    if ( ! empty( $options['team_content_page_' . $i] ) )
                        $page_ids[] = $options['team_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $team_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $team_count; $i++ ) {
                    if ( ! empty( $options['team_content_post_' . $i] ) )
                        $post_ids[] = $options['team_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $team_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['team_content_category'] ) ? $options['team_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $team_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }
            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['img']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
          
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// team section content details.
add_filter( 'myself_pro_filter_team_section_details', 'myself_pro_get_team_section_details' );


if ( ! function_exists( 'myself_pro_render_team_section' ) ) :
  /**
   * Start team section
   *
   * @return string team content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_team_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        } 
        ?>
        <div id="business-team" class="relative page-section">
            <div class="wrapper">
                <div class="business-section-header">
                    <?php if ( ! empty( $options['team_title'] ) ) : ?>
                        <h2 class="business-section-title"><?php echo esc_html( $options['team_title'] ); ?></h2>
                    <?php endif; ?>
                    <?php if ( ! empty( $options['team_sub_title'] ) && $options['home_layout'] != 'eight-design' ) : ?>
                        <p class="business-section-subtitle"><?php echo wp_kses_post( $options['team_sub_title'] ); ?></p>
                    <?php endif; ?>
                </div><!-- .section-header -->
                <div class="business-section-content clear <?php echo esc_attr( $options['team_column'] ); ?>">
                    <?php 
                    $i = 1;
                    foreach ( $content_details as $content ) : ?>
                        <article>
                            <div class="business-team-item">
                            <?php if( !empty( $content['img'] ) ): ?>
                                <div class="featured-image">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['img'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                                </div><!-- .featured-image -->
                            <?php endif; ?>

                                <div class="entry-container">
                                    <header class="entry-header">
                                       <?php if ( ! empty( $content['title'] ) ) : ?>
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        <?php endif; ?>
                                    </header>
                                    <?php if ( ! empty( $options['team_content_custom_position_' . $i ] ) ) : ?>
                                        <div class="entry-content">
                                            <p><?php echo esc_html( $options['team_content_custom_position_' . $i ] ); ?></p>
                                        </div><!-- .entry-content -->
                                    <?php endif; ?>

                                    <div class="social-icons">
                                        <ul>
                                            <?php 
                                            $team_socials = ! empty( $options['team_social_' . $i ] ) ? explode( '|', $options['team_social_' . $i ] ) : array(); 

                                            foreach ( $team_socials as $team_social ) : ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $team_social ); ?>"><?php echo myself_pro_return_social_icon( $team_social ); ?></a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div><!-- .entry-container -->
                            </div><!-- .business-team-item -->
                        </article>
                    <?php 
                    $i++;
                    endforeach; ?>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #featured-team -->
            
    <?php }
endif;