<?php
/**
 * Testimonial section
 *
 * This is the template for the content of testimonial section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_testimonial_section' ) ) :
    /**
    * Add testimonial section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_testimonial_section() {
    	$options = myself_pro_get_theme_options();
        // Check if testimonial is enabled on frontpage
        $testimonial_enable = apply_filters( 'myself_pro_section_status', true, 'testimonial_section_enable' );

        if ( true !== $testimonial_enable ) {
            return false;
        }
        // Get testimonial section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_testimonial_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render testimonial section now.
        myself_pro_render_testimonial_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_testimonial_section_details' ) ) :
    /**
    * testimonial section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input testimonial section details.
    */
    function myself_pro_get_testimonial_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $testimonial_content_type  = $options['testimonial_content_type'];
        $testimonial_count = ! empty( $options['testimonial_count'] ) ? $options['testimonial_count'] : 4;
        
        $content = array();
        switch ( $testimonial_content_type ) {
        	
            case 'page':
                $page_ids = array();
                $position = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_page_' . $i] ) ) :
                        $page_ids[] = $options['testimonial_content_page_' . $i];
                        $position[] = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $position = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_post_' . $i] ) ) :
                        $post_ids[] = $options['testimonial_content_post_' . $i];
                        $position[] = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['testimonial_content_category'] ) ? $options['testimonial_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $testimonial_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'custom':
                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    $custom['title']        = ! empty( $options['testimonial_title_' . $i] ) ? $options['testimonial_title_' . $i] : '';
                    $custom['excerpt']      = ! empty( $options['testimonial_description_' . $i] ) ? $options['testimonial_description_' . $i] : '';
                    $custom['image']        = ! empty( $options['testimonial_image_' . $i] ) ? $options['testimonial_image_' . $i] : '';
                    $custom['url']          = ! empty( $options['testimonial_link_' . $i] ) ? $options['testimonial_link_' . $i] : '';
                    $custom['position']     = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';


                    // Push to the main array.
                    array_push( $content, $custom );
                }
            break;

            default:
            break;
        }

        if ( 'custom' !== $testimonial_content_type ) {
            // Run The Loop.
            $query = new WP_Query( $args );
            $i = 0;
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['position']  = ( 'category' !== $testimonial_content_type && ! empty( $position[$i] ) ) ? $position[$i] : '';
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = myself_pro_trim_content( 20 );
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'thumbnail' ) : '';

                    // Push to the main array.
                    array_push( $content, $page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();
        }
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// testimonial section content details.
add_filter( 'myself_pro_filter_testimonial_section_details', 'myself_pro_get_testimonial_section_details' );


if ( ! function_exists( 'myself_pro_render_testimonial_section' ) ) :
  /**
   * Start testimonial section
   *
   * @return string testimonial content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_testimonial_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $testimonial_count = ! empty( $options['testimonial_count'] ) ? $options['testimonial_count'] : 4;
        if ( $testimonial_count < 4 ) {
            $class = 'classic-slider';
        } else {
            $class= 'modern-slider';
        }

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="testimonial-slider-section" class="relative page-section <?php echo esc_attr($class); ?>">
            <?php if ( ! empty( $options['testimonial_title'] ) ) : ?>
                <div class="wrapper">
                    <div class="section-header text-center">
                        <h2 class="section-title"><?php echo esc_html( $options['testimonial_title'] ); ?></h2>
                    </div><!-- .section-header -->
                </div><!-- .wrapper -->
            <?php endif; ?>

            <div class="wrapper testimonial-wrapper">
                <div class="testimonial-slider">
                    <?php foreach ( $content_details as $content ) : ?>
                        <article>
                            <div class="quote-icon">
                                <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/uploads/quote.png' ); ?>">
                            </div><!-- .quote-icon -->

                            <?php if ( ! empty( $content['excerpt'] ) ) : ?>
                                <div class="entry-content">
                                    <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                </div><!-- .entry-content -->
                            <?php endif; ?>

                            <div class="title-wrapper">
                                <?php if ( ! empty( $content['image'] ) ) : ?>
                                    <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                                <?php endif;

                                if ( ! empty( $content['title'] ) || ! empty( $content['position'] ) ) : ?>
                                    <header class="entry-header">
                                        <?php if ( ! empty( $content['title'] ) ) : ?>
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        <?php endif; 

                                        if ( ! empty( $content['position'] ) ) : ?>
                                            <span class="position"><?php echo esc_html( $content['position'] ); ?></span>
                                        <?php endif; ?>
                                    </header>
                                <?php endif; ?>
                            </div><!-- .title-wrapper -->
                        </article>
                    <?php endforeach; ?>
                </div><!-- .testimonial-slider -->
            </div><!-- .wrapper -->
        </div><!-- #testimonial-slider-section -->

    <?php }
endif;