<?php
/**
 * Video section
 *
 * This is the template for the content of video section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_video_section' ) ) :
    /**
    * Add video section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_video_section() {
    	$options = myself_pro_get_theme_options();
        // Check if video is enabled on frontpage
        $video_enable = apply_filters( 'myself_pro_section_status', true, 'video_section_enable' );

        if ( true !== $video_enable ) {
            return false;
        }

        // Render video section now.
        myself_pro_render_video_section();
    }
endif;

if ( ! function_exists( 'myself_pro_render_video_section' ) ) :
  /**
   * Start video section
   *
   * @return string video content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_video_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();

        if ( empty( $options['video_title'] ) && empty( $options['video_description'] ) && empty( $options['video_url'] ) ) {
            return;
        } ?>
            <div id="my-video" class="relative page-section">
                <div class="wrapper">
                    <?php if ( ! empty( $options['video_title'] ) ) : ?>
                        <div class="section-header text-center">
                            <h2 class="section-title"><?php echo esc_html( $options['video_title'] ); ?></h2>
                        </div><!-- .section-header -->
                    <?php endif; 

                    if ( ! empty( $options['video_description'] ) ) : ?>
                        <div class="section-content">
                            <p><?php echo esc_html( $options['video_description'] ); ?></p>
                        </div><!-- .section-content -->
                    <?php endif;

                    if ( ! empty( $options['video_url'] ) ) : ?>
                        <div class="video-wrapper">
                            <?php echo do_shortcode( '[video src="' . esc_url( $options['video_url'] ) . '"]' ); ?>
                        </div><!-- .video-wrapper -->
                    <?php endif; ?>
                </div><!-- .wrapper -->
            </div><!-- #my-video -->

    <?php }
endif;