<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package Myself Pro
 */

// Includes the files needed for the theme updater
if ( ! class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include dirname( __FILE__ ) . '/theme-updater-admin.php';
}

$theme = wp_get_theme( get_template() );

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'https://themepalace.com', // Site where EDD is hosted
		'item_name'      => $theme->get( 'Name' ), // Name of theme
		'theme_slug'     => $theme->get( 'TextDomain' ), // Theme slug
		'version'        => $theme->get( 'Version' ), // The current version of this theme
		'author'         => $theme->get( 'Author' ), // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => 'https://themepalace.com/my-account/', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),
	// Strings
	array(
		'theme-license'             => __( 'Theme License', 'myself-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'myself-pro' ),
		'license-key'               => __( 'License Key', 'myself-pro' ),
		'license-action'            => __( 'License Action', 'myself-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'myself-pro' ),
		'activate-license'          => __( 'Activate License', 'myself-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'myself-pro' ),
		'renew'                     => __( 'Renew?', 'myself-pro' ),
		'unlimited'                 => __( 'unlimited', 'myself-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'myself-pro' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'myself-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'myself-pro' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'myself-pro' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'myself-pro' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'myself-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'myself-pro' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'myself-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'myself-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'myself-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'myself-pro' ),
		'license-key-invalid'       => __( 'Invalid license.', 'myself-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'myself-pro' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'myself-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'myself-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'myself-pro' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'myself-pro' ),
		'key-not-activated'         => __( '%1$s License Key has not been activated, so the theme is inactive. %2$sClick here%3$s to activate the license key and the theme.', 'myself-pro' ),
		'get-license-key'           => __( 'Get API key from %s.', 'myself-pro' ),
		'theme-palace'              => __( 'Theme Palace', 'myself-pro' ),
	)
);
