<?php
/**
 * Theme Palace wp travel hooks overwrite
 *
 * @package Theme Palace
 * @subpackage Mega Tour Pro
 * @since Mega Tour Pro 1.0.0
 */

function myself_pro_search_form() { ?>
	<div class="wp-travel-search">
		<form method="get" name="wp-travel_search" action="<?php echo esc_url( home_url( '/' ) );  ?>" > 
			<input type="hidden" name="post_type" value="itineraries" />
			<p>
				<?php $placeholder = esc_attr__( 'Ex: Trekking', 'myself-pro' ); ?>
				<input type="text" name="s" id="s" value="<?php echo ( isset( $_GET['s'] ) ) ? esc_textarea( wp_unslash( $_GET['s'] ) ) : ''; ?>" placeholder="<?php echo esc_attr( apply_filters( 'wp_travel_search_placeholder', $placeholder ) ); ?>">
			</p>
			<p>
				<?php
				$taxonomy = 'itinerary_types';
				$args = array(
					'show_option_all'    => esc_attr__( 'Trip Type', 'myself-pro' ),
					'hide_empty'         => 0,
					'selected'           => 1,
					'hierarchical'       => 1,
					'name'               => $taxonomy,
					'class'              => 'wp-travel-taxonomy',
					'taxonomy'           => $taxonomy,
					'selected'           => ( isset( $_GET[$taxonomy] ) ) ? esc_textarea( wp_unslash( $_GET[$taxonomy] ) ) : 0,
					'value_field'		 => 'slug',
				);

				wp_dropdown_categories( $args, $taxonomy );
				?>
			</p>
			<p>
				<?php
				$taxonomy = 'travel_locations';
				$args = array(
					'show_option_all'    => esc_attr__( 'Location', 'myself-pro' ),
					'hide_empty'         => 0,
					'selected'           => 1,
					'hierarchical'       => 1,
					'name'               => $taxonomy,
					'class'              => 'wp-travel-taxonomy',
					'taxonomy'           => $taxonomy,
					'selected'           => ( isset( $_GET[$taxonomy] ) ) ? esc_textarea( wp_unslash( $_GET[$taxonomy] ) ) : 0,
					'value_field'		 => 'slug',
				);

				wp_dropdown_categories( $args, $taxonomy );
				?>
			</p>
			<?php
			if ( class_exists('WP_Travel') ) {
				WP_Travel::create_nonce_field();
			}
			?>
			<p class="wp-travel-search"><input type="submit" name="wp-travel_search" id="wp-travel-search" class="button button-primary" value="<?php esc_attr_e( 'Search', 'myself-pro' ) ?>"  /></p>
		</form>
	</div>	
	<?php
}
add_filter( 'wp_travel_search_form', 'myself_pro_search_form', 999 );

/**
 * Add html for Keywords.
 *
 * @param int $post_id ID of current post.
 */
function myself_pro_trip_duration( $post_id ) {
	if ( ! $post_id ) {
		return;
	}
	$start_date	= get_post_meta( $post_id, 'wp_travel_start_date', true );
	$end_date 	= get_post_meta( $post_id, 'wp_travel_end_date', true );
	
	$fixed_departure = get_post_meta( $post_id, 'wp_travel_fixed_departure', true );
	$fixed_departure = ( $fixed_departure ) ? $fixed_departure : 'yes';
	$fixed_departure = apply_filters( 'wp_travel_fixed_departure_defalut', $fixed_departure );

	$trip_duration = get_post_meta( $post_id, 'wp_travel_trip_duration', true );
	$trip_duration = ( $trip_duration ) ? $trip_duration : 0;
	$trip_duration_night = get_post_meta( $post_id, 'wp_travel_trip_duration_night', true );
	$trip_duration_night = ( $trip_duration_night ) ? $trip_duration_night : 0;
	
	if ( 'yes' === $fixed_departure ) : 
		if ( $start_date && $end_date ) :
			
			$date_format = get_option( 'date_format' );
			if ( ! $date_format ) :
				$date_format = 'jS M, Y';
			endif;
			printf( '%s - %s', date( $date_format, strtotime( $start_date ) ), date( $date_format, strtotime( $end_date ) ) ); 

		endif;
	else :
		if ( $trip_duration || $trip_duration_night ) :
			printf( __( '%1$s Day(s) %2$s Night(s)', 'myself-pro' ), $trip_duration, $trip_duration_night );
		endif;

	endif;
}

remove_action( 'wp_travel_after_main_content', 'wp_travel_archive_wrapper_close' );
add_action( 'wp_travel_after_main_content', 'myself_pro_archive_wrapper_close' );
/**
 * Add html for Keywords.
 */
function myself_pro_archive_wrapper_close() { ?>
	</div>
<?php }

remove_action( 'wp_travel_single_trip_after_title', 'myself_pro_wptravel_trip_price', 1 );
remove_action( 'wp_travel_single_trip_after_title', 'myself_pro_wptravel_single_excerpt', 1 );
remove_action( 'wp_travel_single_trip_after_header', 'myself_pro_wptravel_trip_map', 20 );
add_action( 'myself_pro_trip_after_title', 'myself_pro_wptravel_trip_price', 10 );
add_action( 'myself_pro_trip_after_title', 'myself_pro_wptravel_single_excerpt', 20 );
add_action( 'myself_pro_trip_after_title', 'myself_pro_wptravel_trip_map', 30 );

function myself_pro_wptravel_tab_show_in_menu( $attr ){
	if ( function_exists( 'wptravel_tab_show_in_menu' ) ) {
		return wptravel_tab_show_in_menu( $attr );
	} elseif ( function_exists( 'wp_travel_tab_show_in_menu' ) ) {
		return wp_travel_tab_show_in_menu( $attr );
	}
}

function myself_pro_wptravel_get_settings( ){
	if ( function_exists( 'wptravel_get_settings' ) ) {
		return wptravel_get_settings( );
	} elseif ( function_exists( 'wp_travel_get_settings' ) ) {
		return wp_travel_get_settings( );
	}
}

function myself_pro_wptravel_get_currency_symbol( $currency_code ){
	if ( function_exists( 'wptravel_get_currency_symbol' ) ) {
		return wptravel_get_currency_symbol( $currency_code );
	} elseif ( function_exists( 'wp_travel_get_currency_symbol' ) ) {
		return wp_travel_get_currency_symbol( $currency_code );
	}
}

function myself_pro_wptravel_get_trip_duration( $trip_id ){
	if ( function_exists( 'wptravel_get_trip_duration' ) ) {
		return wptravel_get_trip_duration( $trip_id );
	} elseif ( function_exists( 'wp_travel_get_trip_duration' ) ) {
		return wp_travel_get_trip_duration( $trip_id );
	}
}

function myself_pro_wptravel_get_average_rating( $attr ){
	if ( function_exists( 'wptravel_get_average_rating' ) ) {
		return wptravel_get_average_rating( $attr );
	} elseif ( function_exists( 'wp_travel_get_average_rating' ) ) {
		return wp_travel_get_average_rating( $attr );
	}
}

function myself_pro_wptravel_get_formated_price_currency( $attr ){
	if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
		return wptravel_get_formated_price_currency( $attr );
	} elseif ( function_exists( 'wp_travel_get_formated_price_currency' ) ) {
		return wp_travel_get_formated_price_currency( $attr );
	}
}

function myself_pro_wptravel_search_form( ){
	if ( function_exists( 'wptravel_search_form' ) ) {
		return wptravel_search_form();
	} elseif ( function_exists( 'wp_travel_search_form' ) ) {
		return wp_travel_search_form( );
	}
}

function myself_pro_wptravel_get_template_part( $attr1, $attr2 ){
	if ( function_exists( 'wptravel_get_template_part' ) ) {
		return wptravel_get_template_part( $attr1, $attr2 );
	} elseif ( function_exists( 'wp_travel_get_template_part' ) ) {
		return wp_travel_get_template_part( $attr1, $attr2 );
	}
}

function myself_pro_wptravel_is_enable_sale( $trip_id, $price_key = '' ) {
	if ( method_exists( 'WP_Travel_Helpers_Trips', 'is_sale_enabled' ) ) {
		$args = array(
			'trip_id' => $trip_id,
		);
		return WP_Travel_Helpers_Trips::is_sale_enabled( $args );
	} else {
		return wp_travel_is_enable_sale( $trip_id, $price_key );
	}
}

function myself_pro_wptravel_get_group_size( $trip_id ){
	if ( function_exists( 'wptravel_get_group_size' ) ) {
		return wptravel_get_group_size( $trip_id );
	} elseif ( function_exists( 'wp_travel_get_group_size' ) ) {
		return wp_travel_get_group_size( $trip_id );
	}
}

function myself_pro_wptravel_get_archive_view_mode( ){
	if ( function_exists( 'wptravel_get_archive_view_mode' ) ) {
		return wptravel_get_archive_view_mode( );
	} elseif ( function_exists( 'wp_travel_get_archive_view_mode' ) ) {
		return wp_travel_get_archive_view_mode( );
	}
}

function myself_pro_wptravel_get_post_thumbnail( $attr1, $attr2 ){
	if ( function_exists( 'wptravel_get_post_thumbnail' ) ) {
		return wptravel_get_post_thumbnail( $attr1, $attr2 );
	} elseif ( function_exists( 'wp_travel_get_post_thumbnail' ) ) {
		return wp_travel_get_post_thumbnail( $attr1, $attr2 );
	}
}

function myself_pro_wptravel_trip_rating( $trip_id ){
	if ( function_exists( 'wptravel_trip_rating' ) ) {
		return wptravel_trip_rating( $trip_id );
	} elseif ( function_exists( 'wp_travel_trip_rating' ) ) {
		return wp_travel_trip_rating( $trip_id );
	}
}

function myself_pro_wptravel_get_review_count( ){
	if ( function_exists( 'wptravel_get_review_count' ) ) {
		return wptravel_get_review_count( );
	} elseif ( function_exists( 'wp_travel_get_review_count' ) ) {
		return wp_travel_get_review_count( );
	}
}

function myself_pro_wptravel_trip_price( $trip_id ){
	if ( function_exists( 'wptravel_trip_price' ) ) {
		return wptravel_trip_price( $trip_id );
	} elseif ( function_exists( 'wp_travel_trip_price' ) ) {
		return wp_travel_trip_price( $trip_id );
	}
}

function myself_pro_wptravel_single_excerpt( $id ){
	if ( function_exists( 'wptravel_single_excerpt' ) ) {
		return wptravel_single_excerpt( $id );
	} elseif ( function_exists( 'wp_travel_single_excerpt' ) ) {
		return wp_travel_single_excerpt( $id );
	}
}

function myself_pro_wptravel_trip_map( $id ){
	if ( function_exists( 'wptravel_trip_map' ) ) {
		return wptravel_trip_map( $id );
	} elseif ( function_exists( 'wp_travel_trip_map' ) ) {
		return wp_travel_trip_map( $id );
	}
}

function myself_pro_wptravel_do_deprecated_action( $tag, $args, $version, $replacement = '', $message = '' ){
	if ( function_exists( 'wptravel_do_deprecated_action' ) ) {
		return wptravel_do_deprecated_action( $tag, $args, $version, $replacement = '', $message = '' );
	} elseif ( function_exists( 'wp_travel_do_deprecated_action' ) ) {
		return wp_travel_do_deprecated_action( $tag, $args, $version, $replacement = '', $message = '' );
	}
}
