<?php
/**
 * Admin functions.
 *
 * @package Clean_Commerce
 */

add_action( 'admin_menu', 'clean_commerce_admin_menu_page' );

/**
 * Register admin page.
 *
 * @since 1.0.0
 */
function clean_commerce_admin_menu_page() {

	$theme = wp_get_theme( get_template() );

	add_theme_page(
		$theme->display( 'Name' ),
		$theme->display( 'Name' ),
		'manage_options',
		'clean-commerce-pro',
		'clean_commerce_do_admin_page'
	);

}

/**
 * Render admin page.
 *
 * @since 1.0.0
 */
function clean_commerce_do_admin_page() {

	$theme = wp_get_theme( get_template() );
	?>
	<div class="wrap about-wrap">
		<h1><?php echo $theme->display( 'Name' ); ?></h1>
		<div class="two-col">

			<div class="col about-text">
				<?php
					$description_raw = $theme->display( 'Description' );
					$main_description = explode( 'Official', $description_raw );
					?>
				<?php echo wp_kses_post( $main_description[0] ); ?>
				<p><?php esc_html_e( 'Version', 'clean-commerce-pro' ); ?>:&nbsp;<?php echo esc_html( $theme->display( 'Version' ) ); ?></p>
			</div><!-- .col -->

			<div class="col about-img">
				<a href="<?php echo esc_url( $theme->display( 'ThemeURI' ) ); ?>" target="_blank"><img src="<?php echo trailingslashit( get_template_directory_uri() ); ?>screenshot.png" alt="<?php echo esc_attr( $theme->display( 'Name' ) ); ?>" /></a>
			</div><!-- .col -->

		</div><!-- .two-col -->
		<div class="four-col">

			<div class="col">

				<h3><i class="dashicons dashicons-admin-customizer"></i><?php esc_html_e( 'Theme Options', 'clean-commerce-pro' ); ?></h3>

				<p>
					<?php esc_html_e( 'We have used Customizer API for theme options which will help you preview your changes live and fast.', 'clean-commerce-pro' ); ?>
				</p>

				<p>
					<a class="button button-primary" href="<?php echo wp_customize_url(); ?>"><?php esc_html_e( 'Customize', 'clean-commerce-pro' ); ?></a>
				</p>

			</div><!-- .col -->

			<div class="col">

				<h3><i class="dashicons dashicons-book-alt"></i><?php esc_html_e( 'Theme Instructions', 'clean-commerce-pro' ); ?></h3>
				<p>
					<?php esc_html_e( 'We have prepared detailed theme instructions which will help you to customize theme as you prefer.', 'clean-commerce-pro' ); ?>
				</p>

				<p>
					<a class="button button-primary" href="<?php echo esc_url( 'https://themepalace.com/theme-instructions/clean-commerce-pro/' ); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'clean-commerce-pro' ); ?></a>
				</p>

			</div><!-- .col -->


			<div class="col">

				<h3><i class="dashicons dashicons-sos"></i><?php esc_html_e( 'Help &amp; Support', 'clean-commerce-pro' ); ?></h3>

				<p>
					<?php esc_html_e( 'If you have any question/feedback regarding theme, please post in our official support forum.', 'clean-commerce-pro' ); ?>
				</p>

				<p>
					<a class="button button-primary" href="<?php echo esc_url( 'https://themepalace.com/forum/clean-commerce-pro/' ); ?>" target="_blank"><?php esc_html_e( 'Get Support', 'clean-commerce-pro' ); ?></a>
				</p>

			</div><!-- .col -->


			<div class="col">

				<h3><i class="dashicons dashicons-admin-network"></i><?php esc_html_e( 'Theme License', 'clean-commerce-pro' ); ?></h3>
				<p>
					<?php esc_html_e( 'Want regular updates of theme? Please activate theme using valid license which you get from purchase order.', 'clean-commerce-pro' ); ?>
				</p>

				<p>
					<a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=clean-commerce-pro-license' ) ); ?>" ><?php esc_html_e( 'License', 'clean-commerce-pro' ); ?></a>
				</p>

			</div><!-- .col -->

		</div><!-- .four-col -->


	</div><!-- .wrap -->
	<?php

}

/**
 * Load admin scripts.
 *
 * @since 1.0.0
 *
 * @param string $hook Current page hook.
 */
function clean_commerce_load_admin_scripts( $hook ) {

	if ( 'appearance_page_clean-commerce-pro' === $hook ) {

		$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		wp_enqueue_style( 'clean-commerce-admin', get_template_directory_uri() . '/css/admin' . $min . '.css', false, '1.0.0' );

	}

}
add_action( 'admin_enqueue_scripts', 'clean_commerce_load_admin_scripts' );
