<?php
/**
 * Default theme options.
 *
 * @package Clean_Commerce
 */

if ( ! function_exists( 'clean_commerce_get_default_theme_options' ) ) :

	/**
	 * Get default theme options
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function clean_commerce_get_default_theme_options() {

		$defaults = array();

		// Header.
		$defaults['show_title']                 = true;
		$defaults['show_tagline']               = true;
		$defaults['contact_number']             = '9841123123';
		$defaults['contact_email']              = 'demo@example.com';
		$defaults['contact_address']            = 'Kathmandu, Nepal';
		$defaults['show_social_in_header']      = false;
		$defaults['enable_sticky_primary_menu'] = false;
		$defaults['search_in_header']           = true;
		$defaults['cart_in_header']             = true;
		$defaults['wishlist_in_header']         = true;
		$defaults['login_link_in_header']       = true;
		$defaults['loggedin_text']              = esc_html__( 'My Account', 'clean-commerce-pro' );
		$defaults['nonloggedin_text']           = esc_html__( 'Login / Register', 'clean-commerce-pro' );
		$defaults['cart_text']                  = esc_html__( 'Shopping Cart', 'clean-commerce-pro' );

		// Search.
		$defaults['search_placeholder'] = esc_html__( 'Search...', 'clean-commerce-pro' );

		// Layout.
		$defaults['global_layout']           = 'right-sidebar';
		$defaults['archive_layout']          = 'excerpt';
		$defaults['archive_image']           = 'large';
		$defaults['archive_image_alignment'] = 'center';
		$defaults['single_image']            = 'large';
		$defaults['single_image_alignment']  = 'center';

		// Home Page.
		$defaults['home_content_status'] = true;

		// Pagination.
		$defaults['pagination_type'] = 'numeric';

		//Load fonts from CDN
		$defaults['load_font_cdn']       = false;

		// Content Meta.
		$defaults['show_meta_date']       = true;
		$defaults['show_meta_author']     = true;
		$defaults['show_meta_categories'] = true;
		$defaults['show_meta_tags']       = true;
		$defaults['show_meta_comment']    = true;

		// Footer.
		$defaults['copyright_text']        = esc_html__( 'Copyright &copy; [the-year] [the-site-link]. All rights reserved.', 'clean-commerce-pro' );
		$defaults['powered_by_text']       = esc_html__( 'Clean Commerce Pro by ', 'clean-commerce-pro' ) . '<a target="_blank" rel="designer" href="https://wenthemes.com/">WEN Themes</a>';
		$defaults['reset_footer_content']  = false;
		$defaults['show_social_in_footer'] = false;
		$defaults['go_to_top']             = true;

		// Blog.
		$defaults['excerpt_length'] = 40;
		$defaults['read_more_text'] = esc_html__( 'READ MORE', 'clean-commerce-pro' );
		$defaults['exclude_categories'] = '';

		// Author Bio.
		$defaults['author_bio_in_single']           = true;
		$defaults['author_bio_show_recent_posts']   = false;
		$defaults['author_bio_recent_posts_number'] = 3;

		// Breadcrumb.
		$defaults['breadcrumb_type'] = 'simple';

		// Carousel Options.
		$defaults['featured_carousel_status']           = 'disabled';
		$defaults['featured_carousel_type']             = 'featured-category';
		$defaults['featured_carousel_number']           = 5;
		$defaults['featured_carousel_category']         = 0;
		$defaults['featured_carousel_product_category'] = 0;
		$defaults['featured_carousel_enable_autoplay']  = false;
		$defaults['featured_carousel_transition_delay'] = 3;

		// Font.
		$font_keys = clean_commerce_get_font_family_theme_settings_options();
		if ( ! empty( $font_keys ) ) {
			foreach ( $font_keys as $k => $v ) {
			  $defaults[ $k ]  = $v['default'];
			}
		}
		$defaults['reset_font_settings'] = false;

		// Color.
		$colors = clean_commerce_get_default_colors();
		if ( ! empty( $colors ) ) {
		  foreach ( $colors as $key => $val ) {
		    $defaults[ $key ] = $val;
		  }
		}

		// Pass through filter.
		$defaults = apply_filters( 'clean_commerce_filter_default_theme_options', $defaults );
		return $defaults;
	}

endif;
