<?php
/**
 * Helper functions related to customizer and options.
 *
 * @package Clean_Commerce
 */

if ( ! function_exists( 'clean_commerce_get_global_layout_options' ) ) :

	/**
	 * Returns global layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function clean_commerce_get_global_layout_options() {

		$choices = array(
			'left-sidebar'            => esc_html__( 'Primary Sidebar - Content', 'clean-commerce-pro' ),
			'right-sidebar'           => esc_html__( 'Content - Primary Sidebar', 'clean-commerce-pro' ),
			'three-columns'           => esc_html__( 'Three Columns ( Secondary - Content - Primary )', 'clean-commerce-pro' ),
			'three-columns-pcs'       => esc_html__( 'Three Columns ( Primary - Content - Secondary )', 'clean-commerce-pro' ),
			'three-columns-cps'       => esc_html__( 'Three Columns ( Content - Primary - Secondary )', 'clean-commerce-pro' ),
			'three-columns-psc'       => esc_html__( 'Three Columns ( Primary - Secondary - Content )', 'clean-commerce-pro' ),
			'three-columns-pcs-equal' => esc_html__( 'Three Columns ( Equal Primary - Content - Secondary )', 'clean-commerce-pro' ),
			'three-columns-scp-equal' => esc_html__( 'Three Columns ( Equal Secondary - Content - Primary )', 'clean-commerce-pro' ),
			'no-sidebar'              => esc_html__( 'No Sidebar', 'clean-commerce-pro' ),
		);
		$output = apply_filters( 'clean_commerce_filter_layout_options', $choices );
		return $output;

	}

endif;

if ( ! function_exists( 'clean_commerce_get_pagination_type_options' ) ) :

	/**
	 * Returns pagination type options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function clean_commerce_get_pagination_type_options() {

		$choices = array(
			'default'               => esc_html__( 'Default (Older / Newer Post)', 'clean-commerce-pro' ),
			'numeric'               => esc_html__( 'Numeric', 'clean-commerce-pro' ),
			'infinite-scroll'       => esc_html__( 'Infinite Scroll - Scroll', 'clean-commerce-pro' ),
			'infinite-scroll-click' => esc_html__( 'Infinite Scroll - Click', 'clean-commerce-pro' ),
		);
		return $choices;

	}

endif;

if ( ! function_exists( 'clean_commerce_get_breadcrumb_type_options' ) ) :

	/**
	 * Returns breadcrumb type options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function clean_commerce_get_breadcrumb_type_options() {

		$choices = array(
			'disabled' => esc_html__( 'Disabled', 'clean-commerce-pro' ),
			'simple'   => esc_html__( 'Enabled', 'clean-commerce-pro' ),
		);

		return $choices;

	}

endif;


if ( ! function_exists( 'clean_commerce_get_archive_layout_options' ) ) :

	/**
	 * Returns archive layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function clean_commerce_get_archive_layout_options() {

		$choices = array(
			'full'    => esc_html__( 'Full Post', 'clean-commerce-pro' ),
			'excerpt' => esc_html__( 'Post Excerpt', 'clean-commerce-pro' ),
		);
		$output = apply_filters( 'clean_commerce_filter_archive_layout_options', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'clean_commerce_get_image_sizes_options' ) ) :

	/**
	 * Returns image sizes options.
	 *
	 * @since 1.0.0
	 *
	 * @param bool  $add_disable True for adding No Image option.
	 * @param array $allowed Allowed image size options.
	 * @return array Image size options.
	 */
	function clean_commerce_get_image_sizes_options( $add_disable = true, $allowed = array(), $show_dimension = true ) {

		global $_wp_additional_image_sizes;
		$get_intermediate_image_sizes = get_intermediate_image_sizes();
		$choices = array();
		if ( true === $add_disable ) {
			$choices['disable'] = esc_html__( 'No Image', 'clean-commerce-pro' );
		}
		$choices['thumbnail'] = esc_html__( 'Thumbnail', 'clean-commerce-pro' );
		$choices['medium']    = esc_html__( 'Medium', 'clean-commerce-pro' );
		$choices['large']     = esc_html__( 'Large', 'clean-commerce-pro' );
		$choices['full']      = esc_html__( 'Full (original)', 'clean-commerce-pro' );

		if ( true === $show_dimension ) {
			foreach ( array( 'thumbnail', 'medium', 'large' ) as $key => $_size ) {
				$choices[ $_size ] = $choices[ $_size ] . ' (' . get_option( $_size . '_size_w' ) . 'x' . get_option( $_size . '_size_h' ) . ')';
			}
		}

		if ( ! empty( $_wp_additional_image_sizes ) && is_array( $_wp_additional_image_sizes ) ) {
			foreach ( $_wp_additional_image_sizes as $key => $size ) {
				$choices[ $key ] = $key;
				if ( true === $show_dimension ){
					$choices[ $key ] .= ' ('. $size['width'] . 'x' . $size['height'] . ')';
				}
			}
		}

		if ( ! empty( $allowed ) ) {
			foreach ( $choices as $key => $value ) {
				if ( ! in_array( $key, $allowed ) ) {
					unset( $choices[ $key ] );
				}
			}
		}

		return $choices;

	}

endif;

if ( ! function_exists( 'clean_commerce_get_featured_carousel_content_options' ) ) :

	/**
	 * Returns the featured carousel content options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function clean_commerce_get_featured_carousel_content_options() {

		$choices = array(
			'disabled'  => esc_html__( 'Disabled', 'clean-commerce-pro' ),
			'home-page' => esc_html__( 'Static Front Page and Shop Page', 'clean-commerce-pro' ),
		);

		$output = apply_filters( 'clean_commerce_filter_featured_carousel_content_options', $choices );

		return $output;

	}

endif;

if ( ! function_exists( 'clean_commerce_get_featured_carousel_type' ) ) :

	/**
	 * Returns the featured carousel type.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function clean_commerce_get_featured_carousel_type() {

		$choices = array(
			'featured-category'         => __( 'Featured Category', 'clean-commerce-pro' ),
			'featured-product-category' => __( 'Featured Product Category', 'clean-commerce-pro' ),
		);

		$output = apply_filters( 'clean_commerce_filter_featured_carousel_type', $choices );

		if ( ! empty( $output ) ) {
			ksort( $output );
		}

		return $output;

	}

endif;

if ( ! function_exists( 'clean_commerce_get_image_alignment_options' ) ) :

	/**
	 * Returns image options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function clean_commerce_get_image_alignment_options() {

		$choices = array(
			'none'   => _x( 'None', 'Alignment', 'clean-commerce-pro' ),
			'left'   => _x( 'Left', 'Alignment', 'clean-commerce-pro' ),
			'center' => _x( 'Center', 'Alignment', 'clean-commerce-pro' ),
			'right'  => _x( 'Right', 'Alignment', 'clean-commerce-pro' ),
		);
		return $choices;

	}

endif;

if( ! function_exists( 'clean_commerce_get_customizer_font_options' ) ) :

	/**
	 * Returns customizer font options.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_get_customizer_font_options(){

		$web_fonts = clean_commerce_get_web_fonts();
		$os_fonts  = clean_commerce_get_os_fonts();

		$web_fonts = array_merge( $web_fonts, $os_fonts );

		if ( ! empty( $web_fonts ) ) {
			ksort( $web_fonts );
		}

		$choices = array();

		if ( ! empty( $web_fonts ) ) {
			foreach ( $web_fonts as $k => $v ) {
				$choices[$k] = esc_html( $v['label'] );
			}
		}
		return $choices;

	}

endif;

if( ! function_exists( 'clean_commerce_get_web_fonts' ) ) :

	/**
	 * Returns web font options.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_get_web_fonts(){

		$choices = array(
			'philosopher' => array(
				'name'  => 'Philosopher',
				'label' => "'Philosopher', sans-serif",
				),
			'rajdhani' => array(
				'name'  => 'Rajdhani',
				'label' => "'Rajdhani', sans-serif",
				),
			'open-sans' => array(
				'name'  => 'Open Sans',
				'label' => "'Open Sans', sans-serif",
				),
			'pt-sans' => array(
				'name'  => 'PT Sans',
				'label' => "'PT Sans', sans-serif",
				),
			'merriweather-sans' => array(
				'name'  => 'Merriweather Sans',
				'label' => "'Merriweather Sans', sans-serif",
				),
			'roboto' => array(
				'name'  => 'Roboto',
				'label' => "'Roboto', sans-serif",
				),
			'arizonia' => array(
				'name'  => 'Arizonia',
				'label' => "'Arizonia', cursive",
				),
			'raleway' => array(
				'name'  => 'Raleway',
				'label' => "'Raleway', sans-serif",
				),
			'droid-sans' => array(
				'name'  => 'Droid Sans',
				'label' => "'Droid Sans', sans-serif",
				),
			'lato' => array(
				'name'  => 'Lato',
				'label' => "'Lato', sans-serif",
				),
			'dosis' => array(
				'name'  => 'Dosis',
				'label' => "'Dosis', sans-serif",
				),
			'slabo-27px' => array(
				'name'  => 'Slabo 27px',
				'label' => "'Slabo 27px', serif",
				),
			'oswald' => array(
				'name'  => 'Oswald',
				'label' => "'Oswald', sans-serif",
				),
			'pt-sans-narrow' => array(
				'name'  => 'PT Sans Narrow',
				'label' => "'PT Sans Narrow', sans-serif",
				),
			'josefin-slab' => array(
				'name'  => 'Josefin Slab',
				'label' => "'Josefin Slab', serif",
				),
			'alegreya' => array(
				'name'  => 'Alegreya',
				'label' => "'Alegreya', serif",
				),
			'exo' => array(
				'name'  => 'Exo',
				'label' => "'Exo', sans-serif",
				),
			'signika' => array(
				'name'  => 'Signika',
				'label' => "'Signika', sans-serif",
				),
			'lobster' => array(
				'name'  => 'Lobster',
				'label' => "'Lobster', cursive",
				),
			'indie-flower' => array(
				'name'  => 'Indie Flower',
				'label' => "'Indie Flower', cursive",
				),
			'shadows-into-light' => array(
				'name'  => 'Shadows Into Light',
				'label' => "'Shadows Into Light', cursive",
				),
			'kaushan-script' => array(
				'name'  => 'Kaushan Script',
				'label' => "'Kaushan Script', cursive",
				),
			'dancing-script' => array(
				'name'  => 'Dancing Script',
				'label' => "'Dancing Script', cursive",
				),
			'fredericka-the-great' => array(
				'name'  => 'Fredericka the Great',
				'label' => "'Fredericka the Great', cursive",
				),
			'covered-by-your-grace' => array(
				'name'  => 'Covered By Your Grace',
				'label' => "'Covered By Your Grace', cursive",
				),
			);
		$choices = apply_filters( 'clean_commerce_filter_web_fonts', $choices );

		if ( ! empty( $choices ) ) {
			ksort( $choices );
		}

		return $choices;

	}

endif;

if( ! function_exists( 'clean_commerce_get_os_fonts' ) ) :

	/**
	 * Returns OS font options.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_get_os_fonts(){

		$choices = array(
			'arial' => array(
				'name'  => 'Arial',
				'label' => "'Arial', sans-serif",
				),
			'georgia' => array(
				'name'  => 'Georgia',
				'label' => "'Georgia', serif",
				),
			'cambria' => array(
				'name'  => 'Cambria',
				'label' => "'Cambria', Georgia, serif",
				),
			'tahoma' => array(
				'name'  => 'Tahoma',
				'label' => "'Tahoma', Geneva, sans-serif",
				),
			'sans-serif' => array(
				'name'  => 'Sans Serif',
				'label' => "'Sans Serif', Arial",
				),
			'verdana' => array(
				'name'  => 'Verdana',
				'label' => "'Verdana', Geneva, sans-serif",
				),
			);
		$choices = apply_filters( 'clean_commerce_filter_os_fonts', $choices );

		if ( ! empty( $choices ) ) {
			ksort( $choices );
		}
		return $choices;

	}

endif;

if( ! function_exists( 'clean_commerce_get_font_family_from_key' ) ) :

	/**
	 * Return font family from font slug.
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Font slug.
	 * @return string Font name.
	 */
	function clean_commerce_get_font_family_from_key( $key ){

		$output = '';

		$web_fonts = clean_commerce_get_web_fonts();
		$os_fonts  = clean_commerce_get_os_fonts();

		$fonts = array_merge( $web_fonts, $os_fonts );

		if ( isset( $fonts[ $key ] ) ) {
			$output = $fonts[ $key ]['label'];
		}
		return $output;

	}

endif;

if( ! function_exists( 'clean_commerce_get_font_family_theme_settings_options' ) ) :

	/**
	 * Returns font family theme settings options.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_get_font_family_theme_settings_options(){

		$choices = array(
			'font_site_title' => array(
				'label'   => __( 'Site Title', 'clean-commerce-pro' ),
				'default' => 'rajdhani',
				),
			'font_site_tagline' => array(
				'label'   => __( 'Site Tagline', 'clean-commerce-pro' ),
				'default' => 'open-sans',
				),
			'font_site_default' => array(
				'label'   => __( 'Default', 'clean-commerce-pro' ),
				'default' => 'open-sans',
				),

			'font_content_title' => array(
				'label'   => __( 'Content Title', 'clean-commerce-pro' ),
				'default' => 'rajdhani',
				),
			'font_content_body' => array(
				'label'   => __( 'Content Body', 'clean-commerce-pro' ),
				'default' => 'open-sans',
				),
			'font_heading_tags' => array(
				'label'   => __( 'Heading Tags', 'clean-commerce-pro' ),
				'default' => 'rajdhani',
				),
			'font_navigation' => array(
				'label'   => __( 'Navigation', 'clean-commerce-pro' ),
				'default' => 'rajdhani',
				),
			);
		return $choices;

	}

endif;

if( ! function_exists( 'clean_commerce_get_default_colors' ) ) :

  /**
   * Returns default colors.
   *
   * @since 1.0.0
   *
   * @param string $scheme Color scheme.
   * @return array Color values based on scheme.
   */
	function clean_commerce_get_default_colors( $scheme = 'default' ){

		$output = array();

		switch ( $scheme ) {

			case 'default':
			default:
			$output = array(
				// Basic.
				'color_basic_text'                    => '#111111',
				'color_basic_link'                    => '#272727',
				'color_basic_link_hover'              => '#ff7d06',
				'color_basic_heading'                 => '#111111',
				'color_basic_button_background'       => '#ff7d06',
				'color_basic_button_text'             => '#ffffff',
				'color_basic_button_background_hover' => '#ff4922',
				'color_basic_button_text_hover'       => '#ffffff',

				// Top Header.
				'color_top_header_background'                    	 => '#222',
				'color_top_header_icon'                        		 => '#ff7d06',
				'color_top_header_text'                       		 => '#fff',
				'color_top_header_link'                       		 => '#fff',
				'color_top_header_link_hover'                        => '#fff',


				// Header.
				'color_header_background'                     => '#ffffff',
				'color_header_title'                          => '#222',
				'color_header_title_hover'                    => '#ff7d06',
				'color_header_tagline'                        => '#222',
				'color_header_link'                           =>  '#222',
				'color_header_link_hover'                     =>  '#ff7d06',

				// Primary Menu.
				'color_primary_menu_background'               		=> '#0a0a0a',
				'color_primary_menu_link'               			=> '#ffffff',
				'color_primary_menu_link_hover'          			=> '#ffffff',
				'color_primary_menu_link_hover_border'  			=> '#ffffff',
				'color_primary_submenu_background_hover'			=> '#0a0a0a',
				'color_primary_menu_search_icon'               		=> '#ff7d06',
				'color_primary_menu_search_icon_hover'          	=> '#ffffff',
				'color_primary_menu_search_icon_background'  		=> '#ffffff',
				'color_primary_menu_search_icon_background_hover'	=> '#ff7d06',

				// Featured Carousel.
				'color_featured_carousel_background'                     => '#ffffff',
				'color_featured_carousel_title'                          => '#ffffff',
				'color_featured_carousel_title_hover'                    => '#ffffff',
				'color_featured_carousel_hover_overlay'                  => '#ff7d06',

				// Content.
				'color_content_background'     			=> '#ffffff',
				'color_primary_content_background'      => '#ffffff',
				'color_content_title'           		=> '#727272',
				'color_content_text'            		=> '#727272',
				'color_content_link'            		=> '#727272',
				'color_content_link_hover'      		=> '#ff7d06',
				'color_content_meta_link'       		=> '#727272',
				'color_content_meta_link_hover' 		=> '#ff7d06',
				'color_content_meta_icon'       		=> '#727272',

				// Sidebar.
				'color_sidebar_widget_background'       => '#ffffff',
				'color_sidebar_title'      				=> '#727272',
				'color_sidebar_text'       				=> '#727272',
				'color_sidebar_link'       				=> '#727272',
				'color_sidebar_link_hover' 				=> '#ff7d06',
				'color_sidebar_list_icon'  				=> '#ff7d06',

				// Home Page Widgets.
				'color_home_widgets_background' => '#ffffff',
				'color_home_widgets_title'      => '#727272',
				'color_home_widgets_subtitle'   =>  '#727272',
				'color_home_widgets_text'       => '#727272',
				'color_home_widgets_link'       => '#727272',
				'color_home_widgets_link_hover' => '#ff7d06',


				// Footer Widgets.
				'color_footer_widgets_background' => '#111111',
				'color_footer_widgets_title'      => '#dddddd',
				'color_footer_widgets_text'       => '#dddddd',
				'color_footer_widgets_link'       => '#aaaaaa',
				'color_footer_widgets_link_hover' => '#ffffff',

				// Footer area.
				'color_footer_area_background' => '#111111',
				'color_footer_area_text'       => '#dddddd',
				'color_footer_area_link'       => '#dddddd',
				'color_footer_area_link_hover' => '#ffffff',

				// Go To Top.
				'color_goto_top_icon'             => '#ffffff',
				'color_goto_top_icon_hover'       => '#ffffff',
				'color_goto_top_background'       => '#000000',
				'color_goto_top_background_hover' => '#333333',

				// Pagination.
				'color_pagination_link'                  => '#fff',
				'color_pagination_link_hover'            => '#fff',
				'color_pagination_link_background'       => '#b3afaf',
				'color_pagination_link_background_hover' => '#ff7d06',

				// Breadcrumb.
				'color_breadcrumb_background' => '#ffffff',
				'color_breadcrumb_link'       => '#222222',
				'color_breadcrumb_link_hover' => '#ff7d06',
				'color_breadcrumb_text'       => '#ff7d06',



			);
			break;

		} // End switch.

	return $output;

	}

endif;


if( ! function_exists( 'clean_commerce_get_color_theme_settings_options' ) ) :

  /**
   * Returns color theme settings options.
   *
   * @since 1.0.0
   */
  function clean_commerce_get_color_theme_settings_options(){

  	$choices = array(

		// Basic.
  		'color_basic_text' => array(
  			'label'   => __( 'Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_heading' => array(
  			'label'   => __( 'Heading Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_text' => array(
  			'label'   => __( 'Button Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_background' => array(
  			'label'   => __( 'Button Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_text_hover' => array(
  			'label'   => __( 'Button Text Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_background_hover' => array(
  			'label'   => __( 'Button Background Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_basic',
  			),

		// Top Header.
  		'color_top_header_background' => array(
  			'label'   => __( 'Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_top_header',
  			),

  		'color_top_header_icon' => array(
  			'label'   => __( 'Icon Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_top_header',
  		),
  		'color_top_header_text' => array(
  			'label'   => __( 'Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_top_header',
  		),
  		'color_top_header_link' => array(
  			'label'   => __( 'Links Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_top_header',
  		),
		'color_top_header_link_hover' => array(
  			'label'   => __( 'Links Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_top_header',
  		),


		// Header.
  		'color_header_background' => array(
  			'label'   => __( 'Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_title' => array(
  			'label'   => __( 'Site Title Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_title_hover' => array(
  			'label'   => __( 'Site Title Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_tagline' => array(
  			'label'   => __( 'Site Tagline Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_link' => array(
  			'label'   => __( 'Links Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_link_hover' => array(
  			'label'   => __( 'Links Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_header',
  			),

		// Primary Menu.
		'color_primary_menu_background' => array(
  			'label'   => __( 'Bakground Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_submenu_background_hover' => array(
  			'label'   => __( 'Submenu Background Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_link_hover_border' => array(
  			'label'   => __( 'Menu Hover Border Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_search_icon' => array(
  			'label'   => __( 'Icon Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_search_icon_hover' => array(
  			'label'   => __( 'Icon Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_search_icon_background' => array(
  			'label'   => __( 'Icon Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_search_icon_background_hover' => array(
  			'label'   => __( 'Icon Background Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
		// Featured Carousel.
  		'color_featured_carousel_background' => array(
  			'label'   => __( 'Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_title' => array(
  			'label'   => __( 'Title Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_title_hover' => array(
  			'label'   => __( 'Title Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_hover_overlay' => array(
  			'label'   => __( 'Hover Overlay Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
		// Content.
  		'color_content_background' => array(
  			'label'   => __( 'Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_primary_content_background' => array(
  			'label'   => __( 'Primary Content Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_title' => array(
  			'label'   => __( 'Title Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_text' => array(
  			'label'   => __( 'Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_link' => array(
  			'label'   => __( 'Meta Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_link_hover' => array(
  			'label'   => __( 'Meta Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_icon' => array(
  			'label'   => __( 'Meta Icon Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_content',
  			),

		// Home Page Widgets.
  		'color_home_widgets_background' => array(
  			'label'   => __( 'Widget Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_title' => array(
  			'label'   => __( 'Widget Title Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_text' => array(
  			'label'   => __( 'Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_home_widgets',
  			),

		// Sidebar.
		'color_sidebar_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_title' => array(
  			'label'   => __( 'Title Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_text' => array(
  			'label'   => __( 'Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_list_icon' => array(
  			'label'   => __( 'List Icon Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_sidebar',
		),

		// Footer area.
  		'color_footer_area_background' => array(
  			'label'   => __( 'Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_text' => array(
  			'label'   => __( 'Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_area',
  			),

		// Go To Top.
  		'color_goto_top_icon' => array(
  			'label'   => __( 'Icon Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_icon_hover' => array(
  			'label'   => __( 'Icon Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_background' => array(
  			'label'   => __( 'Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_background_hover' => array(
  			'label'   => __( 'Background Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_goto_top',
  			),

		// Pagination.
  		'color_pagination_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_background' => array(
  			'label'   => __( 'Link Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_background_hover' => array(
  			'label'   => __( 'Link Background Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_pagination',
  			),



		// Breadcrumb.
  		'color_breadcrumb_background' => array(
  			'label'   => __( 'Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),
  		'color_breadcrumb_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),
  		'color_breadcrumb_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),
  		'color_breadcrumb_text' => array(
  			'label'   => __( 'Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),


		// Footer widgets.
  		'color_footer_widgets_background' => array(
  			'label'   => __( 'Background Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_title' => array(
  			'label'   => __( 'Title Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_text' => array(
  			'label'   => __( 'Text Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_link' => array(
  			'label'   => __( 'Link Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'clean-commerce-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),


  		);

    return $choices;

  }

endif;

if ( ! function_exists( 'clean_commerce_get_color_panels_options' ) ) :

  /**
   * Returns color panels options.
   *
   * @since 1.0.0
   */
	function clean_commerce_get_color_panels_options() {

		$choices = array(
			'color_panel_main' => array(
				'label' => __( 'Color Options', 'clean-commerce-pro' ),
				),
			);
		return $choices;
	}

endif;
if ( ! function_exists( 'clean_commerce_get_color_sections_options' ) ) :

  /**
   * Returns color sections options.
   *
   * @since 1.0.0
   */
	function clean_commerce_get_color_sections_options() {

		$choices = array(
			'color_section_basic' => array(
				'label' => __( 'Basic Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_top_header' => array(
				'label' => __( 'Top Header Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_header' => array(
				'label' => __( 'Header Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_primary_menu' => array(
				'label' => __( 'Primary Menu Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_featured_carousel' => array(
				'label' => __( 'Featured Carousel Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_featured_content' => array(
				'label' => __( 'Featured Content Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_content' => array(
				'label' => __( 'Content Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_sidebar' => array(
				'label' => __( 'Sidebar Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_breadcrumb' => array(
				'label' => __( 'Breadcrumb Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_goto_top' => array(
				'label' => __( 'Go To Top Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_pagination' => array(
				'label' => __( 'Pagination Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_footer_widgets' => array(
				'label' => __( 'Footer Widgets Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),

			'color_section_footer_area' => array(
				'label' => __( 'Footer Area Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_home_widgets' => array(
				'label' => __( 'Home Widget Color Options', 'clean-commerce-pro' ),
				'panel' => 'color_panel_main',
				),
			);

		return $choices;
	}

endif;

if ( ! function_exists( 'clean_commerce_get_numbers_dropdown_options' ) ) :

	/**
	 * Returns numbers dropdown options.
	 *
	 * @since 1.0.0
	 *
	 * @param int    $min    Min.
	 * @param int    $max    Max.
	 * @param string $prefix Prefix.
	 * @param string $suffix Suffix.
	 * @return array Options array.
	 */
	function clean_commerce_get_numbers_dropdown_options( $min = 1, $max = 4, $prefix = '', $suffix = '' ) {

		$output = array();

		if ( $min <= $max ) {
			for ( $i = $min; $i <= $max; $i++ ) {
				$string = $prefix . $i . $suffix;
				$output[ $i ] = $string;
			}
		}

		return $output;

	}

endif;
