<?php
/**
 * CSS related hooks.
 *
 * This file contains hook functions which are related to CSS.
 *
 * @package Clean_Commerce
 */

if ( ! function_exists( 'clean_commerce_trigger_custom_css_action' ) ) :

	/**
	 * Do action theme Custom CSS.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_trigger_custom_css_action() {

		/**
		 * Hook - clean_commerce_action_theme_custom_css.
		 */
		do_action( 'clean_commerce_action_theme_custom_css' );

	}

endif;

add_action( 'wp_head', 'clean_commerce_trigger_custom_css_action', 99 );

if ( ! function_exists( 'clean_commerce_add_theme_custom_font_css' ) ) :

	/**
	 * Inject theme custom font CSS.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_add_theme_custom_font_css() {

		$custom_css = '';

		$font_settings = clean_commerce_get_font_family_theme_settings_options();

		$required_fonts = array();

		if ( ! empty( $font_settings ) ) {
			foreach ( $font_settings as $key => $val ) {
				$option_value = clean_commerce_get_option( $key );
				if ( ! empty( $option_value ) && $val['default'] !== $option_value ) {
					$required_fonts[ $key ] = $option_value;
				}
			}
		}
		if ( empty( $required_fonts ) ) {

			// We do not need extra CSS.
			return;
		}

		foreach ( $required_fonts as $key => $font ) {

			$family = clean_commerce_get_font_family_from_key( $font );

			if ( ! empty( $family ) ) {

				switch ( $key ) {
					case 'font_site_default':
						$custom_css .= 'body{font-family:' . $family . '}' . "\n";
					break;

					case 'font_site_title':
						$custom_css .= '.site-title{font-family:' . $family . '}' . "\n";
					break;

					case 'font_site_tagline':
						$custom_css .= '.site-description{font-family:' . $family . '}' . "\n";
					break;

					case 'font_heading_tags':
						$custom_css .= 'h1,h2,h3,h4,h5,h6{font-family:' . $family . '}' . "\n";
					break;

					case 'font_content_title':
						$custom_css .= '.entry-header .entry-title{font-family:' . $family . '}' . "\n";
					break;

					case 'font_content_body':
						$custom_css .= '#content{font-family:' . $family . '}' . "\n";
					break;

					case 'font_navigation':
						$custom_css .= '#site-navigation ul li a{font-family:' . $family . '}' . "\n";
					break;

					default:
					break;
				}
			}
		}

		// Render style.
		if ( ! empty( $custom_css ) ) {
			echo '<style type="text/css">';
			echo $custom_css;
			echo '</style>';
		}

	}

endif;

add_action( 'clean_commerce_action_theme_custom_css', 'clean_commerce_add_theme_custom_font_css' );


if ( ! function_exists( 'clean_commerce_add_theme_custom_color_css' ) ) :

	/**
	 * Inject theme custom color CSS.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_add_theme_custom_color_css() {

		$custom_css = '';

		$color_settings = clean_commerce_get_color_theme_settings_options();

		$default = clean_commerce_get_default_colors();

		$required_colors = array();

		if ( ! empty( $color_settings ) ) {
		  foreach ($color_settings as $key => $val ) {
		    $option_value = clean_commerce_get_option( $key );
		    if ( ! empty( $option_value ) && $default[$key] != $option_value ) {
		      $required_colors[ $key ] = $option_value;
		    }
		  }
		}
		if ( empty( $required_colors ) ) {
		  // We do not need extra CSS.
		  return;
		}

		foreach ( $required_colors as $key => $color ) {

			switch ( $key ) {

				// Basic.
				case 'color_basic_text':
				  $custom_css .= 'body{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_link':
				  $custom_css .= 'a,a:visited{color:' . $color . '}' . "\n";
				  $custom_css .= '#mobile-trigger i,.meta-nav{background-color:' . $color . '}' . "\n";
				   $custom_css .= '.meta-nav{border-color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_link_hover':
				  $custom_css .= 'a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_heading':
				  $custom_css .= 'h1,h2,h3,h4,h5,h6{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_button_text':
				$custom_css .= '#infinite-handle span,.search-box > a,a.button,.search-form .search-submit,.nav-links a,a.cta-button-primary,button, input[type="button"], input[type="reset"], input[type="submit"],#infinite-handle span button, #infinite-handle span button,.clean-commerce-woocommerce .slick-arrow i,.clean_commerce_widget_products_slider a.button,a.button:visited,.clean_commerce_widget_products_slider .cycle-prev, .clean_commerce_widget_products_slider .cycle-next,.clean-commerce-woocommerce ul.products li.product .button,a.custom-button{color:' . $color . '}' . "\n";

				$custom_css .= '.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{color:' . $color . '}' . "\n";
				 break;


				case 'color_basic_button_text_hover':
				  $custom_css .= 'a.custom-button:hover,.clean_commerce_widget_products_slider a.button:hover,#infinite-handle span:hover.search-box > a:hover,.clean-commerce-woocommerce .slick-arrow i:hover,a.button,a.button:hover,.search-form .search-submit:hover,a.cta-button-primary:hover,.nav-links a:hover,a.button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, #infinite-handle span button:hover,.clean-commerce-woocommerce ul.products li.product .button:hover,.clean_commerce_widget_products_slider .cycle-prev:hover, .clean_commerce_widget_products_slider .cycle-next:hover{color:' . $color . '}' . "\n";

				  $custom_css .= '.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button.woocommerce:hover #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover:hover{color:' . $color . '}' . "\n";
				  break;

				case 'color_basic_button_background':
				  $custom_css .= 'a.custom-button,.clean_commerce_widget_products_slider a.button,.clean-commerce-woocommerce .slick-arrow i,#infinite-handle span,.search-box > a,a.button,button,a.links-btn::after,.search-form .search-submit,.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.clean-commerce-woocommerce ul.products li.product .button,.clean_commerce_widget_products_slider .cycle-prev, .clean_commerce_widget_products_slider .cycle-next,.woocommerce ul.products li.product .button{background-color:' . $color . '}' . "\n";
				  $custom_css .= 'a.cta-button-primary,button, input[type="button"], input[type="reset"], input[type="submit"],#infinite-handle span button{background-color:' . $color . '}' . "\n";
				  break;

				case 'color_basic_button_background_hover':
				  $custom_css .= 'a.custom-button:hover,.clean_commerce_widget_products_slider a.button:hover,.clean-commerce-woocommerce .slick-arrow i:hover,#infinite-handle span:hover,.search-box > a:hover,a.button:hover,a.links-btn:hover::after,.search-form .search-submit:hover,a.cta-button-primary:hover,.nav-links a:hover,button:hover,a.button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover,#infinite-handle span button,.clean-commerce-woocommerce ul.products li.product .button:hover,.clean_commerce_widget_products_slider .cycle-prev:hover, .clean_commerce_widget_products_slider .cycle-next:hover,.woocommerce ul.products li.product .button:hover{background-color:' . $color . '}' . "\n";
				  $custom_css .= '.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button.woocommerce:hover #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover{background-color:' . $color . '}' . "\n";
				  break;

				// Header.
				case 'color_top_header_background':
				  $custom_css .= '#tophead {background-color:' . $color . '}' . "\n";
				  break;
				case 'color_top_header_icon':
				  $custom_css .= '.header-social-wrapper .clean_commerce_widget_social li a::before,#quick-contact li::before{color:' . $color . '}' . "\n";
				  break;
				case 'color_top_header_text':
				  $custom_css .= '#tophead,#quick-contact li{color:' . $color . '}' . "\n";
				break;
				case 'color_top_header_link':
				  $custom_css .= '#tophead a{color:' . $color . '}' . "\n";
				break;
				  case 'color_top_header_link_hover':
				$custom_css .= '#tophead a:hover{color:' . $color . '}' . "\n";
				break;


				// Header.
				case 'color_header_background':
				  $custom_css .= '#masthead {background-color:' . $color . '}' . "\n";
				  break;
				case 'color_header_title':
				  $custom_css .= '#site-identity .site-title > a{color:' . $color . '}' . "\n";
		        break;
				case 'color_header_title_hover':
				  $custom_css .= '#site-identity .site-title > a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_tagline':
				  $custom_css .= '.site-description{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_link':
				  $custom_css .= '#right-header a{color:' . $color . '}' . "\n";
		        break;
				case 'color_header_link_hover':
				  $custom_css .= '#right-header a:hover,#cart-section .cart-icon strong, #cart-section .wishlist-count{color:' . $color . '}' . "\n";
				   $custom_css .= '#right-header a:hover,#cart-section .cart-icon strong, #cart-section .wishlist-count,#cart-section .cart-icon-handle{border-color:' . $color . '}' . "\n";
				  break;  

			   // Primary Menu.
				case 'color_primary_menu_background':
				  $custom_css .= '#main-nav,.main-navigation ul ul{background-color:' . $color . '}' . "\n";
				case 'color_primary_menu_background':
				  $custom_css .= '.main-navigation ul ul::before{border-bottom-color:' . $color . '}' . "\n";
				break;

				case 'color_primary_menu_link':
				  $custom_css .= '#main-nav ul li a,.dropdown-toggle::after{color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_link_hover':
				  $custom_css .= '#main-nav ul li a:hover,#main-nav li.current-menu-item > a,
				  #main-nav li.current_page_item > a,#main-nav ul li:hover > a{color:' . $color . '}' . "\n";
				  break;

				case 'color_primary_menu_link_hover_border':
				  $custom_css .= '.main-navigation li:before{background-color:' . $color . '}' . "\n";
				  break;
				    
				case 'color_primary_submenu_background_hover':
				    $custom_css .= '.main-navigation li li::before{background-color:' . $color . '}' . "\n";
				break;

				case 'color_primary_menu_search_icon':
				  $custom_css .= '.header-search-box > a{color:' . $color . '}' . "\n";
					break;
				    
				case 'color_primary_menu_search_icon_hover':
				    $custom_css .= '.header-search-box > a:hover{color:' . $color . '}' . "\n";
					break;

				case 'color_primary_menu_search_icon_background':
				  $custom_css .= '.header-search-box > a{background-color:' . $color . '}' . "\n";
				  break;
				    
				case 'color_primary_menu_search_icon_background_hover':
				    $custom_css .= '.header-search-box > a:hover{background-color:' . $color . '}' . "\n";
					break;
			// Header.
				case 'color_featured_carousel_background':
				  $custom_css .= '#featured-carousel{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_featured_carousel_title':
				  $custom_css .= '#featured-carousel a{color:' . $color . '}' . "\n";
		        break;
				case 'color_featured_carousel_title_hover':
				  $custom_css .= '#featured-carousel a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_featured_carousel_hover_overlay':
				  $custom_css .= '#featured-carousel .featured-carousel-item .featured-product-title::before{background-color:' . $color . '}' . "\n";
				  break;
				// Content.
				case 'color_content_background':
				  $custom_css .= '#content{background-color:' . $color . '}' . "\n";
				  break;
				  case 'color_primary_content_background':
				  $custom_css .= '#primary main{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_content_title':
				  $custom_css .= '#primary .entry-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_text':
				  $custom_css .= '#primary {color:' . $color . '}' . "\n";
				  break;
				case 'color_content_link':
				  $custom_css .= '#primary article a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_link_hover':
				  $custom_css .= '#primary article a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_link':
				  $custom_css .= '#primary .entry-meta > span a,#primary .entry-footer > span a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_link_hover':
				  $custom_css .= '#primary .entry-meta > span a:hover,#primary  .entry-footer > span a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_icon':
				  $custom_css .= '#primary .entry-meta > span::before,#primary  .entry-footer > span::before{color:' . $color . '}' . "\n";
				  break;

				// Sidebar.
				 case 'color_sidebar_widget_background':
				  $custom_css .= '.sidebar .widget{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_title':
				  $custom_css .= '.sidebar .widget-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_text':
				  $custom_css .= '.sidebar{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_link':
				  $custom_css .= '.sidebar .widget a,.sidebar .widget li{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_link_hover':
				  $custom_css .= '.sidebar .widget a:hover,.sidebar .widget li:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_list_icon':
				  $custom_css .= '.sidebar ul li::before{color:' . $color . '}' . "\n";
				  break;

				// Footer area.
				case 'color_footer_area_background':
				  $custom_css .= '#colophon{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_text':
				  $custom_css .= '#colophon{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_link':
				  $custom_css .= '#colophon a{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_link_hover':
				  $custom_css .= '#colophon a:hover{color:' . $color . '}' . "\n";
				  break;

				// Go To Top.
			    case 'color_goto_top_icon':
				  $custom_css .= '#btn-scrollup i.fa{color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_icon_hover':
				  $custom_css .= '#btn-scrollup i.fa:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_background':
				  $custom_css .= '#btn-scrollup{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_background_hover':
				  $custom_css .= '#btn-scrollup:hover{background-color:' . $color . '}' . "\n";
				  break;


				// Pagination.
				case 'color_pagination_link':
				  $custom_css .= '.navigation .nav-links a,#infinite-handle span{color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_hover':
				  $custom_css .= '.navigation .nav-links .page-numbers.current,  .navigation .nav-links a:hover,#infinite-handle span:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_background':
				  $custom_css .= '.navigation .nav-links a,#infinite-handle span{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_background_hover':
				  $custom_css .= '.navigation .nav-links .page-numbers.current,  .navigation .nav-links a:hover,#infinite-handle span:hover{background-color:' . $color . '}' . "\n";
				  break;

				// Breadcrumb.
				case 'color_breadcrumb_background':
				  $custom_css .= '#breadcrumb{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_link':
				  $custom_css .= '#crumbs a,#breadcrumb a{color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_link_hover':
				  $custom_css .= '#crumbs a:hover,#breadcrumb a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_text':
				  $custom_css .= '#breadcrumb,#breadcrumb .breadcrumb-trail li::after, #crumbs li::after{color:' . $color . '}' . "\n";
				  break;

				// Footer Widgets.
				case 'color_footer_widgets_background':
				  $custom_css .= '#footer-widgets{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_title':
				  $custom_css .= '#footer-widgets .widget-title{color:' . $color . '}' . "\n";
				  $custom_css .= '#footer-widgets .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_text':
				  $custom_css .= '#footer-widgets {color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_link':
				  $custom_css .= '#footer-widgets a{color:' . $color . '}' . "\n";
				  $custom_css .= '#footer-widgets h3.widget-title::after{background-color:' . $color . '}' . "\n";
			      $custom_css .= '#footer-widgets  break;{border-color:' . $color . '}' . "\n";
				break;

				case 'color_footer_widgets_link_hover':
				  $custom_css .= '#footer-widgets a:hover{color:' . $color . '}' . "\n";
				  break;

				// Home Page Widgets.
				case 'color_home_widgets_background':
				  $custom_css .= '#sidebar-front-page-widget-area,#sidebar-front-page-widget-area .widget{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_title':
				  $custom_css .= '#sidebar-front-page-widget-area .widget-title{color:' . $color . '}' . "\n";
				  break;
				 case 'color_home_widgets_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_text':
				  $custom_css .= '#sidebar-front-page-widget-area,#sidebar-front-page-widget-area p{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_link':
				  $custom_css .= '#sidebar-front-page-widget-area a{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_link_hover':
				  $custom_css .= '#sidebar-front-page-widget-area a:hover{color:' . $color . '}' . "\n";
				  break;

			  default:
			    break;

			}

		}

		// Render style.
		if ( ! empty( $custom_css ) ) {
		  echo '<style type="text/css">';
		  echo $custom_css;
		  echo '</style>';
		}

	}

endif;

add_action( 'clean_commerce_action_theme_custom_css', 'clean_commerce_add_theme_custom_color_css', 25 );
