<?php
/**
 * Custom theme functions.
 *
 * This file contains hook functions attached to theme hooks.
 *
 * @package Clean_Commerce
 */

if ( ! function_exists( 'clean_commerce_skip_to_content' ) ) :
	/**
	 * Add Skip to content.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_skip_to_content() {
	?><a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'clean-commerce-pro' ); ?></a><?php
	}
endif;

add_action( 'clean_commerce_action_before', 'clean_commerce_skip_to_content', 15 );


if ( ! function_exists( 'clean_commerce_site_branding' ) ) :

	/**
	 * Site branding.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_site_branding() {

		?>
	    <div class="site-branding">

			<?php clean_commerce_the_custom_logo(); ?>

			<?php $show_title = clean_commerce_get_option( 'show_title' ); ?>
			<?php $show_tagline = clean_commerce_get_option( 'show_tagline' ); ?>
			<?php if ( true === $show_title || true === $show_tagline ) :  ?>
				<div id="site-identity">
					<?php if ( true === $show_title ) : ?>
						<?php if ( is_front_page() && is_home() ) : ?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php endif; ?>
					<?php endif; ?>
					<?php if ( true === $show_tagline ) : ?>
						<p class="site-description"><?php bloginfo( 'description' ); ?></p>
					<?php endif; ?>
				</div><!-- #site-identity -->
			<?php endif; ?>
	    </div><!-- .site-branding -->
	    <div id="right-header">
		    <?php if ( has_nav_menu( 'header' ) ) : ?>
		    	<?php
		    	wp_nav_menu( array(
					'theme_location' => 'header',
					'container'      => 'nav',
					'container_id'   => 'header-nav',
					'depth'          => 1,
		    	) );
		    	?>
		    <?php endif; ?>

	    	<?php if ( clean_commerce_is_woocommerce_active() ) : ?>
		    	<div id="cart-section">
		    		<ul>
		    			<?php $login_link_in_header = clean_commerce_get_option( 'login_link_in_header' ); ?>

		    			<?php if ( true === $login_link_in_header ) : ?>
			    			<li class="account-login">
			    				<?php
								$loggedin_text    = clean_commerce_get_option( 'loggedin_text' );
								$nonloggedin_text = clean_commerce_get_option( 'nonloggedin_text' );
			    				?>
			    				<a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ); ?>">
			    					<?php
			    					if ( is_user_logged_in() ) {
			    						echo esc_html( $loggedin_text );
			    					} else {
			    						echo esc_html( $nonloggedin_text );
			    					}
			    					?>
			    				</a>
			    			</li>
		    			<?php endif; ?>

		    			<?php $cart_in_header = clean_commerce_get_option( 'cart_in_header' ); ?>

		    			<?php if ( true === $cart_in_header ) : ?>
			    			<li class="cart-price">
			    				<?php $cart_text = clean_commerce_get_option( 'cart_text' ); ?>

				    			<a href="<?php echo esc_url( wc_get_cart_url() ); ?>">
					    			<?php if ( ! empty( $cart_text ) ) : ?>
					    				<strong><?php echo esc_html( $cart_text ); ?></strong>&nbsp;/&nbsp;
					    			<?php endif; ?>
					    			<span class="amount"><?php echo WC()->cart->get_cart_total(); ?></span>
				    			</a>
			    			</li>

		    				<li class="cart-icon"><a href="<?php echo esc_url( wc_get_cart_url() ); ?>"><strong><?php echo wp_kses_data( WC()->cart->get_cart_contents_count() );?></strong><span class="cart-icon-handle"></span></a></li>
		    			<?php endif; ?>

	    				<?php if ( class_exists( 'YITH_WCWL' ) ) : ?>
	    					<?php
	    					$wishlist_page_id = yith_wcwl_object_id( get_option( 'yith_wcwl_wishlist_page_id' ) );
	    					$wishlist_in_header = clean_commerce_get_option( 'wishlist_in_header' );
	    					?>
	    					<?php if ( absint( $wishlist_page_id ) > 0 && true === $wishlist_in_header ) : ?>
			    				<li class="wishlist-icon"><a href="<?php echo esc_url( get_permalink( $wishlist_page_id ) ); ?>"><span class="wishlist-count"><?php echo absint( yith_wcwl_count_products() ); ?></span></a></li>
	    					<?php endif; ?>
	    				<?php endif; ?>
	    			</ul>
	    		</div> <!-- .cart-section -->
	    	<?php endif; ?>
    	</div> <!-- #right-header -->

	    <?php
	}

endif;

add_action( 'clean_commerce_action_header', 'clean_commerce_site_branding' );

if ( ! function_exists( 'clean_commerce_add_primary_navigation' ) ) :

	/**
	 * Primary navigation.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_add_primary_navigation() {
		?>
	    <div id="main-nav" class="clear-fix">
	        <div class="container">
		        <nav id="site-navigation" class="main-navigation" role="navigation">
		            <div class="wrap-menu-content">
						<?php
						wp_nav_menu( array(
							'theme_location' => 'primary',
							'menu_id'        => 'primary-menu',
							'fallback_cb'    => 'clean_commerce_primary_navigation_fallback',
						) );
						?>
		            </div><!-- .menu-content -->
		        </nav><!-- #site-navigation -->

				<?php $search_in_header = clean_commerce_get_option( 'search_in_header' ); ?>
				<?php if ( true === $search_in_header ) : ?>
			        <div class="header-search-box">
			        	<a href="#" class="search-icon"><i class="fa fa-search"></i></a>
			        	<div class="search-box-wrap">
				        	<?php get_search_form(); ?>
		        		</div><!-- .search-box-wrap -->
		        	</div><!-- .header-search-box -->
				<?php endif; ?>

	       </div> <!-- .container -->
	    </div> <!-- #main-nav -->
    <?php
	}

endif;

add_action( 'clean_commerce_action_after_header', 'clean_commerce_add_primary_navigation', 20 );


if ( ! function_exists( 'clean_commerce_mobile_navigation' ) ) :

	/**
	 * Mobile navigation.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_mobile_navigation() {
		?>
		<div class="mobile-nav-wrap">
			<a id="mobile-trigger" href="#mob-menu"><i class="fa fa-bars"></i></a>
			<div id="mob-menu">
				<?php
				wp_nav_menu( array(
					'theme_location' => 'primary',
					'container'      => '',
					'fallback_cb'    => 'clean_commerce_primary_navigation_fallback',
					) );
				?>
			</div><!-- #mob-menu -->
			<?php if ( has_nav_menu( 'header' ) ) : ?>
				<a id="mobile-trigger2" href="#mob-menu2"><i class="fa fa-bars"></i></a>
				<div id="mob-menu2">
					<?php
					wp_nav_menu( array(
						'theme_location' => 'header',
						'container'      => '',
						) );
					?>
				</div><!-- #mob-menu2 -->
			<?php endif; ?>
		</div><!-- .mobile-nav-wrap -->

		<?php

	}

endif;

add_action( 'clean_commerce_action_before', 'clean_commerce_mobile_navigation', 20 );

if ( ! function_exists( 'clean_commerce_footer_copyright' ) ) :

	/**
	 * Footer copyright.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_footer_copyright() {

		// Check if footer is disabled.
		$footer_status = apply_filters( 'clean_commerce_filter_footer_status', true );
		if ( true !== $footer_status ) {
			return;
		}

		// Footer Menu.
		$footer_menu_content = wp_nav_menu( array(
			'theme_location' => 'footer',
			'container'      => 'div',
			'container_id'   => 'footer-navigation',
			'depth'          => 1,
			'fallback_cb'    => false,
			'echo'           => false,
		) );

		// Copyright content.
		$copyright_text = clean_commerce_get_option( 'copyright_text' );
		$copyright_text = apply_filters( 'clean_commerce_filter_copyright_text', $copyright_text );
		if ( ! empty( $copyright_text ) ) {
			$copyright_text = wp_kses_data( $copyright_text );
			$copyright_text = clean_commerce_apply_theme_shortcode( $copyright_text );
		}

		// Powered by content.
		$powered_by_text = clean_commerce_get_option( 'powered_by_text' );
		$powered_by_text = apply_filters( 'clean_commerce_filter_powered_by_text', $powered_by_text );
		if ( ! empty( $powered_by_text ) ) {
			$allowed_tags = wp_kses_allowed_html( 'post' );
			$powered_by_text = wp_kses( $powered_by_text, $allowed_tags );
			$powered_by_text = clean_commerce_apply_theme_shortcode( $powered_by_text );
		}

		$show_social_in_footer = clean_commerce_get_option( 'show_social_in_footer' );

		$column_count = 0;

		if ( $footer_menu_content ) {
			$column_count++;
		}
		if ( $copyright_text ) {
			$column_count++;
		}
		if ( $powered_by_text ) {
			$column_count++;
		}
		if ( true === $show_social_in_footer && has_nav_menu( 'social' ) ) {
			$column_count++;
		}

		?>

		<div class="colophon-inner colophon-grid-<?php echo esc_attr( $column_count ); ?>">

		    <?php if ( ! empty( $copyright_text ) ) :  ?>
			    <div class="colophon-column">
			    	<div class="copyright">
			    		<?php echo $copyright_text; ?>
			    	</div><!-- .copyright -->
			    </div><!-- .colophon-column -->
		    <?php endif; ?>

		    <?php if ( true === $show_social_in_footer && has_nav_menu( 'social' ) ) :  ?>
			    <div class="colophon-column">
			    	<div class="footer-social">
			    		<?php the_widget( 'Clean_Commerce_Social_Widget' ); ?>
			    	</div><!-- .footer-social -->
			    </div><!-- .colophon-column -->
		    <?php endif; ?>

		    <?php if ( ! empty( $footer_menu_content ) ) : ?>
		    	<div class="colophon-column">
					<?php echo $footer_menu_content; ?>
		    	</div><!-- .colophon-column -->
		    <?php endif; ?>

		    <?php if ( ! empty( $powered_by_text ) ) : ?>
			    <div class="colophon-column">
			    	<div class="site-info">
			    		<?php echo $powered_by_text; ?>
			    	</div><!-- .site-info -->
			    </div><!-- .colophon-column -->
		    <?php endif; ?>

		</div><!-- .colophon-inner -->

	    <?php
	}

endif;

add_action( 'clean_commerce_action_footer', 'clean_commerce_footer_copyright', 10 );


if ( ! function_exists( 'clean_commerce_add_sidebar' ) ) :

	/**
	 * Add sidebar.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_add_sidebar() {

		global $post;

		$global_layout = clean_commerce_get_option( 'global_layout' );
		$global_layout = apply_filters( 'clean_commerce_filter_theme_global_layout', $global_layout );

		// Check if single.
		if ( $post && is_singular() ) {
			$post_options = get_post_meta( $post->ID, 'clean_commerce_theme_settings', true );
			if ( isset( $post_options['post_layout'] ) && ! empty( $post_options['post_layout'] ) ) {
				$global_layout = $post_options['post_layout'];
			}
		}

		// Include primary sidebar.
		if ( 'no-sidebar' !== $global_layout ) {
			get_sidebar();
		}
		// Include Secondary sidebar.
		switch ( $global_layout ) {
		  case 'three-columns':
		  case 'three-columns-pcs':
		  case 'three-columns-cps':
		  case 'three-columns-psc':
		  case 'three-columns-pcs-equal':
		  case 'three-columns-scp-equal':
		    get_sidebar( 'secondary' );
		    break;

		  default:
		    break;
		}

	}

endif;

add_action( 'clean_commerce_action_sidebar', 'clean_commerce_add_sidebar' );


if ( ! function_exists( 'clean_commerce_custom_posts_navigation' ) ) :
	/**
	 * Posts navigation.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_custom_posts_navigation() {

		$pagination_type = clean_commerce_get_option( 'pagination_type' );

		switch ( $pagination_type ) {

			case 'default':
				the_posts_navigation();
			break;

			case 'numeric':
				the_posts_pagination();
			break;

			default:
			break;
		}

	}
endif;

add_action( 'clean_commerce_action_posts_navigation', 'clean_commerce_custom_posts_navigation' );


if ( ! function_exists( 'clean_commerce_add_image_in_single_display' ) ) :

	/**
	 * Add image in single post.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_add_image_in_single_display() {

		global $post;

		if ( has_post_thumbnail() ) {

			$values = get_post_meta( $post->ID, 'clean_commerce_theme_settings', true );
			$clean_commerce_theme_settings_single_image = isset( $values['single_image'] ) ? esc_attr( $values['single_image'] ) : '';
			$clean_commerce_theme_settings_single_image_alignment = isset( $values['single_image_alignment'] ) ? esc_attr( $values['single_image_alignment'] ) : '';

			if ( ! $clean_commerce_theme_settings_single_image ) {
				$clean_commerce_theme_settings_single_image = clean_commerce_get_option( 'single_image' );
			}
			if ( ! $clean_commerce_theme_settings_single_image_alignment ) {
				$clean_commerce_theme_settings_single_image_alignment = clean_commerce_get_option( 'single_image_alignment' );
			}

			if ( 'disable' !== $clean_commerce_theme_settings_single_image ) {
				$args = array(
				'class' => 'align' . esc_attr( $clean_commerce_theme_settings_single_image_alignment ),
				);
				the_post_thumbnail( esc_attr( $clean_commerce_theme_settings_single_image ), $args );
			}
		}

	}

endif;

add_action( 'clean_commerce_single_image', 'clean_commerce_add_image_in_single_display' );

if ( ! function_exists( 'clean_commerce_add_breadcrumb' ) ) :

	/**
	 * Add breadcrumb.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_add_breadcrumb() {

		// Bail if Breadcrumb disabled.
		$breadcrumb_type = clean_commerce_get_option( 'breadcrumb_type' );
		if ( 'disabled' === $breadcrumb_type ) {
			return;
		}

		// Bail if Home Page.
		if ( is_front_page() || is_home() ) {
			return;
		}

		echo '<div id="breadcrumb"><div class="container">';
		switch ( $breadcrumb_type ) {
			case 'simple':
				clean_commerce_simple_breadcrumb();
				break;

			default:
				break;
		}
		echo '</div><!-- .container --></div><!-- #breadcrumb -->';

	}

endif;

add_action( 'clean_commerce_action_before_content', 'clean_commerce_add_breadcrumb' , 7 );

if ( ! function_exists( 'clean_commerce_footer_goto_top' ) ) :

	/**
	 * Go to top.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_footer_goto_top() {

		$go_to_top = clean_commerce_get_option( 'go_to_top' );

		if ( true !== $go_to_top ) {
			return;
		}

		echo '<a href="#page" class="scrollup" id="btn-scrollup"><i class="fa fa-angle-up"></i></a>';

	}

endif;

add_action( 'clean_commerce_action_after', 'clean_commerce_footer_goto_top', 20 );

if ( ! function_exists( 'clean_commerce_add_author_bio_in_single' ) ) :

	/**
	 * Display Author bio.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_add_author_bio_in_single() {

		// Bail if not singular post.
		if ( ! is_singular( 'post' ) ) {
			return;
		}

		$author_bio_in_single = clean_commerce_get_option( 'author_bio_in_single' );
		if ( true !== $author_bio_in_single ) {
			return;
		}

		get_template_part( 'template-parts/author-bio', 'single' );

	}
endif;

add_action( 'clean_commerce_author_bio', 'clean_commerce_add_author_bio_in_single' );

if ( ! function_exists( 'clean_commerce_header_top_content' ) ) :

	/**
	 * Header Top.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_header_top_content() {
		$contact_number        = clean_commerce_get_option( 'contact_number' );
		$contact_email         = clean_commerce_get_option( 'contact_email' );
		$contact_address       = clean_commerce_get_option( 'contact_address' );
		$show_social_in_header = clean_commerce_get_option( 'show_social_in_header' );

		if ( empty( $contact_number ) && empty( $contact_email ) && empty( $contact_address ) ) {
			$contact_status = false;
		} else {
			$contact_status = true;
		}

		if ( false === $contact_status && ( false === $show_social_in_header || false === has_nav_menu( 'social' ) ) ) {
			return;
		}
		?>
		<div id="tophead">
			<div class="container">
				 <div id="quick-contact">
				   <ul>
				       <?php if ( ! empty( $contact_number ) ) : ?>
				       	<li class="quick-call">
				       		<a href="tel:<?php echo preg_replace( '/\D+/', '', esc_attr( $contact_number ) ); ?>"><?php echo esc_html( $contact_number ); ?></a>
				       	</li>
				       <?php endif; ?>
				       <?php if ( ! empty( $contact_email ) ) : ?>
				       	<li class="quick-email">
				       		<a href="<?php echo esc_url( 'mailto:' . $contact_email ); ?>"><?php echo esc_html( $contact_email ); ?></a>
				       	</li>
				       <?php endif; ?>
				       <?php if ( ! empty( $contact_address ) ) : ?>
				       	<li class="quick-address">
				       		<?php echo esc_html( $contact_address ); ?>
				       	</li>
				       <?php endif; ?>
				   </ul>
				</div> <!-- #quick-contact -->

				<?php if ( true === $show_social_in_header && has_nav_menu( 'social' ) ) : ?>
					<div class="header-social-wrapper">
						<?php the_widget( 'Clean_Commerce_Social_Widget' ); ?>
					</div><!-- .header-social-wrapper -->
				<?php endif; ?>

			</div> <!-- .container -->
		</div><!--  #tophead -->

		<?php
	}

endif;

add_action( 'clean_commerce_action_before_header', 'clean_commerce_header_top_content', 5 );

if ( ! function_exists( 'clean_commerce_check_home_page_content' ) ) :

	/**
	 * Check home page content status.
	 *
	 * @since 1.0.0
	 *
	 * @param bool $status Home page content status.
	 * @return bool Modified home page content status.
	 */
	function clean_commerce_check_home_page_content( $status ) {

		if ( is_front_page() ) {
			$home_content_status = clean_commerce_get_option( 'home_content_status' );
			if ( false === $home_content_status ) {
				$status = false;
			}
		}

		return $status;

	}

endif;

add_action( 'clean_commerce_filter_home_page_content', 'clean_commerce_check_home_page_content' );

if ( ! function_exists( 'clean_commerce_default_message_front_page_widget_area' ) ) :

	/**
	 * Default message in front page widget area.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_default_message_front_page_widget_area() {

		if ( ! current_user_can( 'edit_theme_options' ) ) {
			return;
		}

		$args = array();

		$args['title'] = esc_html__( 'Welcome to our website!', 'clean-commerce-pro' );
		$args['text']  = esc_html__( 'You are seeing this because there is no any widget in Front Page Widget Area. Go to Appearance->Widgets in admin panel to add widgets.', 'clean-commerce-pro' );

		$widget_args = array(
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
			'before_widget' => '<aside class="widget"><div class="container">',
			'after_widget'  => '</div></aside>',
		);

		the_widget( 'WP_Widget_Text', $args, $widget_args );

	}

endif;

add_action( 'clean_commerce_action_default_front_page_widget_area', 'clean_commerce_default_message_front_page_widget_area' );

if ( ! function_exists( 'clean_commerce_add_front_page_widget_area' ) ) :

	/**
	 * Add Front Page Widget area.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_add_front_page_widget_area() {

		$widget_status = apply_filters( 'clean_commerce_filter_front_page_widget_status', false );

		if ( true !== $widget_status ) {
			return;
		}

		echo '<div id="sidebar-front-page-widget-area" class="widget-area">';
		if ( is_active_sidebar( 'sidebar-front-page-widget-area' ) ) {
			dynamic_sidebar( 'sidebar-front-page-widget-area' );
		}
		else {
			do_action( 'clean_commerce_action_default_front_page_widget_area' );
		}
		echo '</div><!-- #sidebar-front-page-widget-area -->';

	}
endif;

add_action( 'clean_commerce_action_before_content', 'clean_commerce_add_front_page_widget_area', 7 );

if ( ! function_exists( 'clean_commerce_check_front_page_widget_status' ) ) :

	/**
	 * Check status of front page widget area.
	 *
	 * @since 1.0.0
	 */
	function clean_commerce_check_front_page_widget_status( $input ) {

		if ( is_front_page() && ! is_home() ) {
			$input = true;
		}
		else {
			$input = false;
		}

		return $input;

	}
endif;

add_filter( 'clean_commerce_filter_front_page_widget_status', 'clean_commerce_check_front_page_widget_status' );
