jQuery( document ).ready( function( $ ) {

    /*------------------------------------------------
                    gallery   
    ------------------------------------------------*/
    var message = travel_insight_pro_message.message;

    $('.portfolio-filter li a').click(function(e){
        e.preventDefault();

        if ( $( "#gallery-wrapper .wrapper" ).hasClass('no-portfolio') ) {
            $( "#gallery-wrapper .wrapper" ).removeClass( 'no-portfolio' );
        }

        if ( $( ".gallery-cat-empty" ).length ) {
            $( ".gallery-cat-empty" ).remove();
        }

       var filter_class = $( this ).data( 'filter' ).replace('.', '');

       if ( '*' == filter_class ) {
            var item_hasClass  = true;
       }
       else if ( $( '#gallery-wrapper .portfolio .portfolio-item' ).hasClass( filter_class ) ) {
            var item_hasClass  = true;
       }

       if( ! item_hasClass ){
            $( "#gallery-wrapper .wrapper" ).addClass('no-portfolio');
            $( ".portfolio" ).append( '<h3 class="gallery-cat-empty gallery-portfolio-empty gallery-empty">' + message + '</h3>' );
       }
    });
    
    var $container = $('.portfolio'),
    colWidth = function () {
        var w = $container.width(), 
            columnNum = 1,
            columnWidth = 0;
        if (w > 1200) {
            columnNum  = 3;
        } 
        else if (w > 900) {
            columnNum  = 3;
        } 
        else if (w > 600) {
            columnNum  = 2;
        } 
        else if (w > 300) {
            columnNum  = 2;
        }
        columnWidth = Math.floor(w/columnNum);
        $container.find('.portfolio-item').each(function() {
            var $item = $(this),
                multiplier_w = $item.attr('class').match(/item-w(\d)/),
                multiplier_h = $item.attr('class').match(/item-h(\d)/),
                width = multiplier_w ? columnWidth*multiplier_w[1]-0 : columnWidth-5,
                height = multiplier_h ? columnWidth*multiplier_h[1]*1-5 : columnWidth*0.5-5;
            $item.css({
                width: width,
                height: height
            });
        });
        return columnWidth;
    }
                
    function refreshWaypoints() {
        setTimeout(function() {
        }, 1000);   
    }
                
    $('nav.portfolio-filter ul a').on('click', function() {
        var selector = $(this).attr('data-filter');
        $container.isotope({ filter: selector }, refreshWaypoints());
        $('nav.portfolio-filter ul a').removeClass('active');
        $(this).addClass('active');
        return false;
    });
        
    function setPortfolio() { 
        setColumns();
        $container.isotope('reLayout');
    }

    isotope = function () {
        $container.isotope({
            resizable: true,
            itemSelector: '.portfolio-item',
  layoutMode : 'masonry',
  gutter: 0,
            masonry: {
                columnWidth: colWidth(),
                gutterWidth: 10
            }
        });
    };
    $('img').on('load', function(){
        isotope();
    });
    $(window).resize(function(){
        isotope = function () {
            $container.isotope({
                itemSelector: '.portfolio-item',
                layoutMode : 'masonry',
                gutter: 0,
                masonry: {
                    columnWidth: colWidth(),
                    gutterWidth: 10
                }
            });
        };
        isotope();
    });

} );
