<?php 
/**
 * About Us template
 *
 * This is the template for the content of about_us template
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_about_us_template_slider' ) ) :
    /**
    * Add about_us template
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_about_us_template_slider() {
        $options = travel_insight_pro_get_theme_options();

        // Check if about_us is enabled
        $enable_about_us = $options['about_us_template_slider_enable'];

        if ( true !== $enable_about_us ) {
            return false;
        }

        // Get about_us template details
        $template_details = array();
        $template_details = apply_filters( 'travel_insight_pro_filter_about_us_template_slider_details', $template_details );
        if ( empty( $template_details ) ) {
            return;
        }
        // Render about_us template now.
        travel_insight_pro_render_about_us_template_slider( $template_details );
    }
endif;
add_action( 'travel_insight_pro_about_us_template_content_action', 'travel_insight_pro_add_about_us_template_slider', 10 );


if ( ! function_exists( 'travel_insight_pro_get_about_us_template_slider_details' ) ) :
    /**
    * about_us template details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input about_us template details.
    */
    function travel_insight_pro_get_about_us_template_slider_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // about_us type
        $about_us_content_type  = $options['about_us_template_slider_type'];
        $no_of_slider  = $options['no_of_about_us_template_slider'];

        $content = array();
        switch ( $about_us_content_type ) {

            case 'custom':
                for ( $i = 1; $i <= $no_of_slider; $i++ ) :
                    if ( ! empty( $options['about_us_template_custom_' . $i] ) ) :
                        $content[$i]['img_array'][0] = ! empty( $options['about_us_template_custom_' . $i] ) ? $options['about_us_template_custom_' . $i] : '';
                        $content[$i]['img_array'][1] = '';
                        $content[$i]['img_array'][2] = '';
                        $content[$i]['alt']          = ! empty( $options['about_us_template_custom_alt_' . $i] ) ? $options['about_us_template_custom_alt_' . $i] : '';
                        $content[$i]['url']          = ! empty( $options['about_us_template_custom_link_' . $i] ) ? $options['about_us_template_custom_link_' . $i] : '';
                    endif;
                endfor;
            break;    

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $no_of_slider; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'about_us_template_slider_page_' . $i ] ) ) {
                        $id = $options[ 'about_us_template_slider_page_' . $i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $no_of_slider ),
                );

            break;


            case 'post':
                $ids = array();
                
                if ( ! empty( $options['about_us_template_slider_post'] ) )
                    $ids = ( array ) $options['about_us_template_slider_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => 10,
                );                       
            break;
        }

        if ( $about_us_content_type != 'custom' ) {
            $posts = get_posts( $args );
            if ( ! empty( $posts ) ) :
                $i = 1;
                foreach ( $posts as $post ) :
                    $post_id = $post->ID;
                    if ( has_post_thumbnail( $post_id ) ) {
                        $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'travel-insight-pro-portrait' );
                        $content[$i]['img_array'] = $img_array;
                        $content[$i]['alt']       = get_the_title( $post_id );
                        $content[$i]['url']       = get_the_permalink( $post_id );
                    } 
                    $i++;
                endforeach;
            endif;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// about_us template content details.
add_filter( 'travel_insight_pro_filter_about_us_template_slider_details', 'travel_insight_pro_get_about_us_template_slider_details' );


if ( ! function_exists( 'travel_insight_pro_render_about_us_template_slider' ) ) :
    /**
    * Start about_us template
    *
    * @return string about_us content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_about_us_template_slider( $content_details ) {
        $options = travel_insight_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }

        ?>
        <section id="about-slider">
            <div class="about-slider" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": false, "speed": 600, "dots": false, "arrows":true, "autoplay": true, "fade": false, "draggable":false}'>
                <?php foreach ( $content_details as $content_detail ) : ?>
                    <div class="featured-image">
                        <a href="<?php echo esc_url( $content_detail['url'] ); ?>"><img src="<?php echo esc_url( $content_detail['img_array'][0] ); ?>" width="<?php echo esc_attr( $content_detail['img_array'][1] ); ?>" height="<?php echo esc_attr( $content_detail['img_array'][2] ); ?>" alt="<?php echo esc_attr( $content_detail['alt'] ); ?>" title="<?php echo esc_attr( $content_detail['alt'] ); ?>" ></a>
                    </div><!--.featured-image-->
                <?php endforeach; ?>
            </div><!-- .about-slider -->
        </section>
    <?php }
endif;


if ( ! function_exists( 'travel_insight_pro_add_about_us_template_service' ) ) :
    /**
    * Add about_us template
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_about_us_template_service() {
        $options = travel_insight_pro_get_theme_options();

        // Check if about_us is enabled
        $enable_about_us = $options['about_us_template_service_enable'];

        if ( true !== $enable_about_us ) {
            return false;
        }

        // Get about_us template details
        $template_details = array();
        $template_details = apply_filters( 'travel_insight_pro_filter_about_us_template_service_details', $template_details );
        if ( empty( $template_details ) ) {
            return;
        }
        // Render about_us template now.
        travel_insight_pro_render_about_us_template_service( $template_details );
    }
endif;
add_action( 'travel_insight_pro_about_us_template_content_action', 'travel_insight_pro_add_about_us_template_service', 20 );


if ( ! function_exists( 'travel_insight_pro_get_about_us_template_service_details' ) ) :
    /**
    * about_us template details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input about_us template details.
    */
    function travel_insight_pro_get_about_us_template_service_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // about_us type
        $about_us_content_type  = $options['about_us_template_service_type'];

        $content = array();
        switch ( $about_us_content_type ) {

            case 'custom':
                for ( $i = 1; $i <= 4; $i++ ) :
                    if ( ! empty( $options['about_us_template_service_title_' . $i] ) )
                        $content[$i]['title']   = $options['about_us_template_service_title_' . $i];
                    if ( ! empty( $options['about_us_template_service_icon_' . $i] ) )
                        $content[$i]['icon']    = $options['about_us_template_service_icon_' . $i];
                    if ( ! empty( $options['about_us_template_service_url_' . $i] ) )
                        $content[$i]['url']     = $options['about_us_template_service_url_' . $i];
                    if ( ! empty( $options['about_us_template_service_description_' . $i] ) )
                        $content[$i]['excerpt'] = $options['about_us_template_service_description_' . $i];
                endfor;
            break;    

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= 4; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'about_us_template_service_page_' . $i ] ) ) {
                        $id = $options[ 'about_us_template_service_page_' . $i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => 4,
                );

            break;


            case 'post':
                $ids = array();
                
                if ( ! empty( $options['about_us_template_service_post'] ) )
                    $ids = ( array ) $options['about_us_template_service_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => 4,
                );                       
            break;
        }

        if ( $about_us_content_type != 'custom' ) {
            $posts = get_posts( $args );
            if ( ! empty( $posts ) ) :
                $i = 1;
                foreach ( $posts as $post ) :
                    $post_id = $post->ID;
                        $content[$i]['icon']    = get_post_meta( $post_id, 'travel-insight-pro-post-icon', true );
                        $content[$i]['title']   = get_the_title( $post_id );
                        $content[$i]['url']     = get_the_permalink( $post_id );
                        $content[$i]['excerpt'] = travel_insight_pro_trim_content( 25, $post );
                    $i++;
                endforeach;
            endif;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// about_us template content details.
add_filter( 'travel_insight_pro_filter_about_us_template_service_details', 'travel_insight_pro_get_about_us_template_service_details' );


if ( ! function_exists( 'travel_insight_pro_render_about_us_template_service' ) ) :
    /**
    * Start about_us template
    *
    * @return string about_us content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_about_us_template_service( $content_details ) {
        $options = travel_insight_pro_get_theme_options();
        $featured_image = ! empty( $options['about_us_template_service_image'] ) ? $options['about_us_template_service_image'] : '';

        if ( empty( $content_details ) ) {
            return;
        }

        $i = 1;
        ?>
            <div class="about-context text-center col-3 clear">
                <div class="column-wrapper">
                    <?php foreach ( $content_details as $content_detail ) : ?>
                        <div class="about-wrapper">
                            <?php echo travel_insight_pro_get_svg( array( 'icon' => esc_attr( $content_detail['icon'] ) ) ); ?>
                            <div class="about-content">
                                <h4><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h4>
                                <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                            </div><!-- .about-content -->
                        </div><!-- .about-wrapper -->
                        <?php if ( $i == 2 ) : ?>
                            </div><!-- .column-wrapper -->
                            <div class="column-wrapper">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $featured_image ); ?>')">
                                    <div class="image-overlay"></div>
                                </div><!-- .featured-image -->
                            </div><!-- .column-wrapper -->
                            <div class="column-wrapper">
                        <?php endif; 
                        $i++;
                    endforeach; ?>
                </div><!-- .column-wrapper -->

            </div><!-- .about-context -->
    <?php }
endif;
