<?php 
/**
 * Contact Us template
 *
 * This is the template for the content of contact us template
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

function travel_insight_pro_contact_map() {
    $options = travel_insight_pro_get_theme_options();
    if ( true === $options['contact_map_enable'] ) : 
        $map_content_type       = ! empty( $options['map_content_type'] ) ? $options['map_content_type'] : '';
        $map_content_embed      = ! empty( $options['map_content_embed'] ) ? $options['map_content_embed'] : '';
        $map_content_shortcode  = ! empty( $options['map_content_shortcode'] ) ? $options['map_content_shortcode'] : '';

        if ( 'shortcode' === $map_content_type ) {
            if ( empty( $map_content_shortcode ) )
                return false;
        }
        elseif ( 'embed' === $map_content_embed ) {
            if ( empty( $map_content_embed ) )
                return false;
        }
    ?>
        <div class="column-wrapper map">
            <?php 
            if ( $map_content_type == 'embed'  ) {
                echo '<div class="map-overlay"></div>';
            }
            if ( $map_content_type == 'shortcode' ){
                echo do_shortcode( wp_kses_post( $map_content_shortcode ) );
            } elseif ( $map_content_type == 'embed'  ) {
                echo travel_insight_pro_santize_iframe_map( $map_content_embed );
            }
            ?>
        </div>

    <?php endif;
}
add_action( 'travel_insight_pro_contact_map_action', 'travel_insight_pro_contact_map', 10 );

function travel_insight_pro_contact_form() {
    $options = travel_insight_pro_get_theme_options();
    $contact_page_form = ! empty( $options['contact_page_form'] ) ? $options['contact_page_form'] : '';
    if ( empty( $contact_page_form ) )
        return;
    ?>
    <div class="column-wrapper">
        <div class="form-wrapper">
            <?php echo do_shortcode( wp_kses_post( $contact_page_form ) ); ?>
        </div><!-- .form-wrapper -->
    </div><!-- .entry-content -->
<?php
}
add_action( 'travel_insight_pro_contact_form_action', 'travel_insight_pro_contact_form', 10 );
