<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package travel_insight_pro
	 */

	/**
	 * travel_insight_pro_doctype hook
	 *
	 * @hooked travel_insight_pro_doctype -  10
	 *
	 */
	do_action( 'travel_insight_pro_doctype' );
?>
<head>
<?php
	/**
	 * travel_insight_pro_before_wp_head hook
	 *
	 * @hooked travel_insight_pro_head -  10
	 *
	 */
	do_action( 'travel_insight_pro_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>
<?php
	/**
	 * travel_insight_pro_page_start_action hook
	 *
	 * @hooked travel_insight_pro_page_start -  10
	 *
	 */
	do_action( 'travel_insight_pro_page_start_action' ); 

	/**
	 * travel_insight_pro_loader_action hook
	 *
	 * @hooked travel_insight_pro_loader -  10
	 * @hooked travel_insight_pro_add_breadcrumb -  20
	 *
	 */
	do_action( 'travel_insight_pro_before_header' );

	/**
	 * travel_insight_pro_header_action hook
	 *
	 * @hooked travel_insight_pro_header_start -  10
	 * @hooked travel_insight_pro_site_branding -  20
	 * @hooked travel_insight_pro_site_navigation -  30
	 * @hooked travel_insight_pro_header_end -  50
	 *
	 */
	do_action( 'travel_insight_pro_header_action' );

	/**
	 * travel_insight_pro_content_start_action hook
	 *
	 * @hooked travel_insight_pro_content_start -  10
	 *
	 */
	do_action( 'travel_insight_pro_content_start_action' );

	$options = travel_insight_pro_get_theme_options();

	if($options['home_layout'] == 'default-design'){
		$sections = travel_insight_pro_sortable();
		foreach ( $sections as $section => $value ) {
			add_action( 'travel_insight_pro_primary_content_action', 'travel_insight_pro_add_'. $section .'_section', travel_insight_pro_sortable_section( $section ) );
		}
	}else{
    	if ( $options['home_layout'] == 'second-design' ) {
    		$sections = array( 'slider' => 'slider', 'about_us' => 'about_us', 'guide' => 'guide',  'video' => 'video', 'call_to_action' => 'call_to_action', 'counter' => 'counter', 'team' => 'team', 'subscription' => 'subscription', 'latest_post' => 'latest_post' );
		}


		if ( $options['home_layout'] == 'third-design' ) {
    		$sections = array( 'slider' => 'slider', 'about_us' => 'about_us', 'guide' => 'guide', 'call_to_action' => 'call_to_action', 'team' => 'team', 'medical_reasons' => 'medical_reasons', 'latest_post' => 'latest_post', 'tours' => 'tours' );
		}
		
    	if ( $options['home_layout'] == 'fourth-design' ) {
    		$sections = array( 'slider' => 'slider', 'featured' => 'featured','video' => 'video', 'two_column' => 'two_column', 'latest_post' => 'latest_post' );
    	}

    	if ( $options['home_layout'] == 'fifth-design' ) {
    		$sections = array( 'slider' => 'slider', 'featured' => 'featured', 'two_column' => 'two_column', 'video' => 'video', 'latest_post' => 'latest_post' );
    	}

    	if ( $options['home_layout'] == 'sixth-design' ) {
    		$sections = array( 'slider' => 'slider', 'masonry' => 'masonry', 'recent_product' => 'recent_product', 'service' => 'service', 'latest_product' => 'latest_product', 'latest_post' => 'latest_post' );
    	}

    	if ( $options['home_layout'] == 'seven-design' ) {
    		$sections = array( 'slider' => 'slider', 'about_us' => 'about_us', 'service' => 'service',  'video' => 'video', 'featured' => 'featured', 'counter' => 'counter', 'team' => 'team', 'subscription' => 'subscription', 'latest_post' => 'latest_post' );
		}

		if ( $options['home_layout'] == 'eight-design' ) {
    		$sections = array( 'slider' => 'slider', 'about_us' => 'about_us', 'service' => 'service',  'call_to_action' => 'call_to_action', 'featured' => 'featured', 'counter' => 'counter', 'team' => 'team', 'subscription' => 'subscription', 'latest_post' => 'latest_post' );
		}

		foreach ( $sections as $section => $value ) {
			add_action( 'travel_insight_pro_primary_content_action', 'travel_insight_pro_add_'. $section .'_section' );
		}
	}
	
	/**
	 * travel_insight_pro_primary_content_action hook
	 *
	 * Default hierarchy
	 * 
	 * @hooked travel_insight_pro_add_slider_section -  10
	 * @hooked travel_insight_pro_add_popular_destination_section -  20
	 * @hooked travel_insight_pro_add_about_us_section -  30
	 * @hooked travel_insight_pro_add_articles_section -  40
	 * @hooked travel_insight_pro_add_gallery_section -  50
	 * @hooked travel_insight_pro_add_tours_section -  60
	 * @hooked travel_insight_pro_add_guide_section -  70
	 * @hooked travel_insight_pro_add_call_to_action_section -  80
	 * @hooked travel_insight_pro_add_counter_section -  90
	 * @hooked travel_insight_pro_add_packages_section -  100
	 */
	do_action( 'travel_insight_pro_primary_content_action' );
