<?php
/**
 * Core file.
 *
 * This is the template that includes all the other files for core featured of Theme Palace
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

/**
 * Include options function.
 */
require get_template_directory() . '/inc/options.php';


// Load customizer defaults values
require get_template_directory() . '/inc/customizer/defaults.php';


/**
 * Merge values from default options array and values from customizer
 *
 * @return array Values returned from customizer
 * @since Travel Insight Pro 1.0
 */
function travel_insight_pro_get_theme_options() {
  $travel_insight_pro_default_options = travel_insight_pro_get_default_theme_options();

  return wp_parse_args( get_theme_mod( 'travel_insight_pro_theme_options' ), $travel_insight_pro_default_options );
  
}


/**
  * Write message for featured image upload
  *
  * @return array Values returned from customizer
  * @since Travel Insight Pro 1.0
*/
function travel_insight_pro_slider_image_instruction( $content, $post_id ) {
  $allowed = array( 'page' );
  if ( in_array( get_post_type( $post_id ), $allowed ) ) {
      return $content .= '<p><b>' . esc_html__( 'Note', 'travel-insight-pro' ) . ':</b>' . esc_html__( ' The recommended size for image is 1700px by 750px while using it for slider', 'travel-insight-pro' ) . '</p>';
  }
  return $content;
}
add_filter( 'admin_post_thumbnail_html', 'travel_insight_pro_slider_image_instruction', 10, 2);

/**
 * Add breadcrumb functions.
 */
require get_template_directory() . '/inc/breadcrumb-class.php';

/**
 * Add helper functions.
 */
require get_template_directory() . '/inc/helpers.php';

/**
 * Add structural hooks.
 */
require get_template_directory() . '/inc/structure.php';

/**
 * Add metabox
 */
require get_template_directory() . '/inc/metabox/metabox.php';
require get_template_directory() . '/inc/metabox/category-metabox.php';
require get_template_directory() . '/inc/metabox/gallery-metabox.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/modules/sections.php';

/**
 * Custom widget additions.
 */
require get_template_directory() . '/inc/widgets/widgets.php';

/**
* TGM plugin additions.
*/
require get_template_directory() . '/inc/tgm-plugin/tgm-hook.php';

/*
 * Icon Function
 */
require get_template_directory() . '/inc/icon-function.php';

require get_template_directory() . '/inc/wptt-webfont-loader.php';

/*
 * WooCommerce Function
 */
require get_template_directory() . '/inc/woocommerce.php';

if ( class_exists( 'CatchThemesDemoImportPlugin' ) ) {
    /**
    * OCDI plugin demo importer compatibility.
    */
    require get_template_directory() . '/inc/demo-import.php';
}

/*
 * Custom Template
 */
require get_template_directory() . '/custom-template/template-part/about-template-part.php';
require get_template_directory() . '/custom-template/template-part/contact-template-part.php';
