<?php
/**
 * About Us Template options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// Add panel for about us template options
$wp_customize->add_panel( 'travel_insight_pro_about_us_panel' , array(
    'title'      => esc_html__( 'About Us Template','travel-insight-pro' ),
    'description'=> esc_html__( 'About Us Template Options.', 'travel-insight-pro' ),
    'priority'   => 150,
) );

/*
 * Quote Section
 */
// About Quote Section
$wp_customize->add_section( 'travel_insight_pro_about_us_template_quote', array(
	'title'             => esc_html__( 'Quote','travel-insight-pro' ),
	'description'       => esc_html__( 'Quote Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_about_us_panel',
) );

// About Us sub title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_quote]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['about_us_template_quote'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_quote]', array(
	'label'           	=> esc_html__( 'Input Quote', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_about_us_template_quote',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[about_us_template_quote]', array(
		'selector'            => '.page-template-about-template .entry-header h2.entry-title',
		'settings'            => 'travel_insight_pro_theme_options[about_us_template_quote]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_about_us_template_quote',
    ) );
}

/*
 * Slider Section
 */
// About Slider Section
$wp_customize->add_section( 'travel_insight_pro_about_us_template_slider', array(
	'title'             => esc_html__( 'Image Slider','travel-insight-pro' ),
	'description'       => esc_html__( 'Image Slider Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_about_us_panel',
) );

// About Us Template Slider enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_slider_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['about_us_template_slider_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_slider_enable]', array(
	'label'            	=> esc_html__( 'Enable Image Slider Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_about_us_template_slider',
	'type'             	=> 'checkbox',
) );

// Add About Us Template Slider content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_slider_type]', array(
	'default'           => $options['about_us_template_slider_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_slider_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_about_us_template_slider',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_about_us_template_slider_enable',
	'choices'         	=> travel_insight_pro_about_us_template_slider_type()
) );

// Slider Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_slider_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_slider_post]', array(
	'active_callback'	=> 'travel_insight_pro_about_us_template_slider_post',
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34. Make sure the post you select has featured image', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_about_us_template_slider',
	'type'				=> 'text',
) );

// Add slider number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_about_us_template_slider]', array(
	'default'           => $options['no_of_about_us_template_slider'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_slider_count',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_about_us_template_slider]', array(
	'label'           	=> esc_html__( 'Number of Slides', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_about_us_template_slider',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_about_us_template_slider_count',
	'input_attrs'     	=> array(
		'max' 	=> 10,
		'min' 	=> 1,
		'style' => 'width:100px'
	)
) );

for ( $i = 1; $i <= $options['no_of_about_us_template_slider']; $i++ ) {

	// Slider post hr setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_slider_hr'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Travel_Insight_Pro_Customize_Horizontal_Line( $wp_customize, 'travel_insight_pro_theme_options[about_us_template_slider_hr'. $i .']',
		array(
			'section'         => 'travel_insight_pro_about_us_template_slider',
			'active_callback' => 'travel_insight_pro_about_us_template_slider_custom',
			'type'			  => 'hr'
	) ) );

	// About us Template Slider setting and control.
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_custom_'. $i .']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_image'
	) );

	$wp_customize->add_control(
		new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[about_us_template_custom_'. $i .']',
			array(
			'label'       		=> sprintf( esc_html__( 'Select Slider Background %d', 'travel-insight-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 381, 458 ),
			'section'     		=> 'travel_insight_pro_about_us_template_slider',
			'active_callback'	=> 'travel_insight_pro_about_us_template_slider_custom',
	) ) );

	// About Us alt setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_custom_alt_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_custom_alt_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Alt Text %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_about_us_template_slider',
		'type'				=> 'text',
		'active_callback'	=> 'travel_insight_pro_about_us_template_slider_custom',
	) );

	// About Us link setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_custom_link_'. $i .']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_custom_link_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Link %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_about_us_template_slider',
		'type'				=> 'url',
		'active_callback'	=> 'travel_insight_pro_about_us_template_slider_custom',
	) );

	// Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_slider_page_'. $i .']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_slider_page_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ), 
		'description'		=> esc_html__( 'Note: Make sure the page you select has featured image', 'travel-insight-pro' ),
		'section'        	=> 'travel_insight_pro_about_us_template_slider',
		'active_callback' 	=> 'travel_insight_pro_about_us_template_slider_page',
		'type'				=> 'dropdown-pages'
	) );
}

/*
 * Services Section
 */
// About Services Section
$wp_customize->add_section( 'travel_insight_pro_about_us_template_service', array(
	'title'             => esc_html__( 'Services','travel-insight-pro' ),
	'description'       => esc_html__( 'Services Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_about_us_panel',
) );

// About Us Template Slider enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['about_us_template_service_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_service_enable]', array(
	'label'            	=> esc_html__( 'Enable Service Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_about_us_template_service',
	'type'             	=> 'checkbox',
) );

// About us Template Slider setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_image]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
	'default'          	=> get_template_directory_uri() . '/assets/uploads/about-content.jpg',
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[about_us_template_service_image]',
		array(
		'label'       		=> sprintf( esc_html__( 'Select Featured Background %d', 'travel-insight-pro' ), $i ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 381, 700 ),
		'section'     		=> 'travel_insight_pro_about_us_template_service',
		'active_callback'	=> 'travel_insight_pro_is_about_us_template_service_enable',
) ) );

// Add About Us Template service content type setting and control.
// Content type is similar to slider
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_type]', array(
	'default'           => $options['about_us_template_service_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_service_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_about_us_template_service',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_about_us_template_service_enable',
	'choices'         	=> travel_insight_pro_about_us_template_slider_type()
) );

// Service Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_service_post]', array(
	'active_callback'	=> 'travel_insight_pro_about_us_template_service_post',
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 4. ie: 11, 24, 34. Make sure the post you select has featured image', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_about_us_template_service',
	'type'				=> 'text',
) );

for ( $i = 1; $i <= 4; $i++ ) {
	// Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_page_'. $i .']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_service_page_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ), 
		'description'		=> esc_html__( 'Note: Make sure the page you select has featured image', 'travel-insight-pro' ),
		'section'        	=> 'travel_insight_pro_about_us_template_service',
		'active_callback' 	=> 'travel_insight_pro_about_us_template_service_page',
		'type'				=> 'dropdown-pages'
	) );

	// service post hr setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_hr'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Travel_Insight_Pro_Customize_Horizontal_Line( $wp_customize, 'travel_insight_pro_theme_options[about_us_template_service_hr'. $i .']',
		array(
			'section'         => 'travel_insight_pro_about_us_template_service',
			'active_callback' => 'travel_insight_pro_about_us_template_service_custom',
			'type'			  => 'hr'
	) ) );

	// service custom icon setting and control.
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_icon_' . $i . ']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_select',
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_service_icon_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Icon %d', 'travel-insight-pro' ), $i ),
		'section'         	=> 'travel_insight_pro_about_us_template_service',
		'type'            	=> 'select',
		'active_callback' 	=> 'travel_insight_pro_about_us_template_service_custom',
		'choices'         	=> travel_insight_pro_icons_options(),
	) );

	// Service Title setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_title_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_service_title_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Title %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_about_us_template_service',
		'type'				=> 'text',
		'active_callback'	=> 'travel_insight_pro_about_us_template_service_custom',
	) );

	// Service Title setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_link_'. $i .']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_service_link_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Link %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_about_us_template_service',
		'type'				=> 'url',
		'active_callback'	=> 'travel_insight_pro_about_us_template_service_custom',
	) );

	// Service description setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_template_service_description_'. $i .']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_template_service_description_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Description %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_about_us_template_service',
		'type'				=> 'textarea',
		'active_callback'	=> 'travel_insight_pro_about_us_template_service_custom',
	) );
}