<?php
/**
 * Contact Us Template options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// Add panel for section options
$wp_customize->add_panel( 'travel_insight_pro_contact_us_panel' , array(
    'title'      => esc_html__( 'Contact Us Template','travel-insight-pro' ),
    'description'=> esc_html__( 'Contact Us Template Options', 'travel-insight-pro' ),
    'priority'   => 150,
) );

/*
 * Contact form Section
 */
$wp_customize->add_section( 'travel_insight_pro_contact_form_section', array(
    'title'             => esc_html__( 'Contact Form','travel-insight-pro' ),
    'description'       => sprintf( esc_html__( 'There is a widget area for contact page and dedicated widget ( TP : Custom Page Info ) for contact page. %1$s Go to Widget Page %2$s', 'travel-insight-pro' ), '<a href="' . esc_url( admin_url( 'widgets.php' ) ) . '" target="_blank">', '</a>' ),
    'panel'             => 'travel_insight_pro_contact_us_panel',
) );

// Add Contact Page contact form.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[contact_page_form]', array(
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[contact_page_form]', array(
    'label'             => esc_html__( 'Contact Form Shortcode', 'travel-insight-pro' ),
    'description'       => sprintf( esc_html__( 'Input shortcode from Contact Form 7 Plugin. %1$s Download Plugin %2$s', 'travel-insight-pro' ), '<a href="' . esc_url( 'https://wordpress.org/plugins/contact-form-7' ) . '" target="_blank">', '</a>' ),
    'section'           => 'travel_insight_pro_contact_form_section',
    'type'              => 'text',
) );

/*
 * Map Section
 */
$wp_customize->add_section( 'travel_insight_pro_map_section', array(
    'title'             => esc_html__( 'Map','travel-insight-pro' ),
    'description'       => esc_html__( 'Map Options.', 'travel-insight-pro' ),
    'panel'             => 'travel_insight_pro_contact_us_panel',
) );

// Add Contact Page map.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[contact_map_enable]', array(
    'default'           => $options['contact_map_enable'],
    'sanitize_callback' => 'travel_insight_pro_sanitize_checkbox'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[contact_map_enable]', array(
    'label'             => esc_html__( 'Enable Map', 'travel-insight-pro' ),
    'section'           => 'travel_insight_pro_map_section',
    'type'              => 'checkbox',
) );

// contact map content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[map_content_type]', array(
    'sanitize_callback' => 'travel_insight_pro_sanitize_select',
    'default'           => $options['map_content_type'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[map_content_type]', array(
    'label'             => esc_html__( 'Content Type', 'travel-insight-pro' ),
    'section'           => 'travel_insight_pro_map_section',
    'type'              => 'select',
    'choices'           => travel_insight_pro_map(),
    'active_callback'   => 'travel_insight_pro_is_contact_map_enable',
) );

// Add Map shortcode
$wp_customize->add_setting( 'travel_insight_pro_theme_options[map_content_shortcode]', array(
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[map_content_shortcode]', array(
    'label'             => esc_html__( 'Input Map Shortcode', 'travel-insight-pro' ),
    'section'           => 'travel_insight_pro_map_section',
    'type'              => 'text',
    'active_callback'   => 'travel_insight_pro_contact_map_content_shortcode',
) );

// Add Map embed
$wp_customize->add_setting( 'travel_insight_pro_theme_options[map_content_embed]', array(
    'sanitize_callback' => 'travel_insight_pro_santize_iframe_map'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[map_content_embed]', array(
    'label'             => esc_html__( 'Input Map Embed Code', 'travel-insight-pro' ),
    'label'             => esc_html__( 'Notice: Please change width value to ( 100% )', 'travel-insight-pro' ),
    'section'           => 'travel_insight_pro_map_section',
    'type'              => 'textarea',
    'active_callback'   => 'travel_insight_pro_contact_map_content_embed',
) );