<?php
/**
 * About Us Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_about_us', array(
	'title'             => esc_html__( 'About Us','travel-insight-pro' ),
	'description'       => esc_html__( 'About Us Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// About Us Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['about_us_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_enable]', array(
	'label'            	=> esc_html__( 'Enable About Us Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_about_us',
	'type'             	=> 'checkbox',
) );

// Add About Us image alignment setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_alignment]', array(
	'default'           => $options['about_us_alignment'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_alignment]', array(
	'label'           	=> esc_html__( 'Image Alignment', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_about_us',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_about_us_enable',
	'choices'         	=> travel_insight_pro_about_us_image_alignment()
) );

// Add About Us content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_content_type]', array(
	'default'           => $options['about_us_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_about_us',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_about_us_enable',
	'choices'         	=> travel_insight_pro_about_us_content_type()
) );

// about Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_content_post]', array(
	'validate_callback' => 'travel_insight_pro_validate_post_id',
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_about_us_content_post',
	'label'             => esc_html__( 'Input Post Id', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_about_us',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_content_page]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_page'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_about_us',
	'active_callback' 	=> 'travel_insight_pro_about_us_content_page',
	'type'				=> 'dropdown-pages'
) );

// About Us Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_content_image]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
	'default' 			=> $options['about_us_content_image'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[about_us_content_image]',
		array(
		'label'       		=> esc_html__( 'Select Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 380, 457 ),
		'section'     		=> 'travel_insight_pro_about_us',
		'active_callback'	=> 'travel_insight_pro_about_us_content_custom',
) ) );

// About Us title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['about_us_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_about_us',
	'active_callback' 	=> 'travel_insight_pro_about_us_content_custom',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[about_us_title]', array(
		'selector'            => '#about .wrapper .entry-header h2.entry-title',
		'settings'            => 'travel_insight_pro_theme_options[about_us_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_about_us_title',
    ) );
}

// About Us sub title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['about_us_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_about_us',
	'active_callback' 	=> 'travel_insight_pro_about_us_content_not_demo',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[about_us_sub_title]', array(
		'selector'            => '#about .wrapper .entry-header h3.sub-title',
		'settings'            => 'travel_insight_pro_theme_options[about_us_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_about_us_sub_title',
    ) );
}

// About Us description setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['about_us_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_description]', array(
	'label'           	=> esc_html__( 'Description', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_about_us',
	'active_callback' 	=> 'travel_insight_pro_about_us_content_custom',
	'type'				=> 'textarea'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[about_us_description]', array(
		'selector'            => '#about .wrapper .entry-content p',
		'settings'            => 'travel_insight_pro_theme_options[about_us_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_about_us_description',
    ) );
}

// About Us link setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['about_us_btn_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_btn_label]', array(
	'label'           	=> esc_html__( 'Button Link Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_about_us',
	'active_callback' 	=> 'travel_insight_pro_about_us_content_not_demo',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[about_us_btn_label]', array(
		'selector'            => '#about .wrapper .entry-content a',
		'settings'            => 'travel_insight_pro_theme_options[about_us_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_about_us_btn',
    ) );
}

// About Us link setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[about_us_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
	'default'          	=> $options['about_us_btn_link'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[about_us_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_about_us',
	'active_callback' 	=> 'travel_insight_pro_about_us_content_custom',
	'type'				=> 'url'
) );
