<?php
/**
 * Articles Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_articles', array(
	'title'             => esc_html__( 'Articles','travel-insight-pro' ),
	'description'       => esc_html__( 'Articles Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Articles Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[articles_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['articles_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[articles_enable]', array(
	'label'            	=> esc_html__( 'Enable Articles Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_articles',
	'type'             	=> 'checkbox',
) );

// Articles Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[articles_background]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
	'default'			=> $options['articles_background'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[articles_background]',
		array(
		'label'       		=> esc_html__( 'Select Background Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 1920, 1080 ),
		'section'     		=> 'travel_insight_pro_articles',
		'active_callback'	=> 'travel_insight_pro_is_articles_enable',
) ) );

// Add Articles content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[articles_content_type]', array(
	'default'           => $options['articles_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[articles_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_articles',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_articles_enable',
	'choices'         	=> travel_insight_pro_articles_content_type(),
) );

// Articles Section no of category setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_articles_category]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_number_range',
	'validate_callback'	=> 'travel_insight_pro_validate_articles_category',
	'default'          	=> $options['no_of_articles_category'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_articles_category]', array(
	'label'            	=> esc_html__( 'No. of Category', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 4. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_articles',
	'type'             	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_articles_content_category',
	'input_attrs'     	=> array(
		'max' 	=> 4,
		'min' 	=> 1,
		'style' => 'width:100px'
	)
) );

// Articles Section no of category setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_articles]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_number_range',
	'validate_callback'	=> 'travel_insight_pro_validate_articles',
	'default'          	=> $options['no_of_articles'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_articles]', array(
	'label'            	=> esc_html__( 'No. of Articles per Category', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 5. Please input the valid number and save.', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_articles',
	'type'             	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_articles_content_category',
	'input_attrs'     	=> array(
		'max' 	=> 5,
		'min' 	=> 1,
		'style' => 'width:100px'
	)
) );

for ( $i = 1; $i <= $options['no_of_articles_category']; $i++ ) {
	// Popular Destination category setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[articles_content_category_' . $i . ']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
	) );

	$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[articles_content_category_' . $i . ']', array(
		'label'           => sprintf( esc_html__( 'Select Category %d', 'travel-insight-pro' ), $i ),
		'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
		'section'         => 'travel_insight_pro_articles',
		'type'			  => 'dropdown-category',
		'active_callback' => 'travel_insight_pro_articles_content_category',
	) ) );
}
