<?php
/**
 * Call To Action Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_call_to_action', array(
	'title'             => esc_html__( 'Call To Action','travel-insight-pro' ),
	'description'       => esc_html__( 'Call To Action Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Call To Action Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['call_to_action_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_enable]', array(
	'label'            	=> esc_html__( 'Enable Call To Action Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_call_to_action',
	'type'             	=> 'checkbox',
) );

// Add call_to_action content type setting and control.
// content type options is similar to about us section
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_content_type]', array(
	'default'           => $options['call_to_action_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_call_to_action',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_call_to_action_enable',
	'choices'         	=> travel_insight_pro_about_us_content_type(),
) );

// call to action Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_content_post]', array(
	'validate_callback' => 'travel_insight_pro_validate_post_id',
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_call_to_action_content_post',
	'label'             => esc_html__( 'Input Post Id', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_call_to_action',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_content_page]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_page'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_call_to_action',
	'active_callback' 	=> 'travel_insight_pro_call_to_action_content_page',
	'type'				=> 'dropdown-pages'
) );

// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['call_to_action_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_call_to_action',
	'active_callback' 	=> 'travel_insight_pro_call_to_action_content_custom',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[call_to_action_title]', array(
		'selector'            => '#call-to-action .wrapper .entry-header h2.entry-title',
		'settings'            => 'travel_insight_pro_theme_options[call_to_action_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_call_to_action_title',
    ) );
}

if ( $options['home_layout'] !== 'eight-design' ):

// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['call_to_action_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_call_to_action',
	'active_callback' 	=> 'travel_insight_pro_is_call_to_action_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[call_to_action_sub_title]', array(
		'selector'            => '#call-to-action .wrapper .entry-header h3.sub-title',
		'settings'            => 'travel_insight_pro_theme_options[call_to_action_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_call_to_action_sub_title',
    ) );
}

// Call to action description setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['call_to_action_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_description]', array(
	'label'           	=> esc_html__( 'Description', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_call_to_action',
	'active_callback' 	=> 'travel_insight_pro_call_to_action_content_custom',
	'type'				=> 'textarea'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[call_to_action_description]', array(
		'selector'            => '#call-to-action .wrapper .entry-content p',
		'settings'            => 'travel_insight_pro_theme_options[call_to_action_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_call_to_action_description',
    ) );
}

endif;

// Call to action btn link setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_btn_link]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['call_to_action_btn_link'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_btn_link]', array(
	'label'           	=> esc_html__( 'Button Label', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_call_to_action',
	'active_callback' 	=> 'travel_insight_pro_call_to_action_content_custom',
	'type'				=> 'text'
) );


// Slider Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_background]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
	'default'          	=> $options['call_to_action_background'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[call_to_action_background]',
		array(
		'label'       		=> esc_html__( 'Select Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 1920, 1080 ),
		'section'     		=> 'travel_insight_pro_call_to_action',
		'active_callback'	=> 'travel_insight_pro_call_to_action_content_custom',
) ) );


// Call to action btn label setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[call_to_action_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['call_to_action_btn_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[call_to_action_btn_label]', array(
	'label'           	=> esc_html__( 'Button Label', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_call_to_action',
	'active_callback' 	=> 'travel_insight_pro_is_call_to_action_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[call_to_action_btn_label]', array(
		'selector'            => '#call-to-action .wrapper .view-more a',
		'settings'            => 'travel_insight_pro_theme_options[call_to_action_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_call_to_action_btn_label',
    ) );
}
