<?php
/**
 * Gallery Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_gallery', array(
	'title'             => esc_html__( 'Gallery','travel-insight-pro' ),
	'description'       => esc_html__( 'Gallery Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Gallery Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[gallery_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['gallery_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[gallery_enable]', array(
	'label'            	=> esc_html__( 'Enable Gallery Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_gallery',
	'type'             	=> 'checkbox',
) );

// About Us title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[gallery_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['gallery_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[gallery_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_gallery',
	'active_callback' 	=> 'travel_insight_pro_is_gallery_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[gallery_title]', array(
		'selector'            => '#portfolio-gallery .wrapper .entry-header h2.entry-title',
		'settings'            => 'travel_insight_pro_theme_options[gallery_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_gallery_title',
    ) );
}

// About Us title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[gallery_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['gallery_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[gallery_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_gallery',
	'active_callback' 	=> 'travel_insight_pro_is_gallery_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[gallery_sub_title]', array(
		'selector'            => '#portfolio-gallery .wrapper .entry-header h3.sub-title',
		'settings'            => 'travel_insight_pro_theme_options[gallery_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_gallery_sub_title',
    ) );
}

// Add gallery content type setting and control.
// content type options is similar to articles section
$wp_customize->add_setting( 'travel_insight_pro_theme_options[gallery_content_type]', array(
	'default'           => $options['gallery_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[gallery_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_gallery',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_gallery_enable',
	'choices'         	=> travel_insight_pro_articles_content_type(),
) );

// Popular Destination category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[gallery_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_category_list'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Category_Control( $wp_customize, 'travel_insight_pro_theme_options[gallery_content_category]', array(
	'label'           => esc_html__( 'Select Multiple Categories', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Note: Press Shift and Click on multiple categories to select. Only the Posts that has featured image will be shown from selected categories will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_gallery',
	'type'			  => 'dropdown-categories',
	'active_callback' => 'travel_insight_pro_gallery_content_category',
) ) );

