<?php
/**
 * Guide Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_guide', array(
	'title'             => esc_html__( 'Guide','travel-insight-pro' ),
	'description'       => esc_html__( 'Guide Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Guide Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['guide_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_enable]', array(
	'label'            	=> esc_html__( 'Enable Guide Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_guide',
	'type'             	=> 'checkbox',
) );

// Tour title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['guide_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_guide',
	'active_callback' 	=> 'travel_insight_pro_is_guide_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[guide_title]', array(
		'selector'            => '#survival .wrapper .entry-header h2.entry-title',
		'settings'            => 'travel_insight_pro_theme_options[guide_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_guide_title',
    ) );
}

// Tour title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['guide_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_guide',
	'active_callback' 	=> 'travel_insight_pro_is_guide_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[guide_sub_title]', array(
		'selector'            => '#survival .wrapper .entry-header h3.sub-title',
		'settings'            => 'travel_insight_pro_theme_options[guide_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_guide_sub_title',
    ) );
}

// Add Guide content type setting and control.
// content type options is similar to slider section
$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_content_type]', array(
	'default'           => $options['guide_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_guide',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_guide_enable',
	'choices'         	=> travel_insight_pro_slider_content_type(),
) );

// Guide Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_content_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_guide_content_post',
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 9. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_guide',
	'type'				=> 'text',
) );

// Add guide number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_guide]', array(
	'default'           => $options['no_of_guide'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_guides_count',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_guide]', array(
	'label'           	=> esc_html__( 'Number of Guides', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 9. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_guide',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_guide_count',
	'input_attrs'     	=> array(
		'max' 	=> 9,
		'min' 	=> 1,
		'style' => 'width:100px',
	)
) );

// Guide Section category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[guide_content_category]', array(
	'label'           => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown. You can update icon from category edit page.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_guide',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_guide_content_category',
) ) );

for ( $i = 1; $i <= $options['no_of_guide']; $i++ ) {

	// Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_content_page_'. $i .']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_content_page_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_guide',
		'active_callback' 	=> 'travel_insight_pro_guide_content_page',
		'type'				=> 'dropdown-pages'
	) );

	// Tour hr setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_custom_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Travel_Insight_Pro_Customize_Horizontal_Line( $wp_customize, 'travel_insight_pro_theme_options[guide_custom_hr_'. $i .']',
		array(
			'section'         => 'travel_insight_pro_guide',
			'active_callback' => 'travel_insight_pro_guide_content_custom',
			'type'			  => 'hr'
	) ) );

	// Guide custom icon setting and control.
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_custom_icon_' . $i . ']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_select',
		'default'			=> $options['guide_custom_icon'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_custom_icon_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Tour icon %d', 'travel-insight-pro' ), $i ),
		'section'         	=> 'travel_insight_pro_guide',
		'type'            	=> 'select',
		'active_callback' 	=> 'travel_insight_pro_guide_content_custom',
		'choices'         	=> travel_insight_pro_icons_options(),
	) );

	// Guide custom title setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_content_custom_title_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['guide_content_custom_title'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_content_custom_title_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Input Title %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_guide',
		'active_callback' 	=> 'travel_insight_pro_guide_content_custom',
		'type'				=> 'text'
	) );

	// Guide custom title setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_content_custom_link_'. $i .']', array(
		'sanitize_callback' => 'esc_url_raw',
		'default'			=> $options['guide_content_custom_link'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_content_custom_link_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Input Link %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_guide',
		'active_callback' 	=> 'travel_insight_pro_guide_content_custom',
		'type'				=> 'url'
	) );

	// Guide custom description setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[guide_content_custom_description_'. $i .']', array(
		'sanitize_callback' => 'wp_kses_post',
		'default'			=> $options['guide_content_custom_description'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[guide_content_custom_description_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Input Description %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_guide',
		'active_callback' 	=> 'travel_insight_pro_guide_content_custom',
		'type'				=> 'textarea'
	) );

}