<?php
/**
 * Subscription Section options
 *
 * @package Theme Palace
 * @subpackage Travel_Insight Pro
 * @since Travel_Insight Pro 1.0.0
 */

// Add Subscription section
$wp_customize->add_section( 'travel_insight_pro_subscription_section', array(
	'title'             => esc_html__( 'Subscription','travel-insight-pro' ),
	'description'       => esc_html__( 'Note: To activate this section you need to install Jetpack Plugin and activate subscription module.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Subscription content enable control and setting
// Team Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[subscription_section_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['subscription_section_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[subscription_section_enable]', array(
	'label'            	=> esc_html__( 'Enable Subscription Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_subscription_section',
	'type'             	=> 'checkbox',
) );

// subscription title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[subscription_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['subscription_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[subscription_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_subscription_section',
	'active_callback' 	=> 'travel_insight_pro_is_subscription_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[subscription_title]', array(
		'selector'            => '#subscribe-us h2.section-title',
		'settings'            => 'travel_insight_pro_theme_options[subscription_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_subscription_title_partial',
    ) );
}

// subscription subtitle setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[subscription_subtitle]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['subscription_subtitle'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[subscription_subtitle]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_subscription_section',
	'active_callback' 	=> 'travel_insight_pro_is_subscription_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[subscription_subtitle]', array(
		'selector'            => '#subscribe-us p.section-subtitle',
		'settings'            => 'travel_insight_pro_theme_options[subscription_subtitle]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_subscription_subtitle_partial',
    ) );
}

// Call to action description setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[subscription_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['subscription_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[subscription_description]', array(
	'label'           	=> esc_html__( 'Description', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_subscription_section',
	'active_callback' 	=> 'travel_insight_pro_is_subscription_section_enable',
	'type'				=> 'textarea'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[subscription_description]', array(
		'selector'            => '#call-to-action .wrapper .entry-content p',
		'settings'            => 'travel_insight_pro_theme_options[subscription_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_subscription_description',
    ) );
}

$wp_customize->add_setting( 'travel_insight_pro_theme_options[subscription_background]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
	'default'          	=> $options['subscription_background'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[subscription_background]',
		array(
		'label'       		=> esc_html__( 'Select Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 1920, 1080 ),
		'section'     		=> 'travel_insight_pro_subscription_section',
		'active_callback'	=> 'travel_insight_pro_is_subscription_section_enable',
) ) );
