<?php
/**
 * team Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0.0
 */

// Add team section
$wp_customize->add_section( 'travel_insight_pro_team_section', array(
	'title'             =>	esc_html__( 'Team', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Team Section options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Team Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_section_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['team_section_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[team_section_enable]', array(
	'label'            	=> esc_html__( 'Enable Team Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_team_section',
	'type'             	=> 'checkbox',
) );

// team title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[team_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_team_section',
	'active_callback' 	=> 'travel_insight_pro_is_team_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[team_title]', array(
		'selector'            => '#business-team .business-section-header h2',
		'settings'            => 'travel_insight_pro_theme_options[team_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_team_title_partial',
    ) );
}

// team sub title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[team_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_team_section',
	'active_callback' 	=> 'travel_insight_pro_is_team_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[team_sub_title]', array(
		'selector'            => '#business-team .business-section-header  p',
		'settings'            => 'travel_insight_pro_theme_options[team_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_team_sub_title_partial',
    ) );
}


// Event social icons number control and setting
$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_count]', array(
	'default'          	=> $options['team_count'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_team_count',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[team_count]', array(
	'label'             => esc_html__( 'Number of Team', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_team_section',
	'active_callback'   => 'travel_insight_pro_is_team_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// team content type control and setting
$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_column_layout]', array(
	'default'          	=> $options['team_column_layout'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[team_column_layout]', array(
	'label'             => esc_html__( 'Column Layout', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_team_section',
	'type'				=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_team_section_enable',
	'choices'			=> array( 
		'col-3' 		=> esc_html__( '3 Column', 'travel-insight-pro' ),
		'col-4' 		=> esc_html__( '4 Column', 'travel-insight-pro' ),
	),
) );

// team content type control and setting
$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_content_type]', array(
	'default'          	=> $options['team_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[team_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_team_section',
	'type'				=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_team_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'travel-insight-pro' ),
		'post' 		=> esc_html__( 'Post', 'travel-insight-pro' ),
		'category' 	=> esc_html__( 'Category', 'travel-insight-pro' ),
	),
) );

    $wp_customize->add_setting( 'travel_insight_pro_theme_options[team_content_post]', array(
        'sanitize_callback' => 'travel_insight_pro_sanitize_single_post_id',
    ) );
    
    $wp_customize->add_control( 'travel_insight_pro_theme_options[team_content_post]', array(
        'active_callback'	=> 'travel_insight_pro_is_team_section_content_post_enable',
        'label'             => esc_html__( 'Input Post Id', 'travel-insight-pro' ),
        'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34', 'travel-insight-pro' ),
        'section'           => 'travel_insight_pro_team_section',
        'type'				=> 'text',
    ) );

for ( $i = 1; $i <= $options['team_count']; $i++ ) :

	// Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_content_page_'.$i.']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[team_content_page_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_team_section',
		'active_callback' 	=> 'travel_insight_pro_is_team_section_content_page_enable',
		'type'				=> 'dropdown-pages'
	) );
   
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_position_' . $i. ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[team_position_' . $i. ']', array(
		'label'           	=> sprintf( esc_html__( 'Post Text %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_team_section',
		'active_callback' 	=> 'travel_insight_pro_is_team_section_enable',
		'type'				=> 'text',
	) );


		
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[team_social_' . $i. ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new Travel_Insight_Pro_Multi_Input_Custom_Control( $wp_customize, 'travel_insight_pro_theme_options[team_social_' . $i. ']', array(
		'label'             => esc_html__( 'Social Link', 'travel-insight-pro' ),
		'button_text'       => esc_html__( 'Add social', 'travel-insight-pro' ),
		'section'           => 'travel_insight_pro_team_section',
		'active_callback' 	=> 'travel_insight_pro_is_team_section_enable',
	) ) );



    $wp_customize->add_setting( 'travel_insight_pro_theme_options[team_hr_'. $i .']', array(
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    $wp_customize->add_control( new Travel_Insight_Pro_Customize_Horizontal_Line( $wp_customize, 'travel_insight_pro_theme_options[team_hr_'. $i .']',
        array(
            'section'           => 'travel_insight_pro_team_section',
            'active_callback'   => 'travel_insight_pro_is_team_section_enable',
            'type'            => 'hr'
    ) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'travel_insight_pro_theme_options[team_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize,'travel_insight_pro_theme_options[team_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_team_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'travel_insight_pro_is_team_section_content_category_enable'
) ) );