<?php
/**
 * Two Column Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_two_column', array(
	'title'             => esc_html__( 'Two Column','travel-insight-pro' ),
	'description'       => esc_html__( 'Two Column Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Two Column Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['two_column_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[two_column_enable]', array(
	'label'            	=> esc_html__( 'Enable Two Column Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_two_column',
	'type'             	=> 'checkbox',
) );

// Add Two Column content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_content_type]', array(
	'default'           => $options['two_column_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[two_column_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_two_column',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_two_column_enable',
	'choices'         	=> array(
        'category'  => esc_html__( 'Category', 'travel-insight-pro' ),
        'page'      => esc_html__( 'Page', 'travel-insight-pro' ),
        'post'      => esc_html__( 'Post', 'travel-insight-pro' ),
    ),
) );


// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['two_column_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[two_column_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_two_column',
	'active_callback' 	=> 'travel_insight_pro_is_two_column_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[two_column_title]', array(
		'selector'            => '#recent-posts .section-header h2',
		'settings'            => 'travel_insight_pro_theme_options[two_column_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_two_column_title_partial',
    ) );
}

// Add two_column number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_two_column]', array(
	'default'           => $options['no_of_two_column'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_two_column_count',
	'transport'			=> 'refresh',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_two_column]', array(
	'label'           	=> esc_html__( 'Number of Articles', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 10. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_two_column',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_is_two_column_enable',
	'input_attrs'     	=> array(
		'max' 	=> 10,
		'min' 	=> 2,
		'style' => 'width:100px'
	)
) );

// Slider Section category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[two_column_content_category]', array(
	'label'           => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_two_column',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_two_column_content_category',
) ) );

// Slider Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_content_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[two_column_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_two_column_content_post',
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_two_column',
	'type'				=> 'text',
) );

for ( $i = 1; $i <= $options['no_of_two_column']; $i++ ) {
    // Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_content_page_'.$i.']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[two_column_content_page_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_two_column',
		'active_callback' 	=> 'travel_insight_pro_two_column_content_page',
		'type'				=> 'dropdown-pages'
	) );
}

if ( $options['home_layout'] !== 'fifth-design' ):

// Slider Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_ads_image]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[two_column_ads_image]',
		array(
		'label'       		=> esc_html__( 'Select Ads Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 690, 90 ),
		'section'     		=> 'travel_insight_pro_two_column',
		'active_callback'	=> 'travel_insight_pro_is_two_column_enable',
) ) );

// Two Column btn link setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_ads_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'default'          	=> '#',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[two_column_ads_url]', array(
	'label'           	=> esc_html__( 'Ads image URL', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_two_column',
	'active_callback' 	=> 'travel_insight_pro_is_two_column_enable',
	'type'				=> 'text'
) );

endif;

if ( $options['home_layout'] == 'fifth-design' ):

$wp_customize->add_setting( 'travel_insight_pro_theme_options[two_column_button]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['two_column_button'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[two_column_button]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_two_column',
	'active_callback' 	=> 'travel_insight_pro_is_two_column_enable',
	'type'				=> 'text'
) );
endif;