<?php
/**
 * Video Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_video', array(
	'title'             => esc_html__( 'Video','travel-insight-pro' ),
	'description'       => esc_html__( 'Video Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Video Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[video_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['video_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[video_enable]', array(
	'label'            	=> esc_html__( 'Enable Video Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_video',
	'type'             	=> 'checkbox',
) );

// Add video content type setting and control.
// content type options is similar to about us section
$wp_customize->add_setting( 'travel_insight_pro_theme_options[video_content_type]', array(
	'default'           => $options['video_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[video_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_video',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_video_enable',
	'choices'         	=> travel_insight_pro_about_us_content_type(),
) );

// call to action Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[video_content_post]', array(
	'validate_callback' => 'travel_insight_pro_validate_post_id',
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[video_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_video_content_post',
	'label'             => esc_html__( 'Input Post Id', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_video',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[video_content_page]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_page'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[video_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_video',
	'active_callback' 	=> 'travel_insight_pro_video_content_page',
	'type'				=> 'dropdown-pages'
) );

// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[video_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['video_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[video_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_video',
	'active_callback' 	=> 'travel_insight_pro_video_content_custom',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[video_title]', array(
		'selector'            => '#business-video .business-section-header h2',
		'settings'            => 'travel_insight_pro_theme_options[video_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_video_title_partial',
    ) );
}

// Call to action description setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[video_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['video_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[video_description]', array(
	'label'           	=> esc_html__( 'Description', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_video',
	'active_callback' 	=> 'travel_insight_pro_video_content_custom',
	'type'				=> 'textarea'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[video_description]', array(
		'selector'            => '#business-video .business-section-header p',
		'settings'            => 'travel_insight_pro_theme_options[video_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_video_description_partial',
    ) );
}


// Slider Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[video_background]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
	'default'          	=> $options['video_background'],
	) );
	
	$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[video_background]',
	array(
		'label'       		=> esc_html__( 'Select Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 1920, 1080 ),
		'section'     		=> 'travel_insight_pro_video',
		'active_callback'	=> 'travel_insight_pro_video_content_custom',
		) ) );
		
		
		//Video URL setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[video_link]', array(
		'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[video_link]', array(
	'label'           	=> esc_html__( 'Video URL', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_video',
	'active_callback' 	=> 'travel_insight_pro_is_video_enable',
	'type'				=> 'text'
) );
