<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// Add sidebar section
$wp_customize->add_section( 'travel_insight_pro_layout', array(
	'title'               => esc_html__('Layout','travel-insight-pro'),
	'description'         => esc_html__( 'Layout section options.', 'travel-insight-pro' ),
	'panel'               => 'travel_insight_pro_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[sidebar_position]', array(
	'sanitize_callback'   => 'travel_insight_pro_sanitize_select',
	'default'             => $options['sidebar_position'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[sidebar_position]', array(
	'label'               => esc_html__( 'Sidebar Position', 'travel-insight-pro' ),
	'section'             => 'travel_insight_pro_layout',
	'type'                => 'select',
	'choices'			  => travel_insight_pro_sidebar_position(),
) );

// Content width setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[content_width]', array(
	'sanitize_callback'   => 'travel_insight_pro_sanitize_select',
	'default'             => $options['content_width'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[content_width]', array(
	'label'               => esc_html__( 'Content Width', 'travel-insight-pro' ),
	'description'         => esc_html__( 'Note: It works on single post and page', 'travel-insight-pro' ),
	'section'             => 'travel_insight_pro_layout',
	'type'                => 'select',
	'choices'			  => travel_insight_pro_single_content_width(),
) );

// Site layout setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[site_layout]', array(
	'sanitize_callback'   => 'travel_insight_pro_sanitize_select',
	'default'             => $options['site_layout'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[site_layout]', array(
	'label'               => esc_html__( 'Site Layout', 'travel-insight-pro' ),
	'section'             => 'travel_insight_pro_layout',
	'type'                => 'select',
	'choices'			  => travel_insight_pro_site_layout(),
) );
