<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// Add sidebar section
$wp_customize->add_section( 'travel_insight_pro_pagination', array(
	'title'               => esc_html__('Pagination','travel-insight-pro'),
	'description'         => esc_html__( 'Pagination section options.', 'travel-insight-pro' ),
	'panel'               => 'travel_insight_pro_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[pagination_enable]', array(
	'sanitize_callback'   => 'travel_insight_pro_sanitize_checkbox',
	'default'             => $options['pagination_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[pagination_enable]', array(
	'label'               => esc_html__( 'Pagination Enable', 'travel-insight-pro' ),
	'section'             => 'travel_insight_pro_pagination',
	'type'                => 'checkbox',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[pagination_type]', array(
	'sanitize_callback'   => 'travel_insight_pro_sanitize_select',
	'default'             => $options['pagination_type'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[pagination_type]', array(
	'label'               => esc_html__( 'Pagination Type', 'travel-insight-pro' ),
	'section'             => 'travel_insight_pro_pagination',
	'type'                => 'select',
	'choices'			  => travel_insight_pro_pagination_options(),
	'active_callback'	  => 'travel_insight_pro_is_pagination_enable',
) );
