<?php
/**
 * Homepage Sortable options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// Add sidebar section
$wp_customize->add_section( 'travel_insight_pro_sortable', array(
	'title'               => esc_html__('Homepage Sortable','travel-insight-pro'),
	'description'         => esc_html__( 'Homepage Sortable section options.', 'travel-insight-pro' ),
	'panel'               => 'travel_insight_pro_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[sortable]', array(
	'default'			  => $options['sortable'],
	'sanitize_callback'   => 'travel_insight_pro_sanitize_sortable',
) );

$wp_customize->add_control( new Travel_Insight_Pro_Customize_Sortable_Control ( $wp_customize, 'travel_insight_pro_theme_options[sortable]', array(
	'label'               => esc_html__( 'Sortable Homepage', 'travel-insight-pro' ),
	'description'         => esc_html__( 'Drag and Drop to sort the sections according to your preference.', 'travel-insight-pro' ),
	'section'             => 'travel_insight_pro_sortable',
	'type'                => 'sortable',
	'choices'			  => travel_insight_pro_sortable(),
) ) );

