<?php
/**
* Customizer validation functions
*
* @package Theme Palace
* @subpackage Travel Insight Pro
* @since Travel Insight Pro 1.0
*/

if ( ! function_exists( 'travel_insight_pro_validate_long_excerpt' ) ) :
  function travel_insight_pro_validate_long_excerpt( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 5 ) {
         $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'travel-insight-pro' ) );
     } elseif ( $value > 100 ) {
         $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_post_id' ) ) :
  function travel_insight_pro_validate_post_id( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_value', esc_html__( 'Minimum value is 1', 'travel-insight-pro' ) );
     } 
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_slider_count' ) ) :
  function travel_insight_pro_validate_slider_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_slides', esc_html__( 'Minimum no of slide is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_slides', esc_html__( 'Maximum no of slides is 10', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_popular_destination_count' ) ) :
  function travel_insight_pro_validate_popular_destination_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_destination', esc_html__( 'Minimum no of destinations is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 7 ) {
         $validity->add( 'max_no_of_destination', esc_html__( 'Maximum no of destinations is 7', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_articles_category' ) ) :
  function travel_insight_pro_validate_articles_category( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_articles_category', esc_html__( 'Minimum no of article category is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 4 ) {
         $validity->add( 'max_no_of_articles_category', esc_html__( 'Maximum no of article categories is 4', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_articles' ) ) :
  function travel_insight_pro_validate_articles( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_articles', esc_html__( 'Minimum no of article is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 5 ) {
         $validity->add( 'max_no_of_articles', esc_html__( 'Maximum no of article is 5', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_tours_count' ) ) :
  function travel_insight_pro_validate_tours_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_tours', esc_html__( 'Minimum no of tour is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_tours', esc_html__( 'Maximum no of tours is 10', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_packages_count' ) ) :
  function travel_insight_pro_validate_packages_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_packages', esc_html__( 'Minimum no of package is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_packages', esc_html__( 'Maximum no of packages is 10', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_guides_count' ) ) :
  function travel_insight_pro_validate_guides_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_guides', esc_html__( 'Minimum no of guide is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 9 ) {
         $validity->add( 'max_no_of_guides', esc_html__( 'Maximum no of guides is 9', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_two_column_count' ) ) :
  function travel_insight_pro_validate_two_column_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 2 ) {
         $validity->add( 'min_no_of_guides', esc_html__( 'Minimum no of guide is 2', 'travel-insight-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_guides', esc_html__( 'Maximum no of guides is 10', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_latest_post_count' ) ) :
  function travel_insight_pro_validate_latest_post_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 3 ) {
         $validity->add( 'min_no_of_guides', esc_html__( 'Minimum no of guide is 3', 'travel-insight-pro' ) );
     } elseif ( $value > 9 ) {
         $validity->add( 'max_no_of_guides', esc_html__( 'Maximum no of guides is 9', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_featured_count' ) ) :
  function travel_insight_pro_validate_featured_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 3 ) {
         $validity->add( 'min_no_of_guides', esc_html__( 'Minimum no of guide is 3', 'travel-insight-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_guides', esc_html__( 'Maximum no of guides is 12', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_recent_product_count' ) ) :
  function travel_insight_pro_validate_recent_product_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_product', esc_html__( 'Minimum no of product is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_product', esc_html__( 'Maximum no of product is 12', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_service_count' ) ) :
  function travel_insight_pro_validate_service_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 3 ) {
         $validity->add( 'min_no_of_product', esc_html__( 'Minimum no of product is 3', 'travel-insight-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_product', esc_html__( 'Maximum no of product is 12', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_latest_product_count' ) ) :
  function travel_insight_pro_validate_latest_product_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_product', esc_html__( 'Minimum no of product is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_product', esc_html__( 'Maximum no of product is 12', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'travel_insight_pro_validate_team_count' ) ) :
  function travel_insight_pro_validate_team_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'travel-insight-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_product', esc_html__( 'Minimum no of product is 1', 'travel-insight-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_product', esc_html__( 'Maximum no of product is 12', 'travel-insight-pro' ) );
     }
     return $validity;
  }
endif;