<?php 
/**
 * Featured section
 *
 * This is the template for the content of featured section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_featured_section' ) ) :
    /**
    * Add featured section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_featured_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if featured is enabled
        $enable_featured = apply_filters( 'travel_insight_pro_section_status', true, 'featured_enable' );

        if ( true !== $enable_featured ) {
            return false;
        }

        // Get featured section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_featured_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render featured section now.
        travel_insight_pro_render_featured_section( $section_details );
    }
endif;


if ( ! function_exists( 'travel_insight_pro_get_featured_section_details' ) ) :
    /**
    * featured section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input featured section details.
    */
    function travel_insight_pro_get_featured_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // featured type
        $featured_content_type  = $options['featured_content_type'];

        $content = array();
        switch ( $featured_content_type ) {

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $options['no_of_featured']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'featured_content_page_'.$i ] ) ) {
                        $id = $options[ 'featured_content_page_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $options['no_of_featured'] ),
                );
            break;

            case 'category':
                $cat_id = '';
                if ( ! empty( $options['featured_content_category'] ) ) {
                    $cat_id = $options['featured_content_category'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'no_found_rows'  => true,
                    'cat'            => $cat_id,
                    'post_type'      => 'post',
                    'posts_per_page'  => absint( $options['no_of_featured'] ),
                );
            break;

            case 'post':
                $ids = array();
                
                if ( ! empty( $options['featured_content_post'] ) )
                    $ids = ( array ) $options['featured_content_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;
        }

        $posts = get_posts( $args );
        if ( ! empty( $posts ) ) :
            $i = 1;
            foreach ( $posts as $post ) :
                $post_id = $post->ID;
                $img_array = null;
                if ( has_post_thumbnail( $post_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
                } else {
                    $img_array[0] =  get_template_directory_uri().'/assets/uploads/no-featured-image-1920x1080.jpg';
                }

                if ( isset( $img_array ) ) {
                    $content[$i]['img_array'] = $img_array;
                }

                $content[$i]['title']       = get_the_title( $post_id );
                $content[$i]['id']          =  $post_id ;
                $content[$i]['url']         = get_the_permalink( $post_id );
                $content[$i]['excerpt']     = travel_insight_pro_trim_content( 25, get_post( $post_id ) );
                $i++;
            endforeach;
        endif;

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// featured section content details.
add_filter( 'travel_insight_pro_filter_featured_section_details', 'travel_insight_pro_get_featured_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_featured_section' ) ) :
    /**
    * Start featured section
    *
    * @return string featured content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_featured_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();


        if ( empty( $content_details ) ) {
            return;
        }

        $i = 1;
        ?>

        <?php if ( $options['home_layout'] == 'fourth-design' ): ?>
        <section id="featured-posts" class="page-section">
            <div class="wrapper">
            <?php if( !empty( $options['featured_title'] ) ): ?>
                <div class="section-header">
                    <h2 class="section-title"><?php echo esc_html( $options['featured_title'] ); ?></h2>
                </div><!-- .section-header -->
            <?php endif; ?>

                <div class="<?php echo esc_attr($options['featured_column_layout']); ?> clear">
                    <?php foreach( $content_details as $content_detail ) : ?>

                        <article>
                            <div class="featured-post-item">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ); ?>');">
                                    <a href="<?php echo esc_url( $content_detail['url'] ); ?>" class="post-thumbnail-link"></a>
                                </div>

                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <?php travel_insight_pro_posted_on( $content_detail['id'] ) ; ?>


                                        <span class="cat-links">
                                            <?php the_category( '', '', $content_detail['id']); ?>
                                        </span><!-- .cat-links -->
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                    </header>

                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                                    </div>
                                </div>
                            </div><!-- .featured-post-item -->
                        </article>
                        <?php $i++; endforeach; ?>

                    </div><!-- .col-4 -->
                </div><!-- .container -->
            </section><!-- #featured-posts -->

        <?php endif; ?>

        <?php if ( $options['home_layout'] == 'fifth-design' ): ?>

            <section id="blog-featured-posts" class="relative page-section">
            <div class="wrapper">
            <?php if( !empty( $options['featured_title'] ) ): ?>
                <div class="section-header">
                    <h2 class="section-title"><?php echo esc_html( $options['featured_title'] ); ?></h2>
                </div><!-- .section-header -->
            <?php endif; ?>

                <div class="blog-section-content clear">

                <?php foreach( $content_details as $content_detail ) : ?>
                    
                    <article>
                        <div class="blog-featured-image" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ); ?>');">
                            
                        </div><!-- .blog-featured-image -->
                        <div class="entry-container">
                                <span class="cat-links">
                                    <?php the_category( '', '', $content_detail['id']); ?>                             
                                </span><!-- .cat-links -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                </header>

                                <?php travel_insight_pro_posted_on( $content_detail['id'] ) ; ?><!-- .posted-on -->
                            </div><!-- .entry-container -->
                    </article>

                <?php endforeach; ?>

                </div><!-- .blog-section-content -->
            </div><!-- .wrapper -->
        </section>

        <?php endif; ?>

        <?php if ( $options['home_layout'] == 'seven-design' ): ?>

            <section id="masonry" class="relative page-section">
                <div class="wrapper">
                    <div class="business-section-header">
                        <?php if( !empty( $options['featured_title'] ) ): ?>
                            <h2 class="business-section-title"><?php echo esc_html( $options['featured_title'] ); ?></h2>
                        <?php endif;

                        if( !empty( $options['featured_description'] ) ): ?>
                        <p class="business-section-subtitle"><?php echo esc_html( $options['featured_description'] ); ?></p>
                    <?php endif; ?>
                </div><!-- .business-section-header -->
            </div>

            <div class="grid clear">

            <?php foreach( $content_details as $content_detail ) : ?>
                <article class="grid-item">
                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ); ?>');">
                        <div class="entry-container">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                            </header>
                        </div><!-- .entry-container -->
                    </div><!-- .featured-image -->
                </article>

            <?php endforeach; ?>
            </div><!-- .grid --> 
        </section>

        <?php endif; ?>

        <?php if ( $options['home_layout'] == 'eight-design' ): ?>

            <section id="help-us" class="page-section">
                    <div class="wrapper">
                        <div class="business-section-header">
                        <?php if( !empty( $options['featured_title'] ) ): ?>
                            <h2 class="business-section-title"><?php echo esc_html( $options['featured_title'] ); ?></h2>
                        <?php endif;

                        if( !empty( $options['featured_description'] ) ): ?>
                            <p class="business-section-subtitle"><?php echo esc_html( $options['featured_description'] ); ?></p>
                        <?php endif; ?>
                        </div><!-- .business-section-header -->

                        <div class="section-content <?php echo esc_attr($options['featured_column_layout']); ?>">
                            
                            <?php foreach( $content_details as $content_detail ) : ?>

                            <article class="hentry">
                                <div class="help-wrapper">
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ); ?>');">
                                    <a href="<?php echo esc_url( $content_detail['url'] ); ?>" class="post-thumbnail-link"></a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-container">
                                        <div class="entry-meta">
                                            <span class="cat-links">
                                                <ul class="post-categories">
                                                    <?php the_category( '', '', $content_detail['id']); ?>
                                                </ul>
                                            </span>
                                        </div><!-- .entry-meta -->

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                                        </div>

                                        <?php if( !empty( $options['featured_button'] ) ): ?>
                                        <div class="read-more">
                                            <a href="<?php echo esc_url( $content_detail['url'] ); ?>" class="btn"><?php echo esc_html( $options['featured_button'] ); ?></a>
                                        </div>
                                    <?php endif; ?>

                                    </div><!-- .entry-container -->
                                </div><!-- .help-wrapper -->
                            </article>

                            <?php endforeach; ?>

                            
                        </div><!-- .section-content -->
                    </div><!-- .wrapper -->
                </section>

        <?php endif; ?>

    <?php }
endif;