<?php 
/**
 * Guide section
 *
 * This is the template for the content of guide section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_guide_section' ) ) :
    /**
    * Add guide section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_guide_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if guide is enabled
        $enable_guide = apply_filters( 'travel_insight_pro_section_status', true, 'guide_enable' );

        if ( true !== $enable_guide ) {
            return false;
        }

        // Get guide section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_guide_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render guide section now.
        travel_insight_pro_render_guide_section( $section_details );
    }
endif;



if ( ! function_exists( 'travel_insight_pro_get_guide_section_details' ) ) :
    /**
    * guide section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input guide section details.
    */
    function travel_insight_pro_get_guide_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // guide type
        $guide_content_type  = $options['guide_content_type'];

        $content = array();
        switch ( $guide_content_type ) {
            case 'demo':
                $title = array(
                    1 => esc_html__( 'Best time to go', 'travel-insight-pro' ),
                    2 => esc_html__( 'Visas', 'travel-insight-pro' ),
                    3 => esc_html__( 'Money and Costs', 'travel-insight-pro' ),
                    4 => esc_html__( 'Weather', 'travel-insight-pro' ),
                    5 => esc_html__( 'Getting there', 'travel-insight-pro' ),
                    6 => esc_html__( 'Health & Safety', 'travel-insight-pro' ),
                    );
                $icon = array(
                    1 => 'calendar',
                    2 => 'passport',
                    3 => 'wallet-filled-money-tool',
                    4 => 'sun',
                    5 => 'aeroplane',
                    6 => 'pills',
                    );
                for ( $i = 1; $i <= 6; $i++ ) :
                    $content[$i]['title']   = $title[$i];
                    $content[$i]['icon']    = $icon[$i];
                    $content[$i]['url']     = '#';
                    $content[$i]['excerpt'] = esc_html__( 'Proin turpis lorem, faucibus eu augue sed, pharetra porttitor...', 'travel-insight-pro' );
                endfor;
            break;     

            case 'custom':
                for ( $i = 1; $i <= $options['no_of_guide']; $i++ ) :
                    $content[$i]['title']   = ! empty( $options['guide_content_custom_title_' . $i] ) ? $options['guide_content_custom_title_' . $i] : $options['guide_content_custom_title'];
                    $content[$i]['icon']    = ! empty( $options['guide_custom_icon_' . $i] ) ? $options['guide_custom_icon_' . $i] : $options['guide_custom_icon'];
                    $content[$i]['url']     = ! empty( $options['guide_content_custom_link_' . $i] ) ? $options['guide_content_custom_link_' . $i] : $options['guide_content_custom_link'];
                    $content[$i]['excerpt'] = ! empty( $options['guide_content_custom_description_' . $i] ) ? $options['guide_content_custom_description_' . $i] : $options['guide_content_custom_description'];
                endfor;
            break;    

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $options['no_of_guide']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'guide_content_page_'.$i ] ) ) {
                        $id = $options[ 'guide_content_page_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $options['no_of_guide'] ),
                );
            break;

            case 'category':
                $cat_id = '';
                if ( ! empty( $options['guide_content_category'] ) ) {
                    $cat_id = $options['guide_content_category'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'no_found_rows'  => true,
                    'cat'            => $cat_id,
                    'post_type'      => 'post',
                    'posts_per_page'  => absint( $options['no_of_guide'] ),
                );
            break;

            case 'post':
                $ids = array();
                
                if ( ! empty( $options['guide_content_post'] ) )
                    $ids = ( array ) $options['guide_content_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;
        }

        if ( ! in_array( $guide_content_type, array( 'demo', 'custom' ) ) ) {
            $posts = get_posts( $args );
            if ( ! empty( $posts ) ) :
                $i = 1;
                foreach ( $posts as $post ) :
                    $post_id = $post->ID;
                    $icon = get_post_meta( $post_id, 'travel-insight-pro-post-icon', true );
                    $content[$i]['title']       = get_the_title( $post_id );
                    $content[$i]['icon']        = ! empty( $icon ) ? $icon : 'drop';
                    $content[$i]['url']         = get_the_permalink( $post_id );
                    $content[$i]['excerpt']     = travel_insight_pro_trim_content( 8, $post );
                    $i++;
                endforeach;
            endif;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// guide section content details.
add_filter( 'travel_insight_pro_filter_guide_section_details', 'travel_insight_pro_get_guide_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_guide_section' ) ) :
    /**
    * Start guide section
    *
    * @return string guide content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_guide_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();
        $title = ! empty( $options['guide_title'] ) ? $options['guide_title'] : '';  
        $sub_title = ! empty( $options['guide_sub_title'] ) ? $options['guide_sub_title'] : ''; 
        $guide_content_type  = $options['guide_content_type']; 

        $category_link  = '';
        $cat_name       = '';
        if ( $guide_content_type == 'category' ) {
            $category_link  = get_category_link( $options['guide_content_category'] );
            $cat_name       = get_the_category_by_ID( $options['guide_content_category'] );
        } elseif ( $guide_content_type == 'demo' ) {
            $category_link  = '#';
            $cat_name       = esc_html__( 'Guides', 'travel-insight-pro' );
        }

        if ( empty( $content_details ) ) {
            return;
        }

        ?>
        <section id="survival" class="page-section col-3">
            <div class="wrapper">
                <?php if ( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
                    <header class="entry-header text-center">
                        <?php if ( ! empty( $title ) ) : ?>
                            <h2 class="entry-title"><?php echo esc_html( $title ); ?></h2>
                        <?php endif; 
                        if ( ! empty( $sub_title ) ) : ?>
                            <h3 class="sub-title"><?php echo esc_html( $sub_title ); ?></h3>
                        <?php endif; ?>
                    </header><!-- .entry-header -->
                <?php endif; ?>

                <div class="entry-content">
                    <?php foreach ( $content_details as $content_detail ) : ?>
                        <div class="column-wrapper">
                            <div class="survival-guide">
                                <div class="icon-wrapper">
                                    <a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo travel_insight_pro_get_svg( array( 'icon' => esc_attr( $content_detail['icon'] ) ) ); ?></a>
                                </div><!-- .icon-wrapper -->
                                <div class="survival-text">
                                    <h4><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h4>
                                    <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                                </div><!-- .survival-text -->
                            </div><!-- .survival-guide -->
                        </div><!-- .column-wrapper -->
                    <?php endforeach; ?>

                    <?php if ( ! empty( $category_link ) ) : ?>
                        <div class="text-center clear">
                            <a href="<?php echo esc_url( $category_link ); ?>" class="more-link"><?php printf( esc_html__( 'See More %s', 'travel-insight-pro' ), $cat_name ); ?><?php echo travel_insight_pro_get_svg( array( 'icon' => 'angle-arrow-pointing-to-right') ); ?></a>
                        </div><!-- .link-more -->
                    <?php endif; ?>
                </div><!-- .entry-content -->
            </div><!-- .wrapper -->
        </section><!-- #survival -->
    <?php }
endif;