<?php 
/**
 * Blog section
 *
 * This is the template for the content of latest_post section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_latest_post_section' ) ) :
    /**
    * Add latest_post section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_latest_post_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if latest_post is enabled
        $enable_latest_post = apply_filters( 'travel_insight_pro_section_status', true, 'latest_post_enable' );

        if ( true !== $enable_latest_post ) {
            return false;
        }

        // Get latest_post section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_latest_post_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render latest_post section now.
        travel_insight_pro_render_latest_post_section( $section_details );
       
    }
endif;


if ( ! function_exists( 'travel_insight_pro_get_latest_post_section_details' ) ) :
    /**
    * latest_post section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input latest_post section details.
    */
    function travel_insight_pro_get_latest_post_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // latest_post type
        $latest_post_content_type  = $options['latest_post_content_type'];

        $content = array();
        switch ( $latest_post_content_type ) {

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $options['no_of_latest_post']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'latest_post_content_page_'.$i ] ) ) {
                        $id = $options[ 'latest_post_content_page_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $options['no_of_latest_post'] ),
                );
            break;

            case 'category':
                $cat_id = '';
                if ( ! empty( $options['latest_post_content_category'] ) ) {
                    $cat_id = $options['latest_post_content_category'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'no_found_rows'  => true,
                    'cat'            => $cat_id,
                    'post_type'      => 'post',
                    'posts_per_page'  => absint( $options['no_of_latest_post'] ),
                );
            break;

            case 'post':
                $ids = array();
                
                if ( ! empty( $options['latest_post_content_post'] ) )
                    $ids = ( array ) $options['latest_post_content_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;
        }

        $posts = get_posts( $args );
        if ( ! empty( $posts ) ) :
            $i = 1;
            foreach ( $posts as $post ) :
                $post_id = $post->ID;
                $img_array = null;
                if ( has_post_thumbnail( $post_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'post-thumbnail' );
                } else {
                    $img_array[0] =  get_template_directory_uri().'/assets/uploads/no-featured-image-500x500.jpg';
                }

                if ( isset( $img_array ) ) {
                    $content[$i]['img_array'] = $img_array;
                }

                $content[$i]['title']       = get_the_title( $post_id );
                $content[$i]['id']          =  $post_id ;
                $content[$i]['url']         = get_the_permalink( $post_id );
                $content[$i]['excerpt']     = travel_insight_pro_trim_content( 25, get_post( $post_id ) );
                $i++;
            endforeach;
        endif;

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// latest_post section content details.
add_filter( 'travel_insight_pro_filter_latest_post_section_details', 'travel_insight_pro_get_latest_post_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_latest_post_section' ) ) :
    /**
    * Start latest_post section
    *
    * @return string latest_post content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_latest_post_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();


        if ( empty( $content_details ) ) {
            return;
        }

        $i = 1;
        ?>

        <?php if ( $options['home_layout'] == 'second-design' || $options['home_layout'] == 'third-design' || $options['home_layout'] == 'seven-design' || $options['home_layout'] == 'eight-design' ): ?>

            <section id="business-latest-posts" class="relative page-section no-padding-bottom">
                <div class="wrapper">
                    <div class="business-section-header">
                        <h2 class="business-section-title"><?php echo esc_html($options['latest_post_title']); ?></h2>
                        <p class="business-section-subtitle"><?php echo esc_html($options['latest_post_sub_title']); ?>/p>
                        </div><!-- .business-section-header -->

                        <div class="business-section-content clear col-3">
                            <?php foreach( $content_details as $content_detail ) : ?>

                                <article class="has-post-thumbnail">
                                    <div class="business-post-item">
                                        <div class="featured-image">
                                            <a href="<?php echo esc_url( $content_detail['url'] ); ?>"><img src="<?php echo esc_url( $content_detail['img_array'][0] ); ?>" alt="business-post-01"></a>
                                        </div><!-- .featured-image -->

                                        <div class="entry-container">
                                            <header class="entry-header">
                                                <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                            </header>

                                            <div class="entry-content">
                                                <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                                            </div><!-- .entry-content -->

                                            <div class="entry-meta clear">
                                                <?php travel_insight_pro_posted_on( $content_detail['id'] ) ; ?>

                                                <span class="more-link"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html($options['latest_post_read_more_btn_label']); ?></a></span>

                                            </div><!-- .entry-meta -->
                                        </div><!-- .entry-container -->
                                    </div><!-- .business-post-item -->
                                </article>
                                <?php $i++; endforeach; ?>

                            </div><!-- .business-section-content -->
                        </div><!-- .wrapper -->
                    </section><!-- #business-latest-posts -->
                <?php endif; ?>


                <?php if ( $options['home_layout'] == 'fourth-design' ): ?>

                    <section id="business-latest-posts" class="relative page-section no-padding-bottom">
                        <div class="wrapper">
                            <?php if( !empty( $options['latest_post_title'] ) ): ?>
                                <div class="section-header">
                                    <h2 class="section-title"><?php echo esc_html($options['latest_post_title']); ?></h2>
                                </div>
                            <?php endif; ?>
                            <div class="business-section-content clear col-3">

                                <?php foreach( $content_details as $content_detail ) : ?>

                                    <article class="has-post-thumbnail">
                                        <div class="business-post-item">
                                            <div class="featured-image">
                                                <a href="<?php echo esc_url( $content_detail['url'] ); ?>"><img src="<?php echo esc_url( $content_detail['img_array'][0] ); ?>" alt="<?php echo esc_html( $content_detail['title'] ); ?>"></a>
                                            </div><!-- .featured-image -->

                                            <div class="entry-container">
                                                <header class="entry-header">
                                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                                </header>

                                                <div class="entry-content">
                                                    <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                                                </div><!-- .entry-content -->

                                                <div class="entry-meta clear">
                                                    <?php travel_insight_pro_posted_on( $content_detail['id'] ) ; ?>

                                                    <span class="cat-links">
                                                        <?php the_category( '', '', $content_detail['id']); ?>
                                                    </span><!-- .cat-links -->

                                                </div><!-- .entry-meta -->
                                            </div><!-- .entry-container -->
                                        </div><!-- .business-post-item -->
                                    </article>
                                    <?php $i++; endforeach; ?>

                                </div><!-- .business-section-content -->
                            </div><!-- .wrapper -->
                        </section><!-- #business-latest-posts -->
                    <?php endif; ?>

                    <?php if ( $options['home_layout'] == 'fifth-design' || $options['home_layout'] == 'sixth-design' ): ?>

                        <section id="business-latest-posts" class="relative page-section">
                            <div class="wrapper">
                                <?php if( !empty( $options['latest_post_title'] ) ): ?>
                                    <div class="section-header">
                                        <h2 class="section-title"><?php echo esc_html($options['latest_post_title']); ?></h2>
                                    </div><!-- .section-header -->
                                <?php endif; ?>

                                <div class="business-section-content clear col-3">
                                    
                                    <?php foreach( $content_details as $content_detail ) : ?>
                                        
                                        <article class="has-post-thumbnail">
                                            <div class="business-post-item">
                                                <div class="featured-image">
                                                    <a href="<?php echo esc_url( $content_detail['url'] ); ?>"><img src="<?php echo esc_url( $content_detail['img_array'][0] ); ?>" alt="<?php echo esc_html( $content_detail['title'] ); ?>"></a>
                                                </div><!-- .featured-image -->

                                                <div class="entry-container">
                                                    <header class="entry-header">
                                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                                    </header>

                                                    <div class="entry-content">
                                                        <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                                                    </div><!-- .entry-content -->

                                                    <div class="entry-meta">
                                                        <span class="posted-on">
                                                            <?php travel_insight_pro_posted_on( $content_detail['id'] ) ; ?>
                                                        </span><!-- .posted-on -->

                                                        <span class="cat-links">
                                                            <?php the_category( '', '', $content_detail['id']); ?>
                                                        </span><!-- .cat-links -->
                                                    </div><!-- .entry-meta -->
                                                </div><!-- .entry-container -->
                                            </div><!-- .business-post-item -->
                                        </article>
                                        
                                    <?php endforeach; ?>

                                </div><!-- .business-section-content -->
                            </div><!-- .wrapper -->
                        </section>

                    <?php endif; ?>
    <?php }
endif;

