<?php 
/**
 * Popular Destination section
 *
 * This is the template for the content of popular_destination section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_popular_destination_section' ) ) :
    /**
    * Add popular_destination section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_popular_destination_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if popular_destination is enabled
        $enable_popular_destination = apply_filters( 'travel_insight_pro_section_status', true, 'popular_destination_enable' );

        if ( true !== $enable_popular_destination ) {
            return false;
        }

        // Get popular_destination section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_popular_destination_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render popular_destination section now.
        travel_insight_pro_render_popular_destination_section( $section_details );
    }
endif;


if ( ! function_exists( 'travel_insight_pro_get_popular_destination_section_details' ) ) :
    /**
    * popular_destination section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input popular_destination section details.
    */
    function travel_insight_pro_get_popular_destination_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // popular_destination type
        $popular_destination_content_type  = $options['popular_destination_content_type'];
        $title = array(
            1 => esc_html__( 'Eiffel Tower', 'travel-insight-pro' ),
            2 => esc_html__( 'Times Square', 'travel-insight-pro' ),
            3 => esc_html__( 'Lake Geneva', 'travel-insight-pro' ),
            4 => esc_html__( 'Canal Grande', 'travel-insight-pro' ),
            5 => esc_html__( 'Patan Durbar Square', 'travel-insight-pro' ),
            );
        $sub_title = array(
            1 => esc_html__( 'Paris, France', 'travel-insight-pro' ),
            2 => esc_html__( 'New York, USA', 'travel-insight-pro' ),
            3 => esc_html__( 'Geneva, Switzerland', 'travel-insight-pro' ),
            4 => esc_html__( 'Venice, Italy', 'travel-insight-pro' ),
            5 => esc_html__( 'Lalitpur, Nepal', 'travel-insight-pro' ),
            );

        $content = array();
        if ( in_array( $popular_destination_content_type, array( 'trips', 'destination', 'package', 'package-category' ) ) && ! class_exists( 'TP_Travel_Package' ) && class_exists( 'WP_Travel' ) ) {
            $popular_destination_content_type = 'trips';
        }
        switch ( $popular_destination_content_type ) {
            case 'demo':
                for ( $i = 1; $i <= 5; $i++ ) :
                    $content[$i]['title']   = $title[$i];
                    $content[$i]['sub_title'] = $sub_title[$i];
                    $content[$i]['url']     = '#';
                    $content[$i]['img_array'][0] = get_template_directory_uri() . '/assets/uploads/destination-0' . $i . '.jpg';
                endfor;
            break;      

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $options['no_of_popular_destination']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'popular_destination_content_page_'.$i ] ) ) {
                        $id = $options[ 'popular_destination_content_page_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $options['no_of_popular_destination'] ),
                );
            break;

            case 'category':
                $cat_id = '';
                if ( ! empty( $options['popular_destination_content_category'] ) ) {
                    $cat_id = $options['popular_destination_content_category'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'no_found_rows'  => true,
                    'cat'            => $cat_id,
                    'post_type'      => 'post',
                    'posts_per_page'  => absint( $options['no_of_popular_destination'] ),
                );
            break;

            case 'post':
                $ids = array();
                
                if ( ! empty( $options['popular_destination_content_post'] ) )
                    $ids = ( array ) $options['popular_destination_content_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;

            case 'destination':
                $ids = array();
                
                if ( ! empty( $options['popular_destination_content_destination'] ) )
                    $ids = ( array ) $options['popular_destination_content_destination'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'tp-destination',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;

            case 'package':
                $ids = array();
                
                if ( ! empty( $options['popular_destination_content_package'] ) )
                    $ids = ( array ) $options['popular_destination_content_package'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'tp-package',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;

            case 'package-category':
                $cat_id = '';
                if ( ! empty( $options['popular_destination_content_package_category'] ) ) {
                    $cat_id = $options['popular_destination_content_package_category'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'post_type'         => 'tp-package',
                    'posts_per_page'    => absint( $options['no_of_popular_destination'] ),
                    'tax_query'         => array(
                        array(
                            'taxonomy'  => 'tp-package-category',
                            'field'     => 'id',
                            'terms'     => $cat_id
                        )
                    )
                );
            break;

            case 'trips':
                $ids = array();
                
                if ( ! empty( $options['popular_destination_content_trip'] ) )
                    $ids = ( array ) $options['popular_destination_content_trip'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'itineraries',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;

            case 'trip-types':
                $cat_id = '';
                if ( ! empty( $options['popular_destination_content_trip_types'] ) ) {
                    $cat_id = $options['popular_destination_content_trip_types'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'post_type'         => 'itineraries',
                    'posts_per_page'    => absint( $options['no_of_popular_destination'] ),
                    'tax_query'         => array(
                        array(
                            'taxonomy'  => 'itinerary_types',
                            'field'     => 'id',
                            'terms'     => $cat_id
                        )
                    )
                );
            break;
   
        }

        if ( ! in_array( $popular_destination_content_type, array( 'demo', 'custom' ) ) ) {
            $posts = get_posts( $args );
            if ( ! empty( $posts ) ) :
                $i = 1;
                foreach ( $posts as $post ) :
                    $post_id = $post->ID;
                    $img_array = null;
                    if ( has_post_thumbnail( $post_id ) ) {
                        $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
                    } else {
                        $img_array[0] =  get_template_directory_uri().'/assets/uploads/no-featured-image-500x500.jpg';
                    }

                    if ( isset( $img_array ) ) {
                        $content[$i]['img_array'] = $img_array;
                    }

                    $sub_title = '';
                    if ( function_exists( 'get_the_subtitle' ) ) {
                        $sub_title = get_the_subtitle( $post_id );
                        $sub_title = ! empty( $sub_title ) ? $sub_title : '';
                    }

                    $content[$i]['title']       = get_the_title( $post_id );
                    $content[$i]['sub_title']   = $sub_title;
                    $content[$i]['url']         = get_the_permalink( $post_id );
                    $i++;
                endforeach;
            endif;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// popular_destination section content details.
add_filter( 'travel_insight_pro_filter_popular_destination_section_details', 'travel_insight_pro_get_popular_destination_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_popular_destination_section' ) ) :
    /**
    * Start popular_destination section
    *
    * @return string popular_destination content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_popular_destination_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();
        $popular_destination_content_type  = $options['popular_destination_content_type'];
        $title = ! empty( $options['popular_destination_title'] ) ? $options['popular_destination_title'] : '';
        $sub_title = ! empty( $options['popular_destination_sub_title'] ) ? $options['popular_destination_sub_title'] : '';

        $category_link  = '';
        $cat_name       = '';
        if ( $popular_destination_content_type == 'category' ) {
            $category_link  = get_category_link( $options['popular_destination_content_category'] );
            $cat_name       = get_the_category_by_ID( $options['popular_destination_content_category'] );
        } elseif ( $popular_destination_content_type == 'package-category' ) {
            $category_link  = get_term_link( $options['popular_destination_content_package_category' ], 'tp-package-category' );
            $term           = get_term_by('id', $options['popular_destination_content_package_category' ] , 'tp-package-category' );
            $cat_name       = $term->name;
        } elseif ( $popular_destination_content_type == 'demo' ) {
            $category_link  = '#';
            $cat_name       = esc_html__( 'Destinations', 'travel-insight-pro' );
        }

        if ( empty( $content_details ) ) {
            return;
        }

        ?>
        <section id="popular-destinations" class="page-section text-center">
            <div class="wrapper">

                <?php if ( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
                    <header class="entry-header">
                        <?php if ( ! empty( $title ) ) : ?>
                            <h2 class="entry-title"><?php echo esc_html( $title ); ?></h2>
                        <?php endif; 
                        if ( ! empty( $sub_title ) ) : ?>
                            <h3 class="sub-title"><?php echo esc_html( $sub_title ); ?></h3>
                        <?php endif; ?>
                    </header><!-- .entry-header-->
                <?php endif; ?>

                <div class="entry-content col-3 gallery-popup">
                    <div class="popular-place clear">
                        <div class="grid <?php echo ( count( $content_details ) === 6 ) ? 'grid-6' : ''; ?> ">
                            <?php foreach( $content_details as $content_detail ) : ?>
                                <div class="grid-item" >
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ) ?>');">
                                    </div><!-- .featured-image -->

                                    <div class="popular-content">
                                        <a href="<?php echo esc_url( $content_detail['img_array'][0] ) ?>" class="popup"><?php echo travel_insight_pro_get_svg( array( 'icon' => 'zoom-in') ); ?></a>
                                        <?php if ( ! empty( $content_detail['sub_title'] ) ) : ?>
                                            <span><?php echo esc_html( $content_detail['sub_title'] ); ?></span>
                                        <?php endif; ?>
                                        <h4><a href="<?php echo esc_url( $content_detail['url'] ) ?>"><?php echo esc_html( $content_detail['title'] ) ?></a></h4>
                                    </div><!-- .popular-content -->
                                </div><!-- .featured-image -->
                            <?php endforeach; ?>
                        </div><!-- .grid -->
                    </div><!-- .popular-place -->

                    <?php if ( ! empty( $category_link ) ) : ?>
                        <div class="text-center">
                            <a href="<?php echo esc_url( $category_link ); ?>" class="more-link"><?php printf( '%s ' . esc_html( $cat_name ), esc_html__( 'See More', 'travel-insight-pro' ) ); ?><?php echo travel_insight_pro_get_svg( array( 'icon' => 'angle-arrow-pointing-to-right') ); ?></a>
                        </div>
                    <?php endif; ?>
                </div><!-- .entry-content-->
            </div><!-- .wrapper -->
        </section><!-- #destinations -->
    <?php }
endif;