<?php
/**
 * service section
 *
 * This is the template for the content of service section
 *
 * @package Theme Palace
 * @subpackage Travel Ultimate Pro
 * @since Travel Ultimate Pro 1.0.0
 */
if ( ! function_exists( 'travel_insight_pro_add_service_section' ) ) :
    /**
    * Add service section
    *
    *@since Travel Ultimate Pro 1.0.0
    */
    function travel_insight_pro_add_service_section() {
    	$options = travel_insight_pro_get_theme_options();
        // Check if service is enabled on frontpage
        $service_enable = apply_filters( 'travel_insight_pro_section_status', true, 'service_enable' );

        if ( true !== $service_enable ) {
            return false;
        }
        // Get service section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_service_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render service section now.
        travel_insight_pro_render_service_section( $section_details );
    }
endif;

if ( ! function_exists( 'travel_insight_pro_get_service_section_details' ) ) :
    /**
    * service section details.
    *
    * @since Travel Ultimate Pro 1.0.0
    * @param array $input service section details.
    */
    function travel_insight_pro_get_service_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // Content type.
        $service_content_type  = $options['service_content_type'];
        $no_of_service = ! empty( $options['no_of_service'] ) ? $options['no_of_service'] : 3;
        
        $content = array();
        switch ( $service_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $no_of_service; $i++ ) {
                    if ( ! empty( $options['service_content_page_' . $i] ) )
                        $page_ids[] = $options['service_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $no_of_service ),
                    'orderby'           => 'post__in',
                    );                    
            break;


            case 'post':
                $ids = array();
                
                if ( ! empty( $options['service_content_post'] ) )
                    $ids = ( array ) $options['service_content_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $no_of_service ),
                );                             
            break;

            case 'category':
                $cat_id = ! empty( $options['service_content_category'] ) ? $options['service_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $no_of_service ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = travel_insight_pro_trim_content( 10 );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : '';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// service section content details.
add_filter( 'travel_insight_pro_filter_service_section_details', 'travel_insight_pro_get_service_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_service_section' ) ) :
  /**
   * Start service section
   *
   * @return string service content
   * @since Travel Ultimate Pro 1.0.0
   *
   */
   function travel_insight_pro_render_service_section( $content_details = array() ) {
        $options = travel_insight_pro_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <?php if ( $options['home_layout'] == 'sixth-design' ): ?>
            <section id="our-services" class="relative page-section">
                <div class="wrapper">
                    <div class="col-3 clear">
                        <?php foreach ($content_details as $i=>$content) : ?>
                            <article>
                                <div class="service-item-wrapper">
                                    <div class="service-icon">
                                        <a href="<?php echo esc_url($content['url']); ?>">
                                            <i class="fa <?php echo ! empty( $options['service_content_icon_' . ($i+1) . ''] ) ? esc_attr( $options['service_content_icon_' . ($i+1) . ''] ) : 'fa-cogs' ; ?>"></i>
                                        </a>
                                    </div><!-- .service-icon -->

                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url($content['url']); ?>"><?php echo esc_html($content['title'])?></a></h2>
                                            <span><?php echo wp_kses_post($content['excerpt']); ?></span>
                                        </header>
                                    </div><!-- .entry-container -->
                                </div><!-- .service-item-wrapper -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .col-3 -->
                </div><!-- .wrapper -->
            </section>
        <?php endif; ?>

        <?php if ( $options['home_layout'] == 'seven-design' || $options['home_layout'] == 'eight-design' ): ?>

            <section id="survival" class="page-section col-3">
                <div class="wrapper">
                    <header class="entry-header text-center">
                    <?php if( !empty( $options['service_title'] ) ): ?>
                        <h2 class="entry-title"><?php echo esc_html( $options['service_title'] ); ?></h2>
                    <?php endif;

                    if( !empty( $options['service_description'] ) ): ?>
                        <h3 class="sub-title"><?php echo esc_html( $options['service_description'] ); ?></h3>
                    <?php endif; ?>
                    </header><!-- .entry-header -->

                    <div class="entry-content">

                    <?php foreach ($content_details as $i=>$content) : ?>
                        <div class="column-wrapper">
                            <div class="survival-guide">
                                <div class="icon-wrapper">
                                    <a href="<?php echo esc_url($content['url']); ?>"><i class="fa <?php echo ! empty( $options['service_content_icon_' . ($i+1) . ''] ) ? esc_attr( $options['service_content_icon_' . ($i+1) . ''] ) : 'fa-cogs' ; ?>"></i></a>
                                </div><!-- .icon-wrapper -->

                                <div class="survival-text">
                                    <h4><a href="<?php echo esc_url($content['url']); ?>"><?php echo esc_html($content['title'])?></a></h4>
                                    <p><?php echo wp_kses_post($content['excerpt']); ?></p>
                                </div><!-- .survival-text -->
                            </div><!-- .survival-guide -->
                        </div><!-- .column-wrapper -->

                        <?php endforeach; ?>

                        <?php if( !empty( $options['service_btn_url'] ) && !empty( $options['service_btn_title'] ) ): ?>
                        <div class="text-center">
                            <a href="<?php echo esc_url( $options['service_btn_url'] ); ?>" class="more-link"><?php echo esc_html( $options['service_btn_title'] ); ?><i class="fa fa-angle-right"></i></a>
                        </div><!-- .link-more -->
                    <?php endif; ?>
                    </div><!-- .entry-content -->
                </div><!-- .wrapper -->
            </section>

        <?php endif; ?>
    <?php }
endif;
