<?php
/**
 * Subscription section
 *
 * This is the template for the content of subscription section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0.0
 */
if ( ! function_exists( 'travel_insight_pro_add_subscription_section' ) ) :
    /**
    * Add subscription section
    *
    *@since Travel Insight Pro 1.0.0
    */
    function travel_insight_pro_add_subscription_section() {
    	$options = travel_insight_pro_get_theme_options();
        // Check if subscription is enabled on frontpage
        $subscription_enable = apply_filters( 'travel_insight_pro_section_status', true, 'subscription_section_enable' );

        if ( true !== $subscription_enable ) {
            return false;
        }

        // Render subscription section now.
        travel_insight_pro_render_subscription_section();
    }
endif;
//add_action( 'travel_insight_pro_content_end_action', 'travel_insight_pro_add_subscription_section', 5 );

if ( ! function_exists( 'travel_insight_pro_render_subscription_section' ) ) :
  /**
   * Start subscription section
   *
   * @return string subscription content
   * @since Travel Insight Pro 1.0.0
   *
   */
   function travel_insight_pro_render_subscription_section() {
        $options = travel_insight_pro_get_theme_options();
        
        if ( ! class_exists( 'Jetpack' ) ) {
            return;
        } elseif ( class_exists( 'Jetpack' ) ) {
            if ( ! Jetpack::is_module_active( 'subscriptions' ) )
                return;
        }
        ?>


            <section id="business-subscribe-us" class="relative page-section" style="background-image: url('<?php echo esc_url($options['subscription_background']); ?>');">
                <div class="overlay"></div>
                <div class="wrapper">
                    <div class="subscribe-form-wrapper">
                        <?php if ( ! empty( $options['subscription_subtitle'] ) ) : ?>
                            <p class="subtitle"><?php echo esc_html( $options['subscription_subtitle'] ); ?></p>
                        <?php endif; ?>
                        <?php  
                        $subscription_shortcode = '[jetpack_subscription_form title="'.$options['subscription_title'].'" subscribe_text="'.$options['subscription_description'].'" subscribe_button="' . esc_html__( 'Subscribe Now', 'travel-insight-pro' ) . '" show_subscribers_total="0"]';
                        echo do_shortcode( wp_kses_post( $subscription_shortcode ) ); 
                    ?>
                    </div><!-- .subscribe-form-wrapper -->
                </div><!-- .wrapper -->
            </section><!-- #sbusiness-ubscribe-us -->

    <?php }
endif;