<?php 
/**
 * Tours section
 *
 * This is the template for the content of tours section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_tours_section' ) ) :
    /**
    * Add tours section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_tours_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if tours is enabled
        $enable_tours = apply_filters( 'travel_insight_pro_section_status', true, 'tours_enable' );

        if ( true !== $enable_tours ) {
            return false;
        }

        // Get tours section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_tours_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render tours section now.
        travel_insight_pro_render_tours_section( $section_details );
    }
endif;



if ( ! function_exists( 'travel_insight_pro_get_tours_section_details' ) ) :
    /**
    * tours section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input tours section details.
    */
    function travel_insight_pro_get_tours_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // tours type
        $tours_content_type  = $options['tours_content_type'];
        if ( $tours_content_type == 'package-category' && ! class_exists( 'TP_Travel_Package' ) && class_exists( 'WP_Travel' ) ) {
            $tours_content_type = 'trip-types';
        }
        $content = array();
        switch ( $tours_content_type ) {
            case 'demo':
                $title = array(
                    1 => esc_html__( 'Wildlife', 'travel-insight-pro' ),
                    2 => esc_html__( 'Trekking', 'travel-insight-pro' ),
                    3 => esc_html__( 'Hiking', 'travel-insight-pro' ),
                    4 => esc_html__( 'Flights', 'travel-insight-pro' ),
                    5 => esc_html__( 'Cruises', 'travel-insight-pro' ),
                    6 => esc_html__( 'Safari', 'travel-insight-pro' ),
                    );
                $icon = array(
                    1 => 'deer',
                    2 => 'hiking-sticks',
                    3 => 'travel',
                    4 => 'balloon-flying',
                    5 => 'ship',
                    6 => 'forest',
                    );
                for ( $i = 1; $i <= 6; $i++ ) {
                    $content[$i]['title']   = $title[$i];
                    $content[$i]['icon']    = $icon[$i];
                    $content[$i]['url']     = '#';
                }
            break;     

            case 'custom':
                for ( $i = 1; $i <= $options['no_of_tours']; $i++ ) {
                    if ( 'icon' === $options['tours_custom_icon_image'] ) {
                        $content[$i]['icon']    = ! empty( $options['tours_icon_'. $i] ) ? $options['tours_icon_'. $i] : $options['tours_icon'];
                    } elseif ( 'image' === $options['tours_custom_icon_image'] ) {
                        $content[$i]['icon']    = ! empty( $options['tours_icon_image_'. $i] ) ? $options['tours_icon_image_'. $i] : '';
                    }
                    $content[$i]['title']   = ! empty( $options['tours_label_'. $i] ) ? $options['tours_label_'. $i] : $options['tours_label'];
                    $content[$i]['url']     = ! empty( $options['tours_link_'. $i] ) ? $options['tours_link_'. $i] : $options['tours_link'];
                }
            break; 

            case 'category':
                $cat_ids = ! empty( $options['tours_content_category'] ) ? $options['tours_content_category'] : array();

                // Bail if no valid pages are selected.
                if ( empty( $cat_ids ) ) {
                    return $input;
                } else {
                    $cat_ids = ( array ) $cat_ids;
                }

                $i = 1;
                foreach ( $cat_ids as $cat_id ) {
                    $cat_meta   = get_term_meta( $cat_id, 'custom_term_meta', true );
                    if ( ! isset( $cat_meta ) ) {
                        $cat_meta = get_option( "taxonomy_$cat_id" );
                        $cat_meta = ! isset( $cat_meta['custom_term_meta'] ) ? $cat_meta['custom_term_meta'] : '';
                    }
                    $content[$i]['title']   = get_the_category_by_ID( $cat_id );
                    $content[$i]['icon']    = ! empty( $cat_meta ) ? $cat_meta : 'travel';
                    $content[$i]['url']     = get_category_link( $cat_id );
                    $i++;
                }

            break;   

            case 'package-category':
                $cat_ids = ! empty( $options['tours_content_package_category'] ) ? $options['tours_content_package_category'] : array();

                // Bail if no valid pages are selected.
                if ( empty( $cat_ids ) ) {
                    return $input;
                } else {
                    $cat_ids = ( array ) $cat_ids;
                }

                $i = 1;
                foreach ( $cat_ids as $cat_id ) {
                    $term       = get_term_by( 'id', $cat_id, 'tp-package-category' );
                    $cat_meta   = get_term_meta( $cat_id, 'custom_term_meta', true );
                    if ( ! isset( $cat_meta ) ) {
                        $cat_meta = get_option( "taxonomy_$cat_id" );
                        $cat_meta = ! isset( $cat_meta['custom_term_meta'] ) ? $cat_meta['custom_term_meta'] : '';
                    }
                    $content[$i]['title']   = $term->name;
                    $content[$i]['icon']    = ! empty( $cat_meta ) ? $cat_meta : 'travel';
                    $content[$i]['url']     = get_term_link( $term, 'tp-package-category' );
                    $i++;
                }

            break;   

            case 'destination':
                $cat_ids = ! empty( $options['tours_content_destination'] ) ? $options['tours_content_destination'] : array();

                // Bail if no valid pages are selected.
                if ( empty( $cat_ids ) ) {
                    return $input;
                } else {
                    $cat_ids = ( array ) $cat_ids;
                }

                $i = 1;
                foreach ( $cat_ids as $cat_id ) {
                    $term       = get_term_by( 'id', $cat_id, 'travel_locations' );
                    $cat_meta   = get_term_meta( $cat_id, 'custom_term_meta', true );
                    if ( ! isset( $cat_meta ) ) {
                        $cat_meta = get_option( "taxonomy_$cat_id" );
                        $cat_meta = ! isset( $cat_meta['custom_term_meta'] ) ? $cat_meta['custom_term_meta'] : '';
                    }
                    $content[$i]['title']   = $term->name;
                    $content[$i]['icon']    = ! empty( $cat_meta ) ? $cat_meta : 'travel';
                    $content[$i]['url']     = get_term_link( $term, 'travel_locations' );
                    $i++;
                }

            break;

            case 'activity':
                $cat_ids = ! empty( $options['tours_content_activity'] ) ? $options['tours_content_activity'] : array();

                // Bail if no valid pages are selected.
                if ( empty( $cat_ids ) ) {
                    return $input;
                } else {
                    $cat_ids = ( array ) $cat_ids;
                }

                $i = 1;
                foreach ( $cat_ids as $cat_id ) {
                    $term       = get_term_by( 'id', $cat_id, 'activity' );
                    $cat_meta   = get_term_meta( $cat_id, 'custom_term_meta', true );
                    if ( ! isset( $cat_meta ) ) {
                        $cat_meta = get_option( "taxonomy_$cat_id" );
                        $cat_meta = ! isset( $cat_meta['custom_term_meta'] ) ? $cat_meta['custom_term_meta'] : '';
                    }
                    $content[$i]['title']   = $term->name;
                    $content[$i]['icon']    = ! empty( $cat_meta ) ? $cat_meta : 'travel';
                    $content[$i]['url']     = get_term_link( $term, 'activity' );
                    $i++;
                }

            break;

            case 'trip-types':
                $cat_ids = ! empty( $options['tours_content_trip_types'] ) ? $options['tours_content_trip_types'] : array();

                // Bail if no valid pages are selected.
                if ( empty( $cat_ids ) ) {
                    return $input;
                } else {
                    $cat_ids = ( array ) $cat_ids;
                }

                $i = 1;
                foreach ( $cat_ids as $cat_id ) {
                    $term       = get_term_by( 'id', $cat_id, 'itinerary_types' );
                    $cat_meta   = get_term_meta( $cat_id, 'custom_term_meta', true );
                    if ( ! isset( $cat_meta ) ) {
                        $cat_meta = get_option( "taxonomy_$cat_id" );
                        $cat_meta = ! isset( $cat_meta['custom_term_meta'] ) ? $cat_meta['custom_term_meta'] : '';
                    }
                    $content[$i]['title']   = $term->name;
                    $content[$i]['icon']    = ! empty( $cat_meta ) ? $cat_meta : 'travel';
                    $content[$i]['url']     = get_term_link( $term, 'itinerary_types' );
                    $i++;
                }

            break;

        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// tours section content details.
add_filter( 'travel_insight_pro_filter_tours_section_details', 'travel_insight_pro_get_tours_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_tours_section' ) ) :
    /**
    * Start tours section
    *
    * @return string tours content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_tours_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();
        $tours_content_type  = $options['tours_content_type'];
        $title  = ! empty( $options['tours_title'] ) ? $options['tours_title'] : '';
        $sub_title = ! empty( $options['tours_sub_title'] ) ? $options['tours_sub_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        }

        ?>
        <section id="tour">
            <div class="wrapper">
                <div class="tour-details">
                <?php if ( $options['home_layout'] !== 'third-design' ): ?>
                    <?php if ( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
                        <header class="entry-header">
                            <?php if ( ! empty( $title ) ) : ?>
                                <h2 class="entry-title"><?php echo esc_html( $title ); ?></h2>
                            <?php endif; 
                            if ( ! empty( $sub_title ) ) : ?>
                                <h3 class="sub-title"><?php echo esc_html( $sub_title ); ?></h3>
                            <?php endif; ?>
                        </header><!-- .entry-header-->
                    <?php endif; ?>

                <?php endif; ?>

                    <div class="tour-slider" data-slick='{"slidesToShow": 5, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":true, "autoplay": true, "fade": false, "draggable":false }'>
                        <?php foreach( $content_details as $content_detail ) : ?>
                            <div class="slider-item">
                                <a href="<?php echo esc_url( $content_detail['url'] ) ?>">
                                    <?php 
                                    if ( 'custom' == $tours_content_type ) :
                                        if ( 'icon' === $options['tours_custom_icon_image'] ) :
                                            if ( ! empty( $content_detail['icon'] ) ) :
                                                echo travel_insight_pro_get_svg( array( 'icon' => esc_attr( $content_detail['icon'] ) ) );
                                            endif;
                                        elseif ( 'image' === $options['tours_custom_icon_image'] ) :
                                            if ( ! empty( $content_detail['icon'] ) ) :
                                                echo '<img src="' . esc_url( $content_detail['icon'] ) . '" alt="' . esc_attr( $content_detail['title'] ) . '">';
                                            endif;
                                        endif;
                                    else :
                                        if ( ! empty( $content_detail['icon'] ) ) {
                                            echo travel_insight_pro_get_svg( array( 'icon' => esc_attr( $content_detail['icon'] ) ) );
                                        }
                                    endif;
                                    ?>
                                    <span><?php echo esc_html( $content_detail['title'] ); ?></span>
                                </a>
                            </div><!-- .slider-item -->
                        <?php endforeach; ?>
                    </div><!-- .tour-slider -->
                </div><!-- .tour-details -->
            </div><!-- .wrapper -->
        </section><!-- #tour -->
    <?php }
endif;