<?php 
/**
 * Two Column section
 *
 * This is the template for the content of two_column section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_two_column_section' ) ) :
    /**
    * Add two_column section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_two_column_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if two_column is enabled
        $enable_two_column = apply_filters( 'travel_insight_pro_section_status', true, 'two_column_enable' );

        if ( true !== $enable_two_column ) {
            return false;
        }

        // Get two_column section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_two_column_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render two_column section now.
        travel_insight_pro_render_two_column_section( $section_details );
    }
endif;


if ( ! function_exists( 'travel_insight_pro_get_two_column_section_details' ) ) :
    /**
    * two_column section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input two_column section details.
    */
    function travel_insight_pro_get_two_column_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // two_column type
        $two_column_content_type  = $options['two_column_content_type'];

        $content = array();
        switch ( $two_column_content_type ) {

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $options['no_of_two_column']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'two_column_content_page_'.$i ] ) ) {
                        $id = $options[ 'two_column_content_page_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $options['no_of_two_column'] ),
                );
            break;

            case 'category':
                $cat_id = '';
                if ( ! empty( $options['two_column_content_category'] ) ) {
                    $cat_id = $options['two_column_content_category'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'no_found_rows'  => true,
                    'cat'            => $cat_id,
                    'post_type'      => 'post',
                    'posts_per_page'  => absint( $options['no_of_two_column'] ),
                );
            break;

            case 'post':
                $ids = array();
                
                if ( ! empty( $options['two_column_content_post'] ) )
                    $ids = ( array ) $options['two_column_content_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;
        }

        $posts = get_posts( $args );
        if ( ! empty( $posts ) ) :
            $i = 1;
            foreach ( $posts as $post ) :
                $post_id = $post->ID;
                $img_array = null;
                if ( has_post_thumbnail( $post_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
                } else {
                    $img_array[0] =  get_template_directory_uri().'/assets/uploads/no-featured-image-1920x1080.jpg';
                }

                if ( isset( $img_array ) ) {
                    $content[$i]['img_array'] = $img_array;
                }

                $content[$i]['title']       = get_the_title( $post_id );
                $content[$i]['id']          =  $post_id ;
                $content[$i]['url']         = get_the_permalink( $post_id );
                $content[$i]['excerpt']     = travel_insight_pro_trim_content( 25, get_post( $post_id ) );
                $i++;
            endforeach;
        endif;

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// two_column section content details.
add_filter( 'travel_insight_pro_filter_two_column_section_details', 'travel_insight_pro_get_two_column_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_two_column_section' ) ) :
    /**
    * Start two_column section
    *
    * @return string two_column content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_two_column_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();


        if ( empty( $content_details ) ) {
            return;
        }
        $i = 1;
        ?>

<?php if ( $options['home_layout'] == 'fourth-design' ): ?>
<div id="main-post-wrapper" class="wrapper margin-top">

    <div id="primary" class="content-area">
        <main id="main" class="site-main" role="main">
            <section id="recent-posts">
                <div class="wrapper">
                <?php if( !empty( $options['two_column_title'] ) ): ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['two_column_title'] ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif; ?>

                    <div class="col-2 clear">
                    <?php foreach( $content_details as $content_detail ) : ?>

                        <article>
                            <div class="featured-post-item">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ); ?>');">
                                    <a href="<?php echo esc_url( $content_detail['url'] ); ?>" class="post-thumbnail-link"></a>
                                </div>

                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <?php travel_insight_pro_posted_on( $content_detail['id'] ) ; ?>
                                        <span class="cat-links">
                                           <?php the_category( '', '', $content_detail['id']); ?>
                                        </span><!-- .cat-links -->
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                    </header>

                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                                    </div>
                                </div>
                            </div><!-- .featured-post-item -->
                        </article>
                        <?php $i++; endforeach; ?>


                    </div><!-- .col-2 -->
                </div><!-- .container -->
            </section><!-- #recent-posts -->
        </main><!-- #main -->
    </div><!-- #primary -->

    <aside id="secondary" class="widget-area right-sidebar" role="complementary">
        <?php dynamic_sidebar( 'two-column-sidebar' ); ?>
    </aside><!-- #secondary -->
</div><!-- #main-post-wrapper -->

<?php if(isset($options['two_column_ads_image']) && !empty($options['two_column_ads_url']) ) :?>
    <section id="advertisement-section">
        <div class="wrapper">
            <a href="<?php echo esc_url($options['two_column_ads_url']); ?>"><img src="<?php echo esc_url($options['two_column_ads_image']);?>"></a>
        </div><!-- .container -->
    </section><!-- #advertisement-section -->
<?php endif; ?>

<?php endif; ?>

<?php if ( $options['home_layout'] == 'fifth-design' ): ?>

    <section id="blog-popular-posts" class="relative page-section">
            <div class="wrapper">

            <?php if( !empty( $options['two_column_title'] ) ): ?>
                <div class="section-header">
                    <h2 class="section-title"><?php echo esc_html( $options['two_column_title'] ); ?></h2>
                </div><!-- .section-header -->
            <?php endif; ?>

                <div class="col-2 clear">
                    
                    <?php foreach( $content_details as $content_detail ) : ?>

                    <article>
                        <div class="popular-post-item">
                            <div class="blog-featured-image">
                                <a href="<?php echo esc_url( $content_detail['url'] ); ?>"><img src="<?php echo esc_url( $content_detail['img_array'][0] ); ?>"></a>
                            </div><!-- .blog-featured-image -->

                            <div class="entry-container">
                                <span class="cat-links">
                                    <?php the_category( '', '', $content_detail['id']); ?>
                                </span><!-- .cat-links -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                </header>

                                <span class="posted-on">
                                    <?php travel_insight_pro_posted_on( $content_detail['id'] ) ; ?>
                                </span><!-- .posted-on -->

                                <div class="entry-content">
                                    <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                                </div>

                                <?php if( !empty( $options['two_column_button'] ) ): ?>
                                <div class="read-more">
                                    <a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $options['two_column_button'] ); ?></a>
                                </div><!-- .read-more -->
                            <?php endif; ?>
                            </div><!-- .entry-container -->
                        </div><!-- .popular-post-item -->
                    </article>

                <?php endforeach; ?>

                </div><!-- .blog-section-content -->
            </div><!-- .wrapper -->
        </section>

<?php endif; ?>

    <?php }
endif;