<?php 
/**
 * Video section
 *
 * This is the template for the content of video section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_video_section' ) ) :
    /**
    * Add video section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_video_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if video is enabled
        $enable_video = apply_filters( 'travel_insight_pro_section_status', true, 'video_enable' );

        if ( true !== $enable_video ) {
            return false;
        }

        // Get video section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_video_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render video section now.
        travel_insight_pro_render_video_section( $section_details );
    }
endif;



if ( ! function_exists( 'travel_insight_pro_get_video_section_details' ) ) :
    /**
    * video section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input video section details.
    */
    function travel_insight_pro_get_video_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // video type
        $video_content_type  = $options['video_content_type'];

        $content = array();
        switch ( $video_content_type ) {
            case 'demo':
                $content[0]['title']        = esc_html__( 'Discover the World of Business', 'travel-insight-pro' );
                $content[0]['excerpt']      = esc_html__( 'Business consulting excepteur sint occaecat cupidatat consulting non proident, sunt in culpa qui officia deserunt laborum Market.', 'travel-insight-pro' );
                $content[0]['img_array'][0] = get_template_directory_uri() . '/assets/uploads/business-video.jpg';
            break;     

            case 'custom':
                $content[0]['title']        = ! empty( $options['video_title'] ) ? $options['video_title'] : esc_html__( 'Discover the World of Business', 'travel-insight-pro' );
                $content[0]['excerpt']      = ! empty( $options['video_description'] ) ? $options['video_description'] : esc_html__( 'Business consulting excepteur sint occaecat cupidatat consulting non proident, sunt in culpa qui officia deserunt laborum Market.', 'travel-insight-pro' );
                $content[0]['img_array'][0] = ! empty( $options['video_background'] ) ? $options['video_background'] : '';
            break;    

            case 'page':
                $page_id = '';
                
                if ( ! empty( $options['video_content_page'] ) )
                    $page_id = absint( $options['video_content_page'] );

                // Bail if no valid pages are selected.
                if ( empty( $page_id ) ) {
                    return $input;
                }

                $img_array = null;
                if ( has_post_thumbnail( $page_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $page_id ), 'full' );
                } else {
                    $img_array[0] = get_template_directory_uri() . '/assets/uploads/no-featured-image-1920x1080.jpg';
                }

                if ( isset( $img_array ) ) {
                    $content[0]['img_array'] = $img_array;
                }

  
                $content[0]['title']        = get_the_title( $page_id );
                $content[0]['url']          = get_the_permalink( $page_id );
                $content[0]['excerpt']      = travel_insight_pro_trim_content( 25, get_post( $page_id ) );

            break;


            case 'post':
                if ( ! empty( $options['video_content_post'] ) )
                    $post_id = absint( $options['video_content_post'] );

                // Bail if no valid pages are selected.
                if ( empty( $post_id ) ) {
                    return $input;
                }

                $img_array = null;
                if ( has_post_thumbnail( $post_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
                } else {
                    $img_array[0] = get_template_directory_uri() . '/assets/uploads/no-featured-image-1920x1080.jpg';
                }

                if ( isset( $img_array ) ) {
                    $content[0]['img_array'] = $img_array;
                }

                $content[0]['title']        = get_the_title( $post_id );
                $content[0]['url']          = get_the_permalink( $post_id );
                $content[0]['excerpt']      = travel_insight_pro_trim_content( 25, get_post( $post_id ) );
            break;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// video section content details.
add_filter( 'travel_insight_pro_filter_video_section_details', 'travel_insight_pro_get_video_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_video_section' ) ) :
    /**
    * Start video section
    *
    * @return string video content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_video_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }

        ?>
        <?php foreach ( $content_details as $content_detail ) : ?>
            <div id="business-video" class="page-section" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ); ?>');">
                <div class="wrapper">
                    <div class="business-section-header">
                        <h2 class="business-section-title"><?php echo esc_html( $content_detail['title'] ); ?></h2>
                        <p class="business-section-subtitle"><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                    </div><!-- .business-section-header -->

                    <?php if(!empty($options['video_link'])):?>
                    <div class="business-section-content">
                        <div class="video-button">
                            <a href="<?php echo esc_url($options['video_link']); ?>" class="popup-youtube">
                                <svg class="svg-inline--fa fa-play fa-w-14" viewBox="0 0 448 512"><path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"></path></svg>
                            </a>
                        </div><!-- .video-button -->
                    </div><!-- .section-content -->
                    <?php endif; ?>
                </div><!-- .wrapper -->
            </div>
        <?php endforeach; ?>
    <?php }
endif;