<?php
/**
 * Steps Slider Widget
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

if ( ! class_exists( 'Travel_Insight_Pro_Steps_Slider_Widget' ) ) :
	/**
	 * Steps Slider class.
	 *
	 * @since Travel Insight Pro 1.0
	 */
	class Travel_Insight_Pro_Steps_Slider_Widget extends WP_Widget {
		/**
		 * Sets up the widgets name etc
		 */
		public function __construct() {
			$widget_ops = array(
				'classname'   => 'widget_travel_steps',
				'description' => esc_html__( 'Enter posts id or Select category to use it as a slider', 'travel-insight-pro' ),
			);
			parent::__construct( 'tp-step-slider',esc_html__('TP : Steps Slider','travel-insight-pro'), $widget_ops );
		}

		/**
		 * Outputs the content of the widget
		 *
		 * @param array $args
		 * @param array $instance
		 */
		public function widget( $args, $instance ) {
			// outputs the content of the widget
			if ( ! isset( $args['widget_id'] ) ) {
				$args['widget_id'] = $this->id;
			}
	
			$title        = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
			$number       =  isset( $instance['number'] ) ? absint( $instance['number'] ) : 3;
			$post_type    =  isset( $instance['post_type'] ) ? $instance['post_type'] : 'posts';
			$custom_posts = array();
					

			switch ( $post_type ) {
				case 'posts':
					$posts_ids = array();

					for( $i=1; $i<=$number; $i++ ){
						if ( ! empty( $instance['post-id-'. $i] ) ) {
							$posts_ids[] = $instance['post-id-'. $i];
						}
					}

					$post_args = array(
						'post_type'      => 'post',
						'post__in'       => $posts_ids,
						'orderby'        => 'post__in',
						'posts_per_page' => absint( $number )
					);

					$custom_posts = get_posts( $post_args );
				break;

				case 'category':
					$category_id =  isset( $instance['category_id'] ) ? absint( $instance['category_id'] ) : '';
					if( empty( $category_id ) ) return;

					$post_args = array(
						'post_type'      => 'post',
                		'cat'   		 => $category_id,
						'posts_per_page' => absint( $number ),
                		'orderby'        => 'DESC',
					);

					$custom_posts = get_posts( $post_args );
				break;
				
				default:
				break;
			}

			if( empty( $custom_posts ) ) return;			

			echo $args['before_widget'];
				if ( ! empty( $title ) ) {
					echo $args['before_title'] . esc_html( $title ) . $args['after_title'];
				}
			?>
	            <?php if( !empty( $custom_posts ) ){ ?>
	               <div class="regular" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "speed": "800", "dots":true, "arrows": true, "infinite": true, "fade": true, "autoplay": true}'>
	                	<?php 
	                		$i = 1;
		                	foreach( $custom_posts as $custom_post ) :
			                	$post_id = $custom_post->ID; 

								$title   = get_the_title( $post_id );
								$excerpt = travel_insight_pro_trim_content( 15, $custom_post  );
								$url = get_the_permalink( $post_id );
		                    	?>

		                    	<div class="slider-item">
		                    	<?php if( !empty( $title )){
		                    		echo '<h3>'. esc_html( $title ) .'</h3>';
		                    	}
		                    	if( !empty( $excerpt ) ){
		                    		echo '<p>'. wp_kses_post( $excerpt ) .'<a href="'. esc_url( $url ) .'">'. esc_html__( 'More', 'travel-insight-pro' ) .'</a></p>';
		                    	} 
	                    ?>

			                <span class="steps"><?php printf( esc_html__( 'Step %d', 'travel-insight-pro' ), $i ); ?></span>
			            </div><!-- .slider-item -->

	                    <?php $i++; endforeach; ?>

	                </div><!-- .regular-->
				<?php
			echo $args['after_widget'];
			}
		}

		/**
		 * Outputs the options form on admin
		 *
		 * @param array $instance The widget options
		 */
		public function form( $instance ) {
			$title                 = isset( $instance['title'] ) ? $instance['title'] : '';
			$number                = isset( $instance['number'] ) ? absint( $instance['number'] ) : 3;
			$post_type             = isset( $instance['post_type'] ) ? $instance['post_type'] : 'posts';
			$category_id           = isset( $instance['category_id'] ) ? absint( $instance['category_id'] ) : '';
		   ?>

		    <p>
			   <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'travel-insight-pro' ); ?></label>
			   <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		    </p>

		    <p>
		   		<label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of posts:', 'travel-insight-pro' ); ?></label>
		   		<input class="tiny-text" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" step="1" min="1" max="6" value="<?php echo absint( $number ); ?>" size="3" />
		    </p>

		    <p>
		   		<label for="<?php echo esc_attr( $this->get_field_id( 'post_type' ) ); ?>"><?php esc_html_e( 'Select From:', 'travel-insight-pro' ); ?></label>
		   		<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'post_type' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'post_type' ) ); ?>">
		   			<option value='posts' <?php selected( 'posts', $post_type, true ); ?> ><?php esc_html_e('Posts', 'travel-insight-pro' ); ?></option>
		   			<option value='category' <?php selected( 'category', $post_type, true ); ?> ><?php esc_html_e('Category', 'travel-insight-pro' ); ?></option>
		   		</select>
		   		<strong><?php esc_html_e( 'Save to view changes', 'travel-insight-pro' ); ?></strong>
		    </p>
		   	<?php if( 'posts' == $post_type ) : ?>
			    <b><?php esc_html_e('Post Slider','travel-insight-pro' ); ?></b>
			    <?php for( $i=1; $i<=$number; $i++ ):
			    	$post_id = isset(  $instance['post-id-'. $i] ) ? $instance['post-id-'. $i] : null;
			     ?>
			    <p>
			   		<label for="<?php echo esc_attr( $this->get_field_id( 'post-id-'. $i ) ); ?>"><?php printf( esc_html__( 'Enter Post ID #%s:', 'travel-insight-pro' ), $i ); ?></label>
			   		<input class="wide-fat" id="<?php echo esc_attr( $this->get_field_id( 'post-id-'. $i ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'post-id-'. $i ) ); ?>" type="number" step="1" min="1"  value="<?php echo absint( $post_id ); ?>" size="5" />
				</p>
				<?php endfor; ?>
			<?php endif; 
			if( 'category' == $post_type ) :
				$category_object = get_categories();
			?>
			<p>
		   		<label for="<?php echo esc_attr( $this->get_field_id( 'category_id' ) ); ?>"><?php esc_html_e( 'Select From:', 'travel-insight-pro' ); ?></label>
		   		<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'category_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'category_id' ) ); ?>">
		   			<option value='' <?php selected( '', $category_id, true ); ?> ><?php esc_html_e( '--Select Category--', 'travel-insight-pro' ); ?></option>
		   			<?php foreach( $category_object as $cat_object ) : ?>
		   			<option value="<?php echo absint( $cat_object->term_id ); ?>" <?php selected( $cat_object->term_id, $category_id, true ); ?> ><?php echo esc_html( $cat_object->name ); ?></option>
		   			<?php endforeach; ?>
		   		</select>
		    </p>
			<?php endif;
		}

		/**
		* Processing widget options on save
		*
		* @param array $new_instance The new options
		* @param array $old_instance The previous options
		*/
		public function update( $new_instance, $old_instance ) {
			// processes widget options to be saved
			$instance                          = $old_instance;
			$instance['title']                 = sanitize_text_field( $new_instance['title'] );
			$instance['number']                = absint( $new_instance['number'] );
			$instance['post_type']             = in_array( $new_instance['post_type'], array( 'posts', 'category' ) ) ? sanitize_key( $new_instance['post_type'] ) : 'posts';
			$instance['category_id']           = absint( $new_instance['category_id'] );
			for ( $i =1; $i <= $instance['number']; $i++ ) {
				$instance['post-id-'. $i] = absint( $new_instance['post-id-'. $i] );
			}
			return $instance;
		}
	}
endif;

function travel_insight_pro_register_steps_slider_widget() {
	register_widget( 'Travel_Insight_Pro_Steps_Slider_Widget' );
}
add_action( 'widgets_init', 'travel_insight_pro_register_steps_slider_widget' );