<?php
/**
 * The template for displaying package search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

get_header(); 
$options = travel_insight_pro_get_theme_options();
$package_search_title = ! empty( $options['package_search_title'] ) ? $options['package_search_title'] : '';
$package_search_sub_title = ! empty( $options['package_search_sub_title'] ) ? $options['package_search_sub_title'] : '';
?>

<section id="destinations" class="page-section no-padding-bottom">
	<div class="wrapper">
		<?php if ( have_posts() ) : ?>
			<?php if ( ! empty( $package_search_title ) || ! empty( $package_search_sub_title ) ) : ?>
				<header class="entry-header text-center">
					<?php if ( ! empty( $package_search_title ) ) : ?>
						<h2 class="entry-title"><?php echo esc_html( $package_search_title ) ?></h2>
					<?php endif;
					if ( ! empty( $package_search_sub_title ) ) : ?>
						<h3 class="sub-title"><?php echo esc_html( $package_search_sub_title ); ?></h3>
					<?php endif; ?>
				</header><!-- .entry-header -->
			<?php endif; ?>

			<div class="entry-content col-3">
				<div class="destination-form text-center">
					<?php travel_insight_pro_package_search_form(); ?>
				</div><!-- .destination-form -->

				<div class="wonderful-places gallery-popup">
					<div class="row">
						<?php 
						$i = 1;
						while ( have_posts() ) : the_post();
							$image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_id() ), 'full' ); 
								if ( $i >= 4 ) {
									$i = 1;
								} ?>
								<div class="column-wrapper">
									<?php if ( $i !== 2 ) : ?>
										<div class="featured-image">
											<a href="<?php the_permalink(); ?>">
												<?php 
												if ( has_post_thumbnail() ) :
													the_post_thumbnail( 'travel-insight-pro-portrait', $attr = array( 'alt' => the_title_attribute( 'echo=0' ) ) ); 
												else : ?>
													<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/uploads/no-featured-image-500x500.jpg" alt="<?php the_title_attribute(); ?>">
												<?php endif; ?>
											</a>
											<a href="<?php echo esc_url( $image[0] ); ?>" class="popup">
											<?php echo travel_insight_pro_get_svg( array( 'icon' => 'zoom-in' ) ); ?></a>
										</div><!-- .featured-image -->
									<?php endif; ?>

									<div class="destination-details clear text-center">
										<div class="places-content">
											<?php if ( function_exists( 'tp_package_destination' ) && ! empty( tp_package_destination() ) ) : ?>
												<span><?php echo esc_html( tp_package_destination() ); ?></span>
											<?php endif; ?>
											<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
											<?php the_excerpt(); ?>
										</div><!-- .places-content -->

										<div class="destination-footer">
											<?php if ( function_exists( 'tp_package_difficulty' ) && ! empty( tp_package_difficulty() ) ) : ?>
												<div class="pull-left">
													<h4><?php esc_html_e( 'Difficulty', 'travel-insight-pro' ); ?></h4>
													<span><?php echo esc_html( tp_package_difficulty() ); ?></span>
												</div><!-- .pull-left -->
											<?php endif; 
											if ( function_exists( 'tp_package_date' ) && ! empty( tp_package_date() ) ) : ?>
												<div class="pull-right">
													<h4><?php esc_html_e( 'Departure', 'travel-insight-pro' ); ?></h4>
													<time><?php echo esc_html( tp_package_date() ); ?></time>
												</div><!-- .pull-right -->
											<?php endif; ?>
										</div><!-- .destinaion-footer -->
									</div><!-- .destination-details -->
									<?php if ( $i === 2 ) : ?>
										<div class="featured-image">
											<a href="<?php the_permalink(); ?>">
												<?php 
												if ( has_post_thumbnail() ) :
													the_post_thumbnail( 'travel-insight-pro-portrait', $attr = array( 'alt' => the_title_attribute( 'echo=0' ) ) ); 
												else : ?>
													<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/uploads/no-featured-image-500x500.jpg" alt="<?php the_title_attribute(); ?>">
												<?php endif; ?>
											</a>
											<a href="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/uploads/no-featured-image-500x500.jpg" class="popup">
											<?php echo travel_insight_pro_get_svg( array( 'icon' => 'zoom-in' ) ); ?></a>
										</div><!-- .featured-image -->
									<?php endif; ?>
								</div><!-- .column-wrapper -->
								<?php if ( $i == 3 ) : ?>
									</div><!-- .row -->
									<div class="row">
								<?php endif; ?>
							<?php $i++; 
						endwhile; ?>
					</div><!-- .row -->
				</div><!-- .wonderful-places -->
			</div><!-- .entry-content -->
		<?php 
		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;

		/**
		* Hook - travel_insight_pro_action_pagination.
		*
		* @hooked travel_insight_pro_pagination
		*/
		do_action( 'travel_insight_pro_action_pagination' ); 

		/**
		* Hook - travel_insight_pro_infinite_loader_spinner_action.
		*
		* @hooked travel_insight_pro_infinite_loader_spinner 
		*/
		do_action( 'travel_insight_pro_infinite_loader_spinner_action' ); 
		?>
	</div><!-- .wrapper -->
</section><!-- #destinations -->

   
<?php
get_footer();
